/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculatorVisitor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/ClassNameCalculator;", "", "()V", "getClassName", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getClassNames", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm-debugger.base.util"})
public final class ClassNameCalculator {
    @NotNull
    public static final ClassNameCalculator INSTANCE = new ClassNameCalculator();

    private ClassNameCalculator() {
    }

    @NotNull
    public final Map<KtElement, String> getClassNames(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file2), () -> ClassNameCalculator.getClassNames$lambda$0(file2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Map)object;
    }

    @Nullable
    public final String getClassName(@NotNull KtElement element3) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtFunctionLiteral) {
            PsiElement psiElement2 = ((KtFunctionLiteral)element3).getParent();
            KtLambdaExpression ktLambdaExpression2 = psiElement2 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement2 : null;
            if (ktLambdaExpression2 == null) {
                ktLambdaExpression2 = element3;
            }
            ktElement = (KtElement)ktLambdaExpression2;
        } else {
            ktElement = element3;
        }
        KtElement target2 = ktElement;
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        return this.getClassNames(ktFile).get(target2);
    }

    private static final CachedValueProvider.Result getClassNames$lambda$0(KtFile $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        ClassNameCalculatorVisitor visitor2 = new ClassNameCalculatorVisitor();
        $file.accept((PsiElementVisitor)visitor2);
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result(visitor2.getAllNames(), objectArray);
    }
}

