/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.SourceCode;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.LogicDelegate;
import org.jetbrains.kotlin.idea.core.script.NewLogicDelegate;
import org.jetbrains.kotlin.idea.core.script.OldLogicDelegate;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManagerKt;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\u0006\u0010 \u001a\u00020\u000eR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "delegate", "Lorg/jetbrains/kotlin/idea/core/script/LogicDelegate;", "dispose", "", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "", "getAllDefinitions", "", "getDefaultDefinition", "isReady", "", "reloadDefinitionsBy", "source", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "reloadScriptDefinitions", "reloadScriptDefinitionsIfNeeded", "reorderScriptDefinitions", "Companion", "kotlin.base.scripting"})
public final class ScriptDefinitionsManager
extends LazyScriptDefinitionProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LogicDelegate delegate;

    public ScriptDefinitionsManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.delegate = ScriptDefinitionsManagerKt.getLoadScriptDefinitionsOnDemand() ? (LogicDelegate)new NewLogicDelegate(this.project) : (LogicDelegate)new OldLogicDelegate(this.project);
    }

    @Override
    @NotNull
    protected Sequence<ScriptDefinition> getCurrentDefinitions() {
        return this.delegate.getCurrentDefinitions();
    }

    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.delegate.findDefinition(script);
    }

    @Override
    @Deprecated(message="Migrating to configuration refinement", level=DeprecationLevel.ERROR)
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.delegate.findScriptDefinition(fileName);
    }

    @NotNull
    public final List<ScriptDefinition> getAllDefinitions() {
        return this.delegate.getAllDefinitions();
    }

    @NotNull
    public final List<ScriptDefinition> reloadScriptDefinitionsIfNeeded() {
        return this.delegate.reloadScriptDefinitionsIfNeeded();
    }

    @NotNull
    public final List<ScriptDefinition> reloadScriptDefinitions() {
        return this.delegate.reloadScriptDefinitions();
    }

    public final boolean isReady() {
        return this.delegate.isReady();
    }

    @NotNull
    public final List<ScriptDefinition> reloadDefinitionsBy(@NotNull ScriptDefinitionsSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.delegate.reloadDefinitionsBy(source);
    }

    public final void reorderScriptDefinitions() {
        this.delegate.reorderScriptDefinitions();
    }

    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        return this.delegate.getDefaultDefinition();
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.delegate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.scripting"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinitionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,586:1\n30#2,3:587\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion\n*L\n89#1:587,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptDefinitionsManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ScriptDefinitionProvider> serviceClass$iv = ScriptDefinitionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ScriptDefinitionsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

