/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.formatter;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0000J\u0013\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0011\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\tH\u0016J\u0016\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\rJ\u000e\u0010$\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\"H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "Lcom/intellij/openapi/util/JDOMExternalizable;", "", "()V", "entries", "", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "(Ljava/util/List;)V", "entryCount", "", "getEntryCount", "()I", "addEntry", "", "entry", "clone", "contains", "", "packageName", "", "copyFrom", "packageTable", "equals", "other", "", "getEntries", "", "()[Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "getEntryAt", "index", "hashCode", "insertEntryAt", "readExternal", "element", "Lorg/jdom/Element;", "removeEmptyPackages", "removeEntryAt", "setEntryAt", "writeExternal", "parentNode", "kotlin.formatter"})
@SourceDebugExtension(value={"SMAP\nKotlinPackageEntryTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPackageEntryTable.kt\norg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n37#2,2:107\n1747#3,3:109\n1855#3,2:112\n*S KotlinDebug\n*F\n+ 1 KotlinPackageEntryTable.kt\norg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable\n*L\n26#1:107,2\n46#1:109,3\n60#1:112,2\n*E\n"})
public final class KotlinPackageEntryTable
implements JDOMExternalizable,
Cloneable {
    @NotNull
    private final List<KotlinPackageEntry> entries;

    public KotlinPackageEntryTable(@NotNull List<KotlinPackageEntry> entries2) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        this.entries = entries2;
    }

    public KotlinPackageEntryTable() {
        this(new ArrayList());
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    @NotNull
    public KotlinPackageEntryTable clone() {
        KotlinPackageEntryTable clone2 = new KotlinPackageEntryTable();
        clone2.copyFrom(this);
        return clone2;
    }

    public final void copyFrom(@NotNull KotlinPackageEntryTable packageTable) {
        Intrinsics.checkNotNullParameter((Object)packageTable, (String)"packageTable");
        this.entries.clear();
        this.entries.addAll((Collection<KotlinPackageEntry>)packageTable.entries);
    }

    @NotNull
    public final KotlinPackageEntry[] getEntries() {
        Collection $this$toTypedArray$iv = this.entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new KotlinPackageEntry[0]);
    }

    public final void insertEntryAt(@NotNull KotlinPackageEntry entry, int index) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(index, entry);
    }

    public final void removeEntryAt(int index) {
        this.entries.remove(index);
    }

    @NotNull
    public final KotlinPackageEntry getEntryAt(int index) {
        return this.entries.get(index);
    }

    public final void setEntryAt(@NotNull KotlinPackageEntry entry, int index) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.set(index, entry);
    }

    public final boolean contains(@NotNull String packageName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinPackageEntry it = (KotlinPackageEntry)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isSpecial() && it.matchesPackageName(packageName))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void removeEmptyPackages() {
        CollectionsKt.removeAll(this.entries, (Function1)removeEmptyPackages.1.INSTANCE);
    }

    public final void addEntry(@NotNull KotlinPackageEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    public void readExternal(@NotNull Element element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        this.entries.clear();
        List list2 = element3.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"package")) continue;
            String string2 = string = it.getAttributeValue("name");
            if (string2 == null) {
                throw new InvalidDataException();
            }
            Intrinsics.checkNotNull((Object)string2);
            String packageName = string;
            String string3 = it.getAttributeValue("alias");
            boolean alias = string3 != null ? Boolean.parseBoolean(string3) : false;
            String string4 = it.getAttributeValue("withSubpackages");
            boolean withSubpackages = string4 != null ? Boolean.parseBoolean(string4) : false;
            KotlinPackageEntry entry = ((CharSequence)packageName).length() == 0 && !alias ? KotlinPackageEntry.ALL_OTHER_IMPORTS_ENTRY : (((CharSequence)packageName).length() == 0 && alias ? KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY : new KotlinPackageEntry(packageName, withSubpackages));
            this.entries.add(entry);
        }
    }

    public void writeExternal(@NotNull Element parentNode) {
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        for (KotlinPackageEntry entry : this.entries) {
            Element element3 = new Element("package");
            parentNode.addContent(element3);
            String name2 = entry.isSpecial() ? "" : entry.getPackageName();
            boolean alias = Intrinsics.areEqual((Object)entry, (Object)KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY);
            element3.setAttribute("name", name2);
            element3.setAttribute("alias", String.valueOf(alias));
            element3.setAttribute("withSubpackages", String.valueOf(entry.getWithSubpackages()));
        }
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof KotlinPackageEntryTable)) {
            return false;
        }
        if (this.getEntryCount() != ((KotlinPackageEntryTable)other2).getEntryCount()) {
            return false;
        }
        int n = this.entries.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Intrinsics.areEqual((Object)this.entries.get(i2), (Object)((KotlinPackageEntryTable)other2).entries.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        KotlinPackageEntry kotlinPackageEntry = (KotlinPackageEntry)CollectionsKt.firstOrNull(this.entries);
        return kotlinPackageEntry != null ? kotlinPackageEntry.hashCode() : 0;
    }
}

