/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.core.IterableTypesDetector;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.kotlin.util.ModifierChecksKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection;", "", "project", "Lcom/intellij/openapi/project/Project;", "forLoopConventionsChecker", "Lorg/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "createDetector", "Lorg/jetbrains/kotlin/idea/core/IterableTypesDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Companion", "Detector", "kotlin.base.fe10.analysis"})
public final class IterableTypesDetection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private static final Name iteratorName;

    public IterableTypesDetection(@NotNull Project project2, @NotNull ForLoopConventionsChecker forLoopConventionsChecker, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)forLoopConventionsChecker, (String)"forLoopConventionsChecker");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.project = project2;
        this.forLoopConventionsChecker = forLoopConventionsChecker;
        this.languageVersionSettings = languageVersionSettings2;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @NotNull
    public final IterableTypesDetector createDetector(@NotNull LexicalScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return new Detector(scope2);
    }

    static {
        Name name2 = Name.identifier((String)"iterator");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        iteratorName = name2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection$Companion;", "", "()V", "iteratorName", "Lorg/jetbrains/kotlin/name/Name;", "kotlin.base.fe10.analysis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\nH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection$Detector;", "Lorg/jetbrains/kotlin/idea/core/IterableTypesDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "(Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;)V", "cache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "typesWithExtensionIterator", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "canBeIterable", "", "type", "elementType", "elementTypeNoCache", "isIterable", "loopVarType", "kotlin.base.fe10.analysis"})
    @SourceDebugExtension(value={"SMAP\nIterableTypesDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IterableTypesDetection.kt\norg/jetbrains/kotlin/idea/core/IterableTypesDetection$Detector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n*L\n1#1,94:1\n766#2:95\n857#2,2:96\n1603#2,9:98\n1855#2:107\n1856#2:109\n1612#2:110\n1747#2,2:118\n1603#2,9:120\n1855#2:129\n1856#2:131\n1612#2:132\n1749#2:133\n1#3:108\n1#3:130\n48#4,7:111\n*S KotlinDebug\n*F\n+ 1 IterableTypesDetection.kt\norg/jetbrains/kotlin/idea/core/IterableTypesDetection$Detector\n*L\n47#1:95\n47#1:96,2\n48#1:98,9\n48#1:107\n48#1:109\n48#1:110\n80#1:118,2\n81#1:120,9\n81#1:129\n81#1:131\n81#1:132\n80#1:133\n48#1:108\n81#1:130\n59#1:111,7\n*E\n"})
    private final class Detector
    implements IterableTypesDetector {
        @NotNull
        private final LexicalScope scope;
        @NotNull
        private final HashMap<FuzzyType, FuzzyType> cache;
        @NotNull
        private final Collection<KotlinType> typesWithExtensionIterator;

        /*
         * WARNING - void declaration
         */
        public Detector(LexicalScope scope2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            this.scope = scope2;
            this.cache = new HashMap();
            Iterable iterable = ScopeUtilsKt.collectFunctions((HierarchicalScope)((HierarchicalScope)this.scope), (Name)iteratorName, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
            Detector detector = this;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                boolean bl = false;
                if (!ModifierChecksKt.isValidOperator((FunctionDescriptor)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                boolean bl2 = false;
                ReceiverParameterDescriptor receiverParameterDescriptor = it.getExtensionReceiverParameter();
                if ((receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            detector.typesWithExtensionIterator = (List)destination$iv$iv;
        }

        @Override
        public boolean isIterable(@NotNull FuzzyType type2, @Nullable KotlinType loopVarType) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            FuzzyType fuzzyType = this.elementType(type2);
            if (fuzzyType == null) {
                return false;
            }
            FuzzyType elementType = fuzzyType;
            return loopVarType == null || elementType.checkIsSubtypeOf(loopVarType) != null;
        }

        @Override
        public boolean isIterable(@NotNull KotlinType type2, @Nullable KotlinType loopVarType) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.isIterable(FuzzyTypeUtils.toFuzzyType(type2, CollectionsKt.emptyList()), loopVarType);
        }

        private final FuzzyType elementType(FuzzyType type2) {
            Object object;
            Map $this$getOrPutNullable$iv = this.cache;
            boolean $i$f$getOrPutNullable = false;
            if (!$this$getOrPutNullable$iv.containsKey(type2)) {
                boolean bl = false;
                FuzzyType answer$iv = this.elementTypeNoCache(type2);
                $this$getOrPutNullable$iv.put(type2, answer$iv);
                object = answer$iv;
            } else {
                object = $this$getOrPutNullable$iv.get(type2);
            }
            return (FuzzyType)object;
        }

        @Override
        @Nullable
        public FuzzyType elementType(@NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.elementType(FuzzyTypeUtils.toFuzzyType(type2, CollectionsKt.emptyList()));
        }

        private final FuzzyType elementTypeNoCache(FuzzyType type2) {
            KotlinType elementType;
            if (!this.canBeIterable(type2)) {
                return null;
            }
            KtExpression expression2 = new KtPsiFactory(IterableTypesDetection.this.project, false, 2, null).createExpression("fake");
            ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext((BindingTrace)((BindingTrace)new BindingTraceContext()), (LexicalScope)this.scope, (DataFlowInfo)DataFlowInfo.Companion.getEMPTY(), (KotlinType)((KotlinType)TypeUtils.NO_EXPECTED_TYPE), (LanguageVersionSettings)IterableTypesDetection.this.languageVersionSettings, (DataFlowValueFactory)IterableTypesDetection.this.dataFlowValueFactory);
            Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext, (String)"newContext(...)");
            ExpressionTypingContext context2 = expressionTypingContext;
            KotlinType kotlinType = type2.getType();
            BindingContext bindingContext2 = context2.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"getBindingContext(...)");
            ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(expression2, kotlinType, bindingContext2);
            KotlinType kotlinType2 = elementType = IterableTypesDetection.this.forLoopConventionsChecker.checkIterableConvention(expressionReceiver, context2);
            return kotlinType2 != null ? FuzzyTypeUtils.toFuzzyType(kotlinType2, (Collection<? extends TypeParameterDescriptor>)type2.getFreeParameters()) : null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canBeIterable(FuzzyType type2) {
            boolean bl;
            if (type2.getType().getConstructor() instanceof IntegerLiteralTypeConstructor) {
                return false;
            }
            if (!type2.getType().getMemberScope().getContributedFunctions(iteratorName, (LookupLocation)NoLookupLocation.FROM_IDE).isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            Iterable $this$any$iv = this.typesWithExtensionIterator;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                void $this$mapNotNullTo$iv$iv;
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KotlinType it = (KotlinType)element$iv;
                boolean bl3 = false;
                Iterable $this$mapNotNull$iv = it.getArguments();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    TypeParameterDescriptor it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    TypeProjection it2 = (TypeProjection)element$iv$iv;
                    boolean bl5 = false;
                    ClassifierDescriptor classifierDescriptor = it2.getType().getConstructor().getDeclarationDescriptor();
                    if ((classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List freeParams = (List)destination$iv$iv;
                if (type2.checkIsSubtypeOf(FuzzyTypeUtils.toFuzzyType(it, freeParams)) != null) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }
    }
}

