/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.DataFlavor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/KotlinFilePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isPasteEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPastePossible", "performPaste", "", "kotlin.idea"})
public final class KotlinFilePasteProvider
implements PasteProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        IdeView ideView;
        Project project2;
        String text2;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                String string = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
                if (string == null) {
                    return;
                }
                text2 = string;
                project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
                if (project2 == null || ideView == null) break block6;
                PsiDirectory[] psiDirectoryArray = ideView.getDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                if (!(((Object[])psiDirectoryArray).length == 0)) break block7;
            }
            return;
        }
        KtFile ktFile = new KtPsiFactory(project2, false, 2, null).createFile(text2);
        Object object = (KtDeclaration)CollectionsKt.firstOrNull((List)ktFile.getDeclarations());
        if (object == null || (object = object.getName()) == null) {
            return;
        }
        String fileName = (String)object + ".kt";
        PsiDirectory psiDirectory = ideView.getOrChooseDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        ApplicationUtilsKt.executeWriteCommand(project2, KotlinBundle.message("create.kotlin.file", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(directory, fileName, project2, text2){
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $text;
            {
                this.$directory = $directory;
                this.$fileName = $fileName;
                this.$project = $project;
                this.$text = $text;
                super(0);
            }

            public final void invoke() {
                PsiFile psiFile2;
                try {
                    psiFile2 = this.$directory.createFile(this.$fileName);
                }
                catch (IncorrectOperationException e) {
                    return;
                }
                PsiFile psiFile3 = psiFile2;
                Intrinsics.checkNotNull((Object)psiFile3);
                PsiFile file2 = psiFile3;
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.$project);
                Document document = documentManager.getDocument(file2);
                if (document != null) {
                    String qualifiedName2;
                    document.setText((CharSequence)this.$text);
                    documentManager.commitDocument(document);
                    JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
                    String string = javaDirectoryService != null && (javaDirectoryService = javaDirectoryService.getPackage(this.$directory)) != null ? javaDirectoryService.getQualifiedName() : (qualifiedName2 = null);
                    if (qualifiedName2 != null && file2 instanceof KtFile) {
                        ((KtFile)file2).setPackageFqName(new FqName(qualifiedName2));
                    }
                    new OpenFileDescriptor(this.$project, file2.getVirtualFile()).navigate(true);
                }
            }
        }));
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Project project2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
                if (project2 == null || ideView == null) break block5;
                PsiDirectory[] psiDirectoryArray = ideView.getDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                if (!(((Object[])psiDirectoryArray).length == 0)) break block6;
            }
            return false;
        }
        String string = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (string == null) {
            return false;
        }
        String text2 = string;
        if (StringsKt.contains$default((CharSequence)text2, (CharSequence)";\n", (boolean)false, (int)2, null) || (StringsKt.contains$default((CharSequence)text2, (CharSequence)"public interface", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text2, (CharSequence)"public class", (boolean)false, (int)2, null)) && !StringsKt.contains$default((CharSequence)text2, (CharSequence)"fun ", (boolean)false, (int)2, null)) {
            return false;
        }
        KtFile file2 = new KtPsiFactory(project2, false, 2, null).createFile(text2);
        return !PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)file2));
    }
}

