/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.analysis.RootPrefixUtils;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinCallableInsertHandler;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/BaseDeclarationInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "getCallType", "()Lorg/jetbrains/kotlin/idea/util/CallType;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Companion", "kotlin.completion.impl-k1"})
public abstract class KotlinCallableInsertHandler
extends BaseDeclarationInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CallType<?> callType;
    @NotNull
    private static final ShortenReferences SHORTEN_REFERENCES = new ShortenReferences((Function1<? super KtElement, ShortenReferences.Options>)((Function1)Companion.SHORTEN_REFERENCES.1.INSTANCE));

    public KotlinCallableInsertHandler(@NotNull CallType<?> callType) {
        Intrinsics.checkNotNullParameter(callType, (String)"callType");
        this.callType = callType;
    }

    @NotNull
    public final CallType<?> getCallType() {
        return this.callType;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        super.handleInsert(context2, item);
        Companion.addImport(context2, item, this.callType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler$Companion;", "", "()V", "SHORTEN_REFERENCES", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "getSHORTEN_REFERENCES", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "addImport", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "kotlin.completion.impl-k1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShortenReferences getSHORTEN_REFERENCES() {
            return SHORTEN_REFERENCES;
        }

        public final void addImport(@NotNull InsertionContext context2, @NotNull LookupElement item, @NotNull CallType<?> callType) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter(callType, (String)"callType");
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            psiDocumentManager.commitDocument(context2.getDocument());
            PsiFile psiFile2 = context2.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
            PsiFile file2 = psiFile2;
            Object object = item.getObject();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
            Object o = object;
            if (file2 instanceof KtFile && o instanceof DescriptorBasedDeclarationLookupObject) {
                DeclarationDescriptor declarationDescriptor = ((DescriptorBasedDeclarationLookupObject)o).getDescriptor();
                CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
                if (callableDescriptor == null) {
                    return;
                }
                CallableDescriptor descriptor2 = callableDescriptor;
                if (descriptor2.getExtensionReceiverParameter() != null || callType instanceof CallType.CallableReference) {
                    if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)) && !CompletionUtilsKt.isArtificialImportAliasedDescriptor((DeclarationDescriptor)descriptor2)) {
                        Project project2 = context2.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(project2), (KtFile)file2, (DeclarationDescriptor)descriptor2, false, 4, null);
                    }
                } else if (Intrinsics.areEqual(callType, (Object)CallType.DEFAULT.INSTANCE)) {
                    if (CompletionUtilsKt.isArtificialImportAliasedDescriptor((DeclarationDescriptor)descriptor2)) {
                        return;
                    }
                    FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
                    if (fqName2 == null) {
                        return;
                    }
                    FqName fqName3 = fqName2;
                    context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)(RenderingUtilsKt.render((FqName)RootPrefixUtils.withRootPrefixIfNeeded$default(fqName3, null, 1, null)) + " "));
                    psiDocumentManager.commitDocument(context2.getDocument());
                    CompletionUtilsKt.shortenReferences(context2, context2.getStartOffset(), context2.getTailOffset() - 1, this.getSHORTEN_REFERENCES());
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(context2.getDocument());
                    Document document = context2.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                    if (HandlerUtilsKt.isTextAt(document, context2.getTailOffset() - 1, " ")) {
                        context2.getDocument().deleteString(context2.getTailOffset() - 1, context2.getTailOffset());
                    }
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

