/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.contributors.helpers;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.completion.contributors.helpers.CompletionHelpersKt;
import org.jetbrains.kotlin.idea.completion.contributors.helpers.SuperCallLookupObject;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallInsertionHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "TOKENS_BEFORE_CLOSING_ANGLE_BRACKET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getCorrectedTailOffsetForSuperCall", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "(Lcom/intellij/codeInsight/completion/InsertionContext;)Ljava/lang/Integer;", "handleInsert", "", "item", "replaceWithClassIdAndShorten", "lookupObject", "Lorg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallLookupObject;", "skipTokensAndGetExpectedTokenOrNull", "Lcom/intellij/psi/PsiElement;", "tokensToSkip", "expectedToken", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.completion.impl-k2"})
@SourceDebugExtension(value={"SMAP\nFirSuperEntriesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuperEntriesProvider.kt\norg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallInsertionHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n179#2,2:84\n1#3:86\n*S KotlinDebug\n*F\n+ 1 FirSuperEntriesProvider.kt\norg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallInsertionHandler\n*L\n72#1:84,2\n*E\n"})
public final class SuperCallInsertionHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final SuperCallInsertionHandler INSTANCE = new SuperCallInsertionHandler();
    @NotNull
    private static final TokenSet TOKENS_BEFORE_CLOSING_ANGLE_BRACKET;

    private SuperCallInsertionHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.contributors.helpers.SuperCallLookupObject");
        SuperCallLookupObject lookupObject = (SuperCallLookupObject)object;
        this.replaceWithClassIdAndShorten(lookupObject, context2);
        if (context2.getCompletionChar() != '.') {
            CompletionHelpersKt.insertStringAndInvokeCompletion(context2, ".");
        }
    }

    private final void replaceWithClassIdAndShorten(SuperCallLookupObject lookupObject, InsertionContext context2) {
        String string = lookupObject.getReplaceTo();
        if (string == null) {
            return;
        }
        String replaceTo = string;
        Integer n = this.getCorrectedTailOffsetForSuperCall(context2);
        context2.setTailOffset(n != null ? n.intValue() : context2.getTailOffset());
        context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)replaceTo);
        context2.commitDocument();
        if (lookupObject.getShortenReferencesInReplaced()) {
            PsiFile psiFile2 = context2.getFile();
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile targetFile2 = (KtFile)psiFile2;
            ShortenUtilsKt.shortenReferencesInRange$default(targetFile2, new TextRange(context2.getStartOffset(), context2.getTailOffset()), null, null, 12, null);
        }
    }

    private final Integer getCorrectedTailOffsetForSuperCall(InsertionContext context2) {
        Integer n;
        PsiElement dotToken;
        PsiElement psiElement2;
        PsiElement gtToken;
        PsiElement psiElement3 = context2.getFile().findElementAt(context2.getStartOffset());
        if (psiElement3 == null) {
            return null;
        }
        PsiElement tokenAtPosition = psiElement3;
        KtSingleValueToken ktSingleValueToken = KtTokens.GT;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"GT");
        PsiElement psiElement4 = gtToken = this.skipTokensAndGetExpectedTokenOrNull(tokenAtPosition, TOKENS_BEFORE_CLOSING_ANGLE_BRACKET, ktSingleValueToken);
        if (psiElement4 != null) {
            TokenSet tokenSet = KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITE_SPACE_OR_COMMENT_BIT_SET");
            KtSingleValueToken ktSingleValueToken2 = KtTokens.DOT;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken2, (String)"DOT");
            psiElement2 = this.skipTokensAndGetExpectedTokenOrNull(psiElement4, tokenSet, ktSingleValueToken2);
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement5 = dotToken = psiElement2;
        if (psiElement5 != null) {
            n = PsiUtilsKt.getEndOffset(psiElement5);
        } else {
            PsiElement psiElement6 = gtToken;
            n = psiElement6 != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement6)) : null;
        }
        return n;
    }

    private final PsiElement skipTokensAndGetExpectedTokenOrNull(PsiElement $this$skipTokensAndGetExpectedTokenOrNull, TokenSet tokensToSkip, KtSingleValueToken expectedToken) {
        Object object;
        Object v0;
        block3: {
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.getNextLeafs((PsiElement)$this$skipTokensAndGetExpectedTokenOrNull);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!tokensToSkip.contains(it.getNode().getElementType()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PsiElement psiElement2 = v0;
        if (psiElement2 != null) {
            PsiElement psiElement3;
            PsiElement it = psiElement3 = psiElement2;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)expectedToken) ? psiElement3 : null;
        } else {
            object = null;
        }
        return object;
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IDENTIFIER, KtTokens.DOT, KtTokens.LT};
        tokenSetArray[0] = TokenSet.create((IElementType[])iElementTypeArray);
        tokenSetArray[1] = KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET;
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        TOKENS_BEFORE_CLOSING_ANGLE_BRACKET = tokenSet;
    }
}

