/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.signatures.KtCallableSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtNonErrorClassType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001b\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007R\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u00020\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0019\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0007R\u00020\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"getInlineArgumentSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtFunction;)Lorg/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol;", "isArrayGeneratorConstructorCall", "", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;)Z", "isInlinedArgument", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtFunction;)Z", "kotlin.code-insight.utils"})
public final class InlineUtilsKt {
    @ApiStatus.Internal
    public static final boolean isInlinedArgument(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtFunction argument2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        return InlineUtilsKt.getInlineArgumentSymbol($context_receiver_0, argument2) != null;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KtValueParameterSymbol getInlineArgumentSymbol(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtFunction argument2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (!(argument2 instanceof KtFunctionLiteral) && !(argument2 instanceof KtNamedFunction)) {
            return null;
        }
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)argument2));
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression parentCallExpression = ktCallExpression;
        KtLifetimeOwner ktLifetimeOwner = $context_receiver_0.resolveCall((KtElement)parentCallExpression);
        if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.successfulFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null) {
            return null;
        }
        KtLifetimeOwner parentCall2 = ktLifetimeOwner;
        KtFunctionLikeSymbol symbol2 = (KtFunctionLikeSymbol)KtCallKt.getSymbol(((KtCallableMemberCall)parentCall2).getPartiallyAppliedSymbol());
        if (symbol2 instanceof KtFunctionSymbol && ((KtFunctionSymbol)symbol2).isInline() || InlineUtilsKt.isArrayGeneratorConstructorCall($context_receiver_0, symbol2)) {
            KtValueArgument ktValueArgument = KotlinPsiUtils.getContainingValueArgument(parentCallExpression, (KtExpression)argument2);
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument valueArgument = ktValueArgument;
            KtLifetimeOwner ktLifetimeOwner2 = (KtVariableLikeSignature)((Map)((KtFunctionCall)parentCall2).getArgumentMapping()).get(valueArgument.getArgumentExpression());
            if (ktLifetimeOwner2 == null || (ktLifetimeOwner2 = (KtValueParameterSymbol)((KtCallableSignature)ktLifetimeOwner2).getSymbol()) == null) {
                return null;
            }
            KtLifetimeOwner argumentSymbol = ktLifetimeOwner2;
            if (((KtValueParameterSymbol)argumentSymbol).isNoinline()) {
                return null;
            }
            KtType parameterType = ((KtCallableSymbol)argumentSymbol).getReturnType();
            if (!$context_receiver_0.isMarkedNullable(parameterType) && ($context_receiver_0.isFunctionType(parameterType) || $context_receiver_0.isSuspendFunctionType(parameterType))) {
                return argumentSymbol;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArrayGeneratorConstructorCall(KtAnalysisSession $context_receiver_0, KtFunctionLikeSymbol symbol2) {
        if (symbol2 instanceof KtConstructorSymbol) {
            ClassId classId = ((KtConstructorSymbol)symbol2).getContainingClassIdIfNonLocal();
            if (!Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray()) && !StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().containsKey(classId)) {
                if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(classId)) return false;
            }
            boolean bl = true;
            boolean isArrayClass = bl;
            if (!isArrayClass) return false;
            if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($context_receiver_0, symbol2)) return false;
            return true;
        }
        if (!(symbol2 instanceof KtFunctionSymbol)) return false;
        if (!symbol2.isExtension()) return false;
        KtType receiverType2 = KtCallableSymbolKt.getReceiverType(symbol2);
        if (!(receiverType2 instanceof KtNonErrorClassType)) return false;
        if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(((KtNonErrorClassType)receiverType2).getClassId())) return false;
        CallableId callableId = symbol2.getCallableIdIfNonLocal();
        if (!Intrinsics.areEqual((Object)(callableId != null ? callableId.getPackageName() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($context_receiver_0, symbol2)) return false;
        return true;
    }

    private static final boolean isArrayGeneratorConstructorCall$checkParameters(KtAnalysisSession $$context_receiver_0, KtFunctionLikeSymbol symbol2) {
        return symbol2.getValueParameters().size() == 2 && $$context_receiver_0.isInt(symbol2.getValueParameters().get(0).getReturnType()) && $$context_receiver_0.isFunctionType(symbol2.getValueParameters().get(1).getReturnType());
    }
}

