/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithModality;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.CallableOverridingsTooltip;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.ClassInheritorsTooltip;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.ImplementationsPopupHandler;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.SuperDeclarationPopupHandler;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.dsl.DslHighlightingMarkerKt;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.AbstractKotlinLineMarkerProvider;
import org.jetbrains.kotlin.idea.highlighter.markers.InheritanceMergeableLineMarkerInfo;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.searching.inheritors.DirectKotlinClassInheritorsSearch;
import org.jetbrains.kotlin.idea.searching.inheritors.KotlinSearchUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0002J$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0002J$\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0002J.\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0016\u0010\u0007\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bj\u0002`\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinLineMarkerProvider;", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/AbstractKotlinLineMarkerProvider;", "()V", "collectCallableOverridings", "", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectInheritedClassMarker", "Lorg/jetbrains/kotlin/psi/KtClass;", "collectSuperDeclarations", "declaration", "doCollectSlowLineMarkers", "elements", "", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/LineMarkerInfos;", "kotlin.code-insight.line-markers-k2"})
@SourceDebugExtension(value={"SMAP\nKotlinLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinLineMarkerProvider\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n27#2,2:273\n55#3:275\n69#3,7:276\n76#3:286\n1726#4,3:283\n*S KotlinDebug\n*F\n+ 1 KotlinLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinLineMarkerProvider\n*L\n100#1:273,2\n100#1:275\n100#1:276,7\n100#1:286\n108#1:283,3\n*E\n"})
public final class KotlinLineMarkerProvider
extends AbstractKotlinLineMarkerProvider {
    @Override
    public void doCollectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        for (PsiElement psiElement2 : elements2) {
            if (!(psiElement2 instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)psiElement2).getElementType(), (Object)KtTokens.IDENTIFIER)) continue;
            PsiElement psiElement22 = ((LeafPsiElement)psiElement2).getParent();
            KtNamedDeclaration ktNamedDeclaration = psiElement22 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement22 : null;
            if (ktNamedDeclaration == null) continue;
            KtNamedDeclaration declaration2 = ktNamedDeclaration;
            KtNamedDeclaration ktNamedDeclaration2 = declaration2;
            if (ktNamedDeclaration2 instanceof KtClass) {
                this.collectInheritedClassMarker((KtClass)declaration2, result2);
                DslHighlightingMarkerKt.collectHighlightingDslMarkers((KtClass)declaration2, result2);
                continue;
            }
            if (!(ktNamedDeclaration2 instanceof KtCallableDeclaration)) continue;
            this.collectSuperDeclarations((KtCallableDeclaration)declaration2, result2);
            this.collectCallableOverridings((KtCallableDeclaration)declaration2, result2);
        }
    }

    private final void collectCallableOverridings(KtCallableDeclaration element3, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter;
        if (!KotlinSearchUsagesSupport.SearchUtils.INSTANCE.isOverridable((KtDeclaration)element3)) {
            return;
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element3));
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject klass2 = ktClassOrObject;
        if (!(klass2 instanceof KtClass)) {
            return;
        }
        boolean isAbstract = CallableOverridingsTooltip.INSTANCE.isAbstract(element3, (KtClass)klass2);
        GutterIconDescriptor.Option option = gutter = isAbstract ? KotlinLineMarkerOptions.INSTANCE.getImplementedOption() : KotlinLineMarkerOptions.INSTANCE.getOverriddenOption();
        if (!gutter.isEnabled()) {
            return;
        }
        if (SequencesKt.firstOrNull((Sequence)KotlinSearchUtilKt.findAllOverridings$default(element3, null, 1, null)) == null) {
            return;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)element3;
        }
        PsiElement psiElement3 = psiElement2;
        Intrinsics.checkNotNull((Object)psiElement3);
        PsiElement anchor = psiElement3;
        Icon icon = gutter.getIcon();
        if (icon == null) {
            return;
        }
        Icon icon2 = icon;
        TextRange textRange = anchor.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        InheritanceMergeableLineMarkerInfo lineMarkerInfo2 = new InheritanceMergeableLineMarkerInfo(anchor, textRange, icon2, (Function<? super PsiElement, String>)((Function)CallableOverridingsTooltip.INSTANCE), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)ImplementationsPopupHandler.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)new Function0<String>(gutter){
            final /* synthetic */ GutterIconDescriptor.Option $gutter;
            {
                this.$gutter = $gutter;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.$gutter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }
        }));
        NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo2), (String)KotlinBundle.message("highlighter.action.text.go.to.overridden.methods", new Object[0]), (String)"GotoImplementation");
        result2.add((LineMarkerInfo<?>)lineMarkerInfo2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void collectSuperDeclarations(KtCallableDeclaration declaration, Collection<? super LineMarkerInfo<?>> result) {
        if (!declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            v0 = declaration.getContainingFile();
            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            if (!((KtFile)v0).isCompiled()) {
                return;
            }
        }
        $i$f$analyze = false;
        v1 = ((KtElement)declaration).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
        var4_4 = KtAnalysisSessionProvider.Companion.getInstance(v1);
        $i$f$analyse = false;
        var6_6 = this_$iv$iv;
        analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)declaration);
        $i$f$analyse = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            block20: {
                $this$collectSuperDeclarations_u24lambda_u241 = analysisSession$iv$iv$iv;
                $i$a$-analyze-KotlinLineMarkerProvider$collectSuperDeclarations$1 = false;
                var11_11 = $this$collectSuperDeclarations_u24lambda_u241.getSymbol((KtDeclaration)declaration);
                if ((var11_11 instanceof KtCallableSymbol != false ? (KtCallableSymbol)var11_11 : null) == null) {
                    return;
                }
                callableSymbol = v2;
                if (callableSymbol instanceof KtValueParameterSymbol) {
                    v3 = ((KtValueParameterSymbol)callableSymbol).getGeneratedPrimaryConstructorProperty();
                    if (v3 == null) {
                        return;
                    }
                    callableSymbol = v3;
                }
                if ((allOverriddenSymbols = $this$collectSuperDeclarations_u24lambda_u241.getAllOverriddenSymbols(callableSymbol)).isEmpty()) {
                    return;
                }
                if (!(callableSymbol instanceof KtSymbolWithModality) || ((KtSymbolWithModality)callableSymbol).getModality() == Modality.ABSTRACT) ** GOTO lbl-1000
                $this$all$iv = allOverriddenSymbols;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v4 = true;
                } else {
                    for (E element$iv : $this$all$iv) {
                        it = (KtCallableSymbol)element$iv;
                        $i$a$-all-KotlinLineMarkerProvider$collectSuperDeclarations$1$implements$1 = false;
                        if (it instanceof KtSymbolWithModality != false && ((KtSymbolWithModality)it).getModality() == Modality.ABSTRACT) continue;
                        v4 = false;
                        break block20;
                    }
                    v4 = true;
                }
            }
            if (v4) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            implements = v5;
            v6 = gutter = implements != false ? KotlinLineMarkerOptions.INSTANCE.getImplementingOption() : KotlinLineMarkerOptions.INSTANCE.getOverridingOption();
            if (!gutter.isEnabled()) {
                return;
            }
            v7 = declaration.getNameIdentifier();
            if (v7 == null) {
                v7 = (PsiElement)declaration;
            }
            var16_18 = v7;
            Intrinsics.checkNotNull((Object)var16_18);
            anchor = var16_18;
            v8 = anchor.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getTextRange(...)");
            v9 = gutter.getIcon();
            Intrinsics.checkNotNull((Object)v9);
            lineMarkerInfo = new InheritanceMergeableLineMarkerInfo(anchor, v8, v9, (Function<? super PsiElement, String>)((Function)SuperDeclarationMarkerTooltip.INSTANCE), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)SuperDeclarationPopupHandler.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)new Function0<String>(gutter){
                final /* synthetic */ GutterIconDescriptor.Option $gutter;
                {
                    this.$gutter = $gutter;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = this.$gutter.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    return string;
                }
            }));
            NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo), (String)(declaration instanceof KtNamedFunction != false ? KotlinBundle.message("highlighter.action.text.go.to.super.method", new Object[0]) : KotlinBundle.message("highlighter.action.text.go.to.super.property", new Object[0])), (String)"GotoSuperMethod");
            var20_22 = result.add((LineMarkerInfo<?>)lineMarkerInfo);
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private final void collectInheritedClassMarker(KtClass element3, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter;
        if (!KotlinSearchUsagesSupport.SearchUtils.isInheritable(element3)) {
            return;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)element3;
        }
        PsiElement psiElement3 = psiElement2;
        Intrinsics.checkNotNull((Object)psiElement3);
        PsiElement anchor = psiElement3;
        boolean isInterface = element3.isInterface();
        GutterIconDescriptor.Option option = gutter = isInterface ? KotlinLineMarkerOptions.INSTANCE.getImplementedOption() : KotlinLineMarkerOptions.INSTANCE.getOverriddenOption();
        if (!gutter.isEnabled()) {
            return;
        }
        if (DirectKotlinClassInheritorsSearch.INSTANCE.search(element3).findFirst() == null) {
            return;
        }
        Icon icon = gutter.getIcon();
        if (icon == null) {
            return;
        }
        Icon icon2 = icon;
        TextRange textRange = anchor.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        InheritanceMergeableLineMarkerInfo lineMarkerInfo2 = new InheritanceMergeableLineMarkerInfo(anchor, textRange, icon2, (Function<? super PsiElement, String>)((Function)ClassInheritorsTooltip.INSTANCE), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)ImplementationsPopupHandler.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)new Function0<String>(gutter){
            final /* synthetic */ GutterIconDescriptor.Option $gutter;
            {
                this.$gutter = $gutter;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.$gutter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }
        }));
        NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo2), (String)(isInterface ? KotlinBundle.message("highlighter.action.text.go.to.implementations", new Object[0]) : KotlinBundle.message("highlighter.action.text.go.to.subclasses", new Object[0])), (String)"GotoImplementation");
        result2.add((LineMarkerInfo<?>)lineMarkerInfo2);
    }
}

