/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RenameClassToContainingFileNameIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "kotlin.code-insight.intentions-shared"})
@SourceDebugExtension(value={"SMAP\nRenameClassToContainingFileNameIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameClassToContainingFileNameIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RenameClassToContainingFileNameIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1747#2,3:40\n*S KotlinDebug\n*F\n+ 1 RenameClassToContainingFileNameIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RenameClassToContainingFileNameIntention\n*L\n28#1:40,3\n*E\n"})
public final class RenameClassToContainingFileNameIntention
extends SelfTargetingRangeIntention<KtClassOrObject> {
    public RenameClassToContainingFileNameIntention() {
        super(KtClassOrObject.class, KotlinBundle.lazyMessage("rename.class.to.containing.file.name", new Object[0]), null, 4, null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element3) {
        String fileName;
        block10: {
            block9: {
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                    if (!element3.isTopLevel()) {
                        return null;
                    }
                    String string = FileUtil.getNameWithoutExtension((String)element3.getContainingKtFile().getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                    fileName = string;
                    if (Intrinsics.areEqual((Object)fileName, (Object)element3.getName()) || ((CharSequence)fileName).length() == 0 || Character.isLowerCase(fileName.charAt(0)) || !Name.isValidIdentifier((String)fileName)) break block9;
                    Name name2 = Name.identifier((String)fileName);
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                    if (!Intrinsics.areEqual((Object)RenderingUtilsKt.render((Name)name2), (Object)fileName)) break block9;
                    Iterable $this$any$iv = element3.getContainingKtFile().getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof KtClassOrObject && Intrinsics.areEqual((Object)((KtClassOrObject)it).getName(), (Object)fileName))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block10;
            }
            return null;
        }
        Object[] objectArray = new Object[]{fileName};
        this.setTextGetter(KotlinBundle.lazyMessage("rename.class.to.0", objectArray));
        PsiElement psiElement2 = element3.getNameIdentifier();
        return psiElement2 != null ? psiElement2.getTextRange() : null;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFile file2 = ktFile;
        String string = FileUtil.getNameWithoutExtension((String)element3.getContainingKtFile().getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String fileName = string;
        new RenameProcessor(file2.getProject(), (PsiElement)element3, fileName, false, false).run();
    }
}

