/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.searching.usages.dialogs;

import com.intellij.ui.SimpleColoredComponent;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.findUsages.KotlinFindUsagesSupport;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

final class Utils {
    private Utils() {
    }

    public static void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent, @NotNull KtNamedDeclaration declaration2) {
        String renderedDeclaration;
        if (coloredComponent == null) {
            Utils.$$$reportNull$$$0(0);
        }
        if (declaration2 == null) {
            Utils.$$$reportNull$$$0(1);
        }
        if ((renderedDeclaration = KotlinFindUsagesSupport.Companion.tryRenderDeclarationCompactStyle((KtDeclaration)declaration2)) != null) {
            coloredComponent.append(renderedDeclaration);
        }
    }

    static boolean renameCheckbox(@NotNull JPanel panel2, @NotNull String srcText, @Nls @NotNull String destText) {
        JCheckBox checkbox2;
        if (panel2 == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if (srcText == null) {
            Utils.$$$reportNull$$$0(3);
        }
        if (destText == null) {
            Utils.$$$reportNull$$$0(4);
        }
        if ((checkbox2 = Utils.findCheckbox(panel2, srcText)) != null) {
            checkbox2.setText(destText);
            return true;
        }
        return false;
    }

    static void removeCheckbox(@NotNull JPanel panel2, @NotNull String srcText) {
        JCheckBox checkbox2;
        if (panel2 == null) {
            Utils.$$$reportNull$$$0(5);
        }
        if (srcText == null) {
            Utils.$$$reportNull$$$0(6);
        }
        if ((checkbox2 = Utils.findCheckbox(panel2, srcText)) != null) {
            panel2.remove(checkbox2.getParent());
        }
    }

    @Nullable
    private static JCheckBox findCheckbox(@NotNull JPanel panel2, @NotNull String srcText) {
        if (panel2 == null) {
            Utils.$$$reportNull$$$0(7);
        }
        if (srcText == null) {
            Utils.$$$reportNull$$$0(8);
        }
        JCheckBox checkBox = null;
        for (Component component2 : panel2.getComponents()) {
            JPanel jPanel2;
            if (component2 instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)component2;
                if (!jCheckBox.getText().equals(srcText)) break;
                checkBox = jCheckBox;
                break;
            }
            if (component2 instanceof JPanel && (checkBox = Utils.findCheckbox(jPanel2 = (JPanel)component2, srcText)) != null) break;
        }
        return checkBox;
    }

    private static boolean isInInterface(KtNamedDeclaration declaration2) {
        KtClass ktClass2;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)declaration2);
        return ktClassOrObject instanceof KtClass && (ktClass2 = (KtClass)ktClassOrObject).isInterface();
    }

    static boolean isOpen(KtNamedDeclaration declaration2) {
        KtClass ktClass2;
        KtClassOrObject ktClassOrObject;
        return Utils.isInInterface(declaration2) || declaration2.hasModifier(KtTokens.OPEN_KEYWORD) || declaration2.hasModifier(KtTokens.ABSTRACT_KEYWORD) || (ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)declaration2)) instanceof KtClass && ((ktClass2 = (KtClass)ktClassOrObject).hasModifier(KtTokens.OPEN_KEYWORD) || ktClass2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) && declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD) && !declaration2.hasModifier(KtTokens.FINAL_KEYWORD);
    }

    static boolean isAbstract(KtNamedDeclaration declaration2) {
        return declaration2.hasModifier(KtTokens.ABSTRACT_KEYWORD) || Utils.isAbstractInInterface(declaration2);
    }

    static boolean isAbstractInInterface(KtNamedDeclaration declaration2) {
        if (!Utils.isInInterface(declaration2)) {
            return false;
        }
        if (declaration2 instanceof KtProperty) {
            KtProperty ktProperty = (KtProperty)declaration2;
            return !ktProperty.hasInitializer() && !ktProperty.hasDelegate() && ktProperty.getAccessors().isEmpty();
        }
        if (declaration2 instanceof KtFunction) {
            KtFunction ktFunction = (KtFunction)declaration2;
            return !ktFunction.hasBody();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destText";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/base/searching/usages/dialogs/Utils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureLabelComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "renameCheckbox";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCheckbox";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findCheckbox";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

