/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.psi.unifier;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.unifier.KotlinPsiRange;
import org.jetbrains.kotlin.idea.base.psi.unifier.KotlinPsiRangeKt;
import org.jetbrains.kotlin.idea.base.psi.unifier.KotlinPsiUnificationResult;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019J\u0011\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0096\u0002JD\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00120\u0003\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00042 \u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0000\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u00120\u0016H\u0016R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0003\u001a\u001b\u001c\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001d\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange;", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "getElements", "()Ljava/util/List;", "isEmpty", "", "()Z", "isValid", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "contains", "element", "match", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiUnificationResult$Success;", "T", "scope", "unifier", "Lkotlin/Function2;", "Empty", "ListRange", "SmartListRange", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$Empty;", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$ListRange;", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$SmartListRange;", "kotlin.base.psi"})
@SourceDebugExtension(value={"SMAP\nKotlinPsiRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPsiRange.kt\norg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1726#2,3:115\n766#2:118\n857#2,2:119\n*S KotlinDebug\n*F\n+ 1 KotlinPsiRange.kt\norg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange\n*L\n57#1:115,3\n70#1:118\n70#1:119,2\n*E\n"})
public interface KotlinPsiRange {
    @NotNull
    public List<PsiElement> getElements();

    @NotNull
    public TextRange getTextRange();

    default public boolean isValid() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.getElements();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (it.isValid()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    default public boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    default public boolean contains(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        TextRange textRange = this.getTextRange();
        TextRange textRange2 = element3.getTextRange();
        if (textRange2 == null) {
            textRange2 = TextRange.EMPTY_RANGE;
        }
        return textRange.contains(textRange2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public <T> List<KotlinPsiUnificationResult.Success<T>> match(@NotNull PsiElement scope2, @NotNull Function2<? super KotlinPsiRange, ? super KotlinPsiRange, ? extends KotlinPsiUnificationResult.Success<T>> unifier) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(unifier, (String)"unifier");
        Iterable $this$filter$iv = this.getElements();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement p0 = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!KotlinPsiRangeKt.access$isSignificant(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List elements2 = (List)destination$iv$iv;
        if (elements2.isEmpty()) {
            List<KotlinPsiUnificationResult.Success<T>> list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
            return list2;
        }
        ArrayList matches = new ArrayList();
        scope2.accept((PsiElementVisitor)new KtTreeVisitorVoid(elements2, unifier, this, matches){
            final /* synthetic */ List<PsiElement> $elements;
            final /* synthetic */ Function2<KotlinPsiRange, KotlinPsiRange, KotlinPsiUnificationResult.Success<T>> $unifier;
            final /* synthetic */ KotlinPsiRange this$0;
            final /* synthetic */ ArrayList<KotlinPsiUnificationResult.Success<T>> $matches;
            {
                this.$elements = $elements;
                this.$unifier = $unifier;
                this.this$0 = $receiver;
                this.$matches = $matches;
            }

            public void visitKtElement(@NotNull KtElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                KotlinPsiRange range2 = KotlinPsiRangeKt.toRange$default(SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings$default((PsiElement)((PsiElement)element3), (boolean)false, (boolean)false, (int)3, null), (Function1)match.visitKtElement.range.1.INSTANCE), (int)this.$elements.size())), false, 1, null);
                KotlinPsiUnificationResult.Success result2 = (KotlinPsiUnificationResult.Success)this.$unifier.invoke((Object)range2, (Object)this.this$0);
                if (result2 instanceof KotlinPsiUnificationResult.StrictSuccess) {
                    this.$matches.add(result2);
                } else {
                    int matchCountSoFar = this.$matches.size();
                    super.visitKtElement(element3);
                    if (result2 instanceof KotlinPsiUnificationResult.WeakSuccess && this.$matches.size() == matchCountSoFar) {
                        this.$matches.add(result2);
                    }
                }
            }
        });
        return matches;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$Empty;", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange;", "()V", "elements", "", "Lcom/intellij/psi/PsiElement;", "getElements", "()Ljava/util/List;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "kotlin.base.psi"})
    public static final class Empty
    implements KotlinPsiRange {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @NotNull
        public List<PsiElement> getElements() {
            List<PsiElement> list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
            return list2;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$ListRange;", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "kotlin.base.psi"})
    public static final class ListRange
    implements KotlinPsiRange {
        @NotNull
        private final List<PsiElement> elements;

        public ListRange(@NotNull List<? extends PsiElement> elements2) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            this.elements = elements2;
        }

        @Override
        @NotNull
        public List<PsiElement> getElements() {
            return this.elements;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange startRange = ((PsiElement)CollectionsKt.first(this.getElements())).getTextRange();
            TextRange endRange = ((PsiElement)CollectionsKt.last(this.getElements())).getTextRange();
            if (startRange == null || endRange == null) {
                TextRange textRange = TextRange.EMPTY_RANGE;
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
                return textRange;
            }
            return new TextRange(startRange.getStartOffset(), endRange.getEndOffset());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$SmartListRange;", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "pointers", "Lcom/intellij/psi/SmartPsiElementPointer;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "kotlin.base.psi"})
    @SourceDebugExtension(value={"SMAP\nKotlinPsiRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPsiRange.kt\norg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$SmartListRange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1549#2:115\n1620#2,3:116\n1603#2,9:119\n1855#2:128\n1856#2:130\n1612#2:131\n1#3:129\n1#3:132\n*S KotlinDebug\n*F\n+ 1 KotlinPsiRange.kt\norg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange$SmartListRange\n*L\n34#1:115\n34#1:116,3\n38#1:119,9\n38#1:128\n38#1:130\n38#1:131\n38#1:129\n*E\n"})
    public static final class SmartListRange
    implements KotlinPsiRange {
        @NotNull
        private final List<SmartPsiElementPointer<PsiElement>> pointers;

        /*
         * WARNING - void declaration
         */
        public SmartListRange(@NotNull List<? extends PsiElement> elements2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Iterable iterable = elements2;
            SmartListRange smartListRange = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiElement psiElement2 = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SmartPointerManager.createPointer((PsiElement)it));
            }
            smartListRange.pointers = (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<PsiElement> getElements() {
            List elements2;
            List list2;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.pointers;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                SmartPsiElementPointer pointer = (SmartPsiElementPointer)element$iv$iv;
                boolean bl2 = false;
                if (pointer.getElement() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List it = list2 = (elements2 = (List)destination$iv$iv);
            boolean bl = false;
            List list3 = elements2.size() == this.pointers.size() ? list2 : null;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            return list3;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange;
            List<PsiElement> elements2 = this.getElements();
            if (!((Collection)elements2).isEmpty()) {
                textRange = new TextRange(((PsiElement)CollectionsKt.first(elements2)).getTextRange().getStartOffset(), ((PsiElement)CollectionsKt.last(elements2)).getTextRange().getEndOffset());
            } else {
                TextRange textRange2 = TextRange.EMPTY_RANGE;
                Intrinsics.checkNotNull((Object)textRange2);
                textRange = textRange2;
            }
            return textRange;
        }
    }
}

