/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.highlighting.dsl;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.ide.highlighter.custom.CustomHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinBaseHighlightingBundle;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0013\u0010\u001d\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/base/highlighting/dsl/DslStyleUtils;", "", "()V", "DSL_MARKER_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "getDSL_MARKER_CLASS_ID", "()Lorg/jetbrains/kotlin/name/ClassId;", "STYLE_COUNT", "", "STYLE_KEYS", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "descriptionsToStyles", "", "", "getDescriptionsToStyles", "()Ljava/util/Map;", "styles", "types", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "createDslStyleIcon", "Ljavax/swing/Icon;", "styleId", "externalKeyName", "index", "styleById", "styleIdByFQName", "name", "Lorg/jetbrains/kotlin/name/FqName;", "styleOptionDisplayName", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "typeById", "kotlin.highlighting.shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDslStyleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DslStyleUtils.kt\norg/jetbrains/kotlin/idea/base/highlighting/dsl/DslStyleUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n1549#2:77\n1620#2,3:78\n1179#2,2:81\n1253#2,4:83\n*S KotlinDebug\n*F\n+ 1 DslStyleUtils.kt\norg/jetbrains/kotlin/idea/base/highlighting/dsl/DslStyleUtils\n*L\n32#1:73\n32#1:74,3\n35#1:77\n35#1:78,3\n41#1:81,2\n41#1:83,4\n*E\n"})
public final class DslStyleUtils {
    @NotNull
    public static final DslStyleUtils INSTANCE;
    private static final int STYLE_COUNT = 4;
    @NotNull
    private static final List<TextAttributesKey> STYLE_KEYS;
    @NotNull
    private static final List<TextAttributesKey> styles;
    @NotNull
    private static final List<HighlightInfoType> types;
    @NotNull
    private static final ClassId DSL_MARKER_CLASS_ID;
    @NotNull
    private static final Map<String, TextAttributesKey> descriptionsToStyles;

    private DslStyleUtils() {
    }

    @NotNull
    public final ClassId getDSL_MARKER_CLASS_ID() {
        return DSL_MARKER_CLASS_ID;
    }

    @NotNull
    public final Map<String, TextAttributesKey> getDescriptionsToStyles() {
        return descriptionsToStyles;
    }

    private final String externalKeyName(int index) {
        return "KOTLIN_DSL_STYLE" + index;
    }

    @NotNull
    public final String styleOptionDisplayName(int index) {
        Object[] objectArray = new Object[]{index};
        return KotlinBaseHighlightingBundle.message("highlighter.name.style", objectArray);
    }

    public final int styleIdByFQName(@NotNull FqName name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Math.abs(name2.asString().hashCode() % 4) + 1;
    }

    @NotNull
    public final TextAttributesKey styleById(int styleId) {
        return styles.get(styleId - 1);
    }

    @NotNull
    public final HighlightInfoType typeById(int styleId) {
        return types.get(styleId - 1);
    }

    @NotNull
    public final Icon createDslStyleIcon(int styleId) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme globalScheme = editorColorsScheme;
        Color markersColor = globalScheme.getAttributes(this.styleById(styleId)).getForegroundColor();
        LayeredIcon icon = new LayeredIcon(2);
        Icon icon2 = KotlinIcons.DSL_MARKER_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"DSL_MARKER_ANNOTATION");
        Icon defaultIcon = icon2;
        icon.setIcon(defaultIcon, 0);
        Color[] colorArray = new Color[]{markersColor};
        icon.setIcon(((ScalableIcon)new ColorsIcon(defaultIcon.getIconHeight() / 2, colorArray)).scale(JBUI.pixScale()), 1, defaultIcon.getIconHeight() / 2, defaultIcon.getIconWidth() / 2);
        return (Icon)icon;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        INSTANCE = new DslStyleUtils();
        Object[] objectArray = new TextAttributesKey[]{CustomHighlighterColors.CUSTOM_KEYWORD1_ATTRIBUTES, CustomHighlighterColors.CUSTOM_KEYWORD2_ATTRIBUTES, CustomHighlighterColors.CUSTOM_KEYWORD3_ATTRIBUTES, CustomHighlighterColors.CUSTOM_KEYWORD4_ATTRIBUTES};
        STYLE_KEYS = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = (Iterable)new IntRange(1, 4);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void index;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TextAttributesKey.createTextAttributesKey((String)INSTANCE.externalKeyName((int)index), (TextAttributesKey)STYLE_KEYS.get((int)(index - true))));
        }
        styles = (List)destination$iv$iv;
        $this$map$iv = styles;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void attributeKey;
            TextAttributesKey index = (TextAttributesKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, (TextAttributesKey)attributeKey, false));
        }
        types = (List)destination$iv$iv;
        DSL_MARKER_CLASS_ID = ClassId.Companion.topLevel(new FqName("kotlin.DslMarker"));
        Iterable $this$associate$iv = (Iterable)new IntRange(1, 4);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator3 = $this$associateTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator3).nextInt();
            Map map2 = destination$iv$iv2;
            int index = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)(KotlinBaseHighlightingBundle.message("highlighter.name.dsl", new Object[0]) + INSTANCE.styleOptionDisplayName(index)), (Object)INSTANCE.styleById(index));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        descriptionsToStyles = destination$iv$iv2;
    }
}

