/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerData;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001aB\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00010\u0005*\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00010\u00052\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0000\u001a\u001e\u0010\n\u001a\u0002H\u000b\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\u0003*\u00020\fH\u0086\b\u00a2\u0006\u0002\u0010\r\u001a \u0010\u000e\u001a\u0004\u0018\u0001H\u000b\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\u0003*\u00020\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u0010\u001aJ\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0005*\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u001a:\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0005*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a8\u0006\u001b"}, d2={"create", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "argumentType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "addEmptyVarargValuesFor", "", "Lorg/jetbrains/kotlin/name/Name;", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "coneType", "T", "Lorg/jetbrains/kotlin/constant/KClassValue$Value$LocalClass;", "(Lorg/jetbrains/kotlin/constant/KClassValue$Value$LocalClass;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneTypeSafe", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "(Lorg/jetbrains/kotlin/constant/AnnotationValue;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "convertToConstantValues", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nConstantValueUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantValueUtils.kt\norg/jetbrains/kotlin/fir/serialization/constant/ConstantValueUtilsKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformerKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,75:1\n403#2:76\n1238#3,2:77\n1241#3:82\n1179#3,2:83\n1253#3,4:85\n36#4,2:79\n226#5:81\n*S KotlinDebug\n*F\n+ 1 ConstantValueUtils.kt\norg/jetbrains/kotlin/fir/serialization/constant/ConstantValueUtilsKt\n*L\n25#1:76\n25#1:77,2\n25#1:82\n50#1:83,2\n50#1:85,4\n27#1:79,2\n28#1:81\n*E\n"})
public final class ConstantValueUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Name, ConstantValue<?>> convertToConstantValues(@NotNull Map<Name, ? extends FirExpression> $this$convertToConstantValues, @NotNull FirSession session2, @Nullable ConstValueProvider constValueProvider) {
        void destination$iv;
        void $this$mapValuesTo$iv;
        Intrinsics.checkNotNullParameter($this$convertToConstantValues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Map<Name, ? extends FirExpression> map2 = $this$convertToConstantValues;
        Map map3 = new LinkedHashMap();
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            void var20_20 = var11_11;
            boolean bl2 = false;
            FirExpression firExpression2 = (FirExpression)entry2.getValue();
            ConstantValue constantValue = constValueProvider;
            if (constantValue == null || (constantValue = constantValue.findConstantValueFor(firExpression2)) == null) {
                ConstantValue constantValue2;
                FirExpression $this$toConstantValue$iv = firExpression2;
                boolean $i$f$toConstantValue = false;
                ConstantValue constantValue3 = constValueProvider;
                Object object = constantValue3 != null ? constantValue3.findConstantValueFor($this$toConstantValue$iv) : null;
                if (!(object instanceof ConstantValue)) {
                    object = constantValue2 = null;
                }
                if (object == null) {
                    Object r = $this$toConstantValue$iv.accept(FirToConstantValueTransformer.INSTANCE, new FirToConstantValueTransformerData(session2, (ConstValueProvider)constValueProvider));
                    if (!(r instanceof ConstantValue)) {
                        r = null;
                    }
                    constantValue2 = (ConstantValue)r;
                }
                constantValue = constantValue2;
                if (constantValue2 == null) {
                    ErrorValue.ErrorValueWithMessage errorValueWithMessage;
                    boolean condition$iv = (Boolean)FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).getFlag(AnalysisFlags.getMetadataCompilation());
                    boolean $i$f$runIf = false;
                    if (condition$iv) {
                        boolean bl3 = false;
                        errorValueWithMessage = new ErrorValue.ErrorValueWithMessage("Constant conversion can be ignored in metadata compilation mode");
                    } else {
                        errorValueWithMessage = null;
                    }
                    if (errorValueWithMessage != null) {
                        constantValue = (ConstantValue)errorValueWithMessage;
                    } else {
                        throw new IllegalStateException(("Cannot convert expression " + UtilsKt.render(firExpression2) + " to constant").toString());
                    }
                }
            }
            ConstantValue constantValue4 = constantValue;
            var20_20.put(k, constantValue4);
        }
        return destination$iv;
    }

    @NotNull
    public static final Map<Name, ConstantValue<Object>> addEmptyVarargValuesFor(@NotNull Map<Name, ConstantValue<Object>> $this$addEmptyVarargValuesFor, @Nullable FirFunctionSymbol<?> symbol2) {
        Map<Name, ConstantValue<Object>> map2;
        Intrinsics.checkNotNullParameter($this$addEmptyVarargValuesFor, (String)"<this>");
        Map<Name, ConstantValue<Object>> $this$addEmptyVarargValuesFor_u24lambda_u242 = map2 = $this$addEmptyVarargValuesFor;
        boolean bl = false;
        if (symbol2 != null) {
            Iterator<FirValueParameterSymbol> iterator2 = symbol2.getValueParameterSymbols().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i2 = n++;
                FirValueParameterSymbol parameter2 = iterator2.next();
                if ($this$addEmptyVarargValuesFor_u24lambda_u242.containsKey(parameter2.getName()) || !parameter2.isVararg() || DeclarationUtilsKt.itOrExpectHasDefaultParameterValue((FirFunction)symbol2.getFir(), i2)) continue;
                $this$addEmptyVarargValuesFor_u24lambda_u242.put(parameter2.getName(), (ConstantValue<Object>)new ArrayValue(CollectionsKt.emptyList()));
            }
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Name, ConstantValue<?>> convertToConstantValues(@NotNull LinkedHashMap<FirExpression, FirValueParameter> $this$convertToConstantValues, @NotNull FirSession session2, @Nullable ConstValueProvider constValueProvider) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$convertToConstantValues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Set<Map.Entry<FirExpression, FirValueParameter>> set2 = $this$convertToConstantValues.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        Iterable $this$associate$iv = set2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            FirExpression firExpression2 = (FirExpression)entry.getKey();
            FirValueParameter firValueParameter = (FirValueParameter)entry.getValue();
            entry = TuplesKt.to((Object)firValueParameter.getName(), (Object)firExpression2);
            map2.put(entry.getFirst(), entry.getSecond());
        }
        return ConstantValueUtilsKt.convertToConstantValues(destination$iv$iv, session2, constValueProvider);
    }

    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeSafe(AnnotationValue $this$coneTypeSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$coneTypeSafe, (String)"<this>");
        boolean $i$f$coneTypeSafe = false;
        KotlinTypeMarker kotlinTypeMarker = ((AnnotationValue.Value)$this$coneTypeSafe.getValue()).getType();
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)((ConeKotlinType)kotlinTypeMarker);
    }

    public static final /* synthetic */ <T extends ConeKotlinType> T coneType(KClassValue.Value.LocalClass $this$coneType) {
        Intrinsics.checkNotNullParameter((Object)$this$coneType, (String)"<this>");
        boolean $i$f$coneType = false;
        KotlinTypeMarker kotlinTypeMarker = $this$coneType.getType();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)((ConeKotlinType)kotlinTypeMarker);
    }

    @Nullable
    public static final ConstantValue<?> create(@NotNull ConeKotlinType argumentType) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        if (argumentType instanceof ConeErrorType) {
            return null;
        }
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        ConeKotlinType type2 = argumentType;
        int arrayDimensions = 0;
        while (!ConeBuiltinTypeUtilsKt.isPrimitiveArray(type2) && ArrayUtilsKt.arrayElementType$default(type2, false, 1, null) != null) {
            ++arrayDimensions;
        }
        ClassId classId = ConeTypeUtilsKt.getClassId(type2);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        return (ConstantValue)new KClassValue(classId2, arrayDimensions);
    }
}

