/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.Arrays;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.calls.tower.InvokeResolvePriority;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroupKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0000H\u0002J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u000b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "", "code", "", "debugKinds", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "invokeResolvePriority", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;", "receiverGroup", "(J[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;)V", "InvokeExtensionWithImplicitReceiver", "getInvokeExtensionWithImplicitReceiver", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "Member", "getMember", "[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "ContextReceiverGroup", "depth", "", "Implicit", "InvokeReceiver", "InvokeResolvePriority", "Local", "NonLocal", "TopPrioritized", "compareTo", "other", "debugCompareTo", "equals", "", "", "hashCode", "kindOf", "kind", "toString", "", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nTowerGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerGroup.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,395:1\n26#2:396\n26#2:397\n26#2:398\n*S KotlinDebug\n*F\n+ 1 TowerGroup.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup\n*L\n251#1:396\n252#1:397\n93#1:398\n*E\n"})
public final class TowerGroup
implements Comparable<TowerGroup> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long code;
    @NotNull
    private final TowerGroupKind[] debugKinds;
    @NotNull
    private final InvokeResolvePriority invokeResolvePriority;
    @Nullable
    private final TowerGroup receiverGroup;
    private static final int KIND_MASK = 15;
    private static final int KIND_SIZE_BITS = Integer.bitCount(15);
    private static final int DEPTH_MASK = 65535;
    private static final int DEPTH_SIZE_BITS = Integer.bitCount(65535);
    private static final long USED_BITS_MASK = 63L;
    private static final int TOTAL_BITS = 64;
    private static final int USABLE_BITS = Long.numberOfLeadingZeros(63L);
    @NotNull
    private static final TowerGroupKind[] EMPTY_KIND_ARRAY;
    private static final boolean DEBUG = false;
    @NotNull
    private static final Comparator<TowerGroupKind[]> DEBUG_KINDS_COMPARATOR;
    @NotNull
    private static final TowerGroup EmptyRoot;
    @NotNull
    private static final TowerGroup EmptyRootForInvokeReceiver;
    @NotNull
    private static final TowerGroup Start;
    @NotNull
    private static final TowerGroup Qualifier;
    @NotNull
    private static final TowerGroup Classifier;
    @NotNull
    private static final TowerGroup QualifierValue;
    @NotNull
    private static final TowerGroup Member;
    @NotNull
    private static final TowerGroup Last;

    private TowerGroup(long code, TowerGroupKind[] debugKinds, InvokeResolvePriority invokeResolvePriority, TowerGroup receiverGroup) {
        this.code = code;
        this.debugKinds = debugKinds;
        this.invokeResolvePriority = invokeResolvePriority;
        this.receiverGroup = receiverGroup;
    }

    /* synthetic */ TowerGroup(long l, TowerGroupKind[] towerGroupKindArray, InvokeResolvePriority invokeResolvePriority, TowerGroup towerGroup, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            invokeResolvePriority = InvokeResolvePriority.NONE;
        }
        if ((n & 8) != 0) {
            towerGroup = null;
        }
        this(l, towerGroupKindArray, invokeResolvePriority, towerGroup);
    }

    private final TowerGroup kindOf(TowerGroupKind kind2) {
        return new TowerGroup(TowerGroup.Companion.subscript(this.code, kind2), TowerGroup.Companion.appendDebugKind(this.debugKinds, kind2), null, null, 12, null);
    }

    @NotNull
    public final TowerGroup getMember() {
        return this.kindOf(TowerGroupKind.Member.INSTANCE);
    }

    @NotNull
    public final TowerGroup getInvokeExtensionWithImplicitReceiver() {
        return this.kindOf(TowerGroupKind.InvokeExtensionWithImplicitReceiver.INSTANCE);
    }

    @NotNull
    public final TowerGroup Local(int depth2) {
        return this.kindOf(new TowerGroupKind.Local(depth2));
    }

    @NotNull
    public final TowerGroup Implicit(int depth2) {
        return this.kindOf(TowerGroupKind.Companion.Implicit(depth2));
    }

    @NotNull
    public final TowerGroup NonLocal(int depth2) {
        return this.kindOf(TowerGroupKind.Companion.NonLocal(depth2));
    }

    @NotNull
    public final TowerGroup ContextReceiverGroup(int depth2) {
        return this.kindOf(new TowerGroupKind.ContextReceiverGroup(depth2));
    }

    @NotNull
    public final TowerGroup TopPrioritized(int depth2) {
        return this.kindOf(new TowerGroupKind.TopPrioritized(depth2));
    }

    @NotNull
    public final TowerGroup InvokeReceiver(@NotNull TowerGroup receiverGroup, @NotNull InvokeResolvePriority invokeResolvePriority) {
        Intrinsics.checkNotNullParameter((Object)receiverGroup, (String)"receiverGroup");
        Intrinsics.checkNotNullParameter((Object)((Object)invokeResolvePriority), (String)"invokeResolvePriority");
        if (!(receiverGroup.invokeResolvePriority == InvokeResolvePriority.INVOKE_RECEIVER)) {
            boolean $i$a$-require-TowerGroup$InvokeReceiver$42 = false;
            String $i$a$-require-TowerGroup$InvokeReceiver$42 = "Receivers for invoke should be resolved with INVOKE_RECEIVER, but " + (Object)((Object)receiverGroup.invokeResolvePriority) + " found";
            throw new IllegalArgumentException($i$a$-require-TowerGroup$InvokeReceiver$42.toString());
        }
        if (!(invokeResolvePriority != InvokeResolvePriority.NONE && invokeResolvePriority != InvokeResolvePriority.INVOKE_RECEIVER)) {
            boolean $i$a$-require-TowerGroup$InvokeReceiver$52 = false;
            String $i$a$-require-TowerGroup$InvokeReceiver$52 = "invokeResolvePriority should be non-trivial when receiverGroup is specified";
            throw new IllegalArgumentException($i$a$-require-TowerGroup$InvokeReceiver$52.toString());
        }
        if (!(receiverGroup.receiverGroup == null)) {
            boolean bl = false;
            String string = "receiverGroup should be trivial, but " + receiverGroup.receiverGroup + " was found";
            throw new IllegalArgumentException(string.toString());
        }
        return new TowerGroup(this.code, this.debugKinds, invokeResolvePriority, receiverGroup);
    }

    @NotNull
    public final TowerGroup InvokeResolvePriority(@NotNull InvokeResolvePriority invokeResolvePriority) {
        Intrinsics.checkNotNullParameter((Object)((Object)invokeResolvePriority), (String)"invokeResolvePriority");
        if (invokeResolvePriority == InvokeResolvePriority.NONE) {
            return this;
        }
        return new TowerGroup(this.code, this.debugKinds, invokeResolvePriority, null, 8, null);
    }

    private final int debugCompareTo(TowerGroup other2) {
        TowerGroupKind[] otherMax;
        TowerGroupKind[] thisMax;
        int maxResult;
        TowerGroupKind[] otherReceiverDebugKinds;
        TowerGroupKind[] receiverDebugKinds;
        block11: {
            TowerGroupKind[] towerGroupKindArray;
            block10: {
                TowerGroupKind[] towerGroupKindArray2;
                block9: {
                    block8: {
                        towerGroupKindArray2 = this.receiverGroup;
                        if (this.receiverGroup == null) break block8;
                        towerGroupKindArray2 = towerGroupKindArray2.debugKinds;
                        if (towerGroupKindArray2.debugKinds != null) break block9;
                    }
                    boolean $i$f$emptyArray = false;
                    towerGroupKindArray2 = new TowerGroupKind[]{};
                }
                receiverDebugKinds = towerGroupKindArray2;
                towerGroupKindArray = other2.receiverGroup;
                if (other2.receiverGroup == null) break block10;
                towerGroupKindArray = towerGroupKindArray.debugKinds;
                if (towerGroupKindArray.debugKinds != null) break block11;
            }
            boolean $i$f$emptyArray = false;
            towerGroupKindArray = otherReceiverDebugKinds = new TowerGroupKind[]{};
        }
        if ((maxResult = TowerGroup.Companion.compareDebugKinds(thisMax = (TowerGroupKind[])ComparisonsKt.maxOf((Object)this.debugKinds, (Object)receiverDebugKinds, TowerGroup.DEBUG_KINDS_COMPARATOR), otherMax = (TowerGroupKind[])ComparisonsKt.maxOf((Object)other2.debugKinds, (Object)otherReceiverDebugKinds, TowerGroup.DEBUG_KINDS_COMPARATOR))) != 0) {
            return maxResult;
        }
        int invokeKindPriority = this.invokeResolvePriority.compareTo((Enum)other2.invokeResolvePriority);
        if (invokeKindPriority != 0) {
            return invokeKindPriority;
        }
        return TowerGroup.Companion.compareDebugKinds(receiverDebugKinds, thisMax) == 0 && TowerGroup.Companion.compareDebugKinds(otherReceiverDebugKinds, thisMax) == 0 ? TowerGroup.Companion.compareDebugKinds(this.debugKinds, other2.debugKinds) : TowerGroup.Companion.compareDebugKinds(receiverDebugKinds, otherReceiverDebugKinds);
    }

    @Override
    public int compareTo(@NotNull TowerGroup other2) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)other2, (String)"other");
        TowerGroup $this$compareTo_u24lambda_u243 = this;
        boolean bl = false;
        if ($this$compareTo_u24lambda_u243.receiverGroup == null && other2.receiverGroup == null && $this$compareTo_u24lambda_u243.invokeResolvePriority == InvokeResolvePriority.NONE && other2.invokeResolvePriority == InvokeResolvePriority.NONE) {
            n2 = Long.compareUnsigned($this$compareTo_u24lambda_u243.code, other2.code);
        } else {
            long otherMax;
            TowerGroup towerGroup = $this$compareTo_u24lambda_u243.receiverGroup;
            long receiverCode = towerGroup != null ? towerGroup.code : 0L;
            TowerGroup towerGroup2 = other2.receiverGroup;
            long otherReceiverCode = towerGroup2 != null ? towerGroup2.code : 0L;
            long thisMax = Long.compareUnsigned($this$compareTo_u24lambda_u243.code, receiverCode) >= 0 ? $this$compareTo_u24lambda_u243.code : receiverCode;
            int resultMax = Long.compareUnsigned(thisMax, otherMax = Long.compareUnsigned(other2.code, otherReceiverCode) >= 0 ? other2.code : otherReceiverCode);
            if (resultMax != 0) {
                n2 = resultMax;
            } else {
                int invokeKindPriority = $this$compareTo_u24lambda_u243.invokeResolvePriority.compareTo((Enum)other2.invokeResolvePriority);
                if (invokeKindPriority != 0) {
                    return invokeKindPriority;
                }
                return Long.compareUnsigned(receiverCode, thisMax) == 0 && Long.compareUnsigned(otherReceiverCode, thisMax) == 0 ? Long.compareUnsigned($this$compareTo_u24lambda_u243.code, other2.code) : Long.compareUnsigned(receiverCode, otherReceiverCode);
            }
        }
        int it = n = n2;
        boolean bl2 = false;
        return n;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        Object object = other2;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup");
        TowerGroup cfr_ignored_0 = (TowerGroup)other2;
        if (this.code != ((TowerGroup)other2).code) {
            return false;
        }
        if (this.invokeResolvePriority != ((TowerGroup)other2).invokeResolvePriority) {
            return false;
        }
        return this.receiverGroup == null || ((TowerGroup)other2).receiverGroup == null || Intrinsics.areEqual((Object)this.receiverGroup, (Object)((TowerGroup)other2).receiverGroup);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("TowerGroup(code=").append(Long.toBinaryString(this.code)).append(", debugKinds=");
        String string = Arrays.toString(this.debugKinds);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).append(", invokeResolvePriority=").append((Object)this.invokeResolvePriority).append(')').toString();
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.code);
        result2 = 31 * result2 + this.invokeResolvePriority.hashCode();
        return result2;
    }

    static {
        boolean $i$f$emptyArray = false;
        EMPTY_KIND_ARRAY = new TowerGroupKind[0];
        DEBUG_KINDS_COMPARATOR = (arg_0, arg_1) -> Companion.access$compareDebugKinds(Companion, arg_0, arg_1);
        EmptyRoot = new TowerGroup(0L, EMPTY_KIND_ARRAY, null, null, 12, null);
        EmptyRootForInvokeReceiver = new TowerGroup(0L, EMPTY_KIND_ARRAY, InvokeResolvePriority.INVOKE_RECEIVER, null, 8, null);
        Start = TowerGroup.Companion.kindOf(TowerGroupKind.Start.INSTANCE);
        Qualifier = TowerGroup.Companion.kindOf(TowerGroupKind.Qualifier.INSTANCE);
        Classifier = TowerGroup.Companion.kindOf(TowerGroupKind.Classifier.INSTANCE);
        QualifierValue = TowerGroup.Companion.kindOf(TowerGroupKind.QualifierValue.INSTANCE);
        Member = TowerGroup.Companion.kindOf(TowerGroupKind.Member.INSTANCE);
        Last = TowerGroup.Companion.kindOf(TowerGroupKind.Last.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\t\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010,\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010-\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010/\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0011J)\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00102\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u00103J)\u00104\u001a\u00020\u00112\f\u00105\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u00107J\u001b\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00102\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020\u00042\u0006\u00102\u001a\u00020\fH\u0002J\u0018\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020(2\u0006\u00102\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\t\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u000e\u0010%\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup$Companion;", "", "()V", "Classifier", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "getClassifier", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "DEBUG", "", "DEBUG_KINDS_COMPARATOR", "Ljava/util/Comparator;", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "Lkotlin/Comparator;", "getDEBUG_KINDS_COMPARATOR", "()Ljava/util/Comparator;", "DEPTH_MASK", "", "DEPTH_SIZE_BITS", "EMPTY_KIND_ARRAY", "[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "EmptyRoot", "getEmptyRoot", "EmptyRootForInvokeReceiver", "getEmptyRootForInvokeReceiver", "KIND_MASK", "KIND_SIZE_BITS", "Last", "getLast", "Member", "getMember", "Qualifier", "getQualifier", "QualifierValue", "getQualifierValue", "Start", "getStart", "TOTAL_BITS", "USABLE_BITS", "USED_BITS_MASK", "", "ContextReceiverGroup", "depth", "Implicit", "Local", "NonLocal", "TopPrioritized", "UnqualifiedEnum", "appendDebugKind", "kinds", "kind", "([Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "compareDebugKinds", "aDebugKinds", "bDebugKinds", "([Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)I", "debugKindArrayOf", "(Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "kindOf", "subscript", "code", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        private final TowerGroupKind[] appendDebugKind(TowerGroupKind[] kinds2, TowerGroupKind kind2) {
            return EMPTY_KIND_ARRAY;
        }

        private final TowerGroupKind[] debugKindArrayOf(TowerGroupKind kind2) {
            return EMPTY_KIND_ARRAY;
        }

        private final long subscript(long code, TowerGroupKind kind2) {
            long l;
            int usedBits = (int)(code & 0x3FL);
            if (kind2 instanceof TowerGroupKind.WithDepth) {
                int kindUsedBits = usedBits + KIND_SIZE_BITS;
                int depthUsedBits = kindUsedBits + DEPTH_SIZE_BITS;
                if (!(((TowerGroupKind.WithDepth)kind2).getDepth() <= 65535)) {
                    boolean $i$a$-require-TowerGroup$Companion$subscript$32 = false;
                    String $i$a$-require-TowerGroup$Companion$subscript$32 = "Depth overflow: requested: " + ((TowerGroupKind.WithDepth)kind2).getDepth() + ", allowed: 65535";
                    throw new IllegalArgumentException($i$a$-require-TowerGroup$Companion$subscript$32.toString());
                }
                if (!(depthUsedBits <= USABLE_BITS)) {
                    boolean bl = false;
                    String string = "BitGroup overflow: newUsedBits: " + depthUsedBits + ", original: " + Long.toBinaryString(code) + ", usedBits: " + usedBits;
                    throw new IllegalArgumentException(string.toString());
                }
                l = code | (long)kind2.getIndex() << 64 - kindUsedBits | (long)((TowerGroupKind.WithDepth)kind2).getDepth() << 64 - depthUsedBits | (long)depthUsedBits;
            } else {
                int newUsedBits = usedBits + KIND_SIZE_BITS;
                if (!(newUsedBits <= USABLE_BITS)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                l = code | (long)kind2.getIndex() << 64 - newUsedBits | (long)newUsedBits;
            }
            return l;
        }

        private final int compareDebugKinds(TowerGroupKind[] aDebugKinds, TowerGroupKind[] bDebugKinds) {
            int index;
            for (index = 0; index < aDebugKinds.length; ++index) {
                if (index >= bDebugKinds.length) {
                    return 1;
                }
                if (aDebugKinds[index].compareTo(bDebugKinds[index]) < 0) {
                    return -1;
                }
                if (aDebugKinds[index].compareTo(bDebugKinds[index]) <= 0) continue;
                return 1;
            }
            if (index < bDebugKinds.length) {
                return -1;
            }
            return 0;
        }

        @NotNull
        public final Comparator<TowerGroupKind[]> getDEBUG_KINDS_COMPARATOR() {
            return DEBUG_KINDS_COMPARATOR;
        }

        private final TowerGroup kindOf(TowerGroupKind kind2) {
            return new TowerGroup(this.subscript(0L, kind2), this.debugKindArrayOf(kind2), null, null, 12, null);
        }

        @NotNull
        public final TowerGroup getEmptyRoot() {
            return EmptyRoot;
        }

        @NotNull
        public final TowerGroup getEmptyRootForInvokeReceiver() {
            return EmptyRootForInvokeReceiver;
        }

        @NotNull
        public final TowerGroup getStart() {
            return Start;
        }

        @NotNull
        public final TowerGroup getQualifier() {
            return Qualifier;
        }

        @NotNull
        public final TowerGroup getClassifier() {
            return Classifier;
        }

        @NotNull
        public final TowerGroup getQualifierValue() {
            return QualifierValue;
        }

        @NotNull
        public final TowerGroup getMember() {
            return Member;
        }

        @NotNull
        public final TowerGroup UnqualifiedEnum(int depth2) {
            return this.kindOf(new TowerGroupKind.UnqualifiedEnum(depth2));
        }

        @NotNull
        public final TowerGroup Local(int depth2) {
            return this.kindOf(new TowerGroupKind.Local(depth2));
        }

        @NotNull
        public final TowerGroup Implicit(int depth2) {
            return this.kindOf(TowerGroupKind.Companion.Implicit(depth2));
        }

        @NotNull
        public final TowerGroup NonLocal(int depth2) {
            return this.kindOf(TowerGroupKind.Companion.NonLocal(depth2));
        }

        @NotNull
        public final TowerGroup ContextReceiverGroup(int depth2) {
            return this.kindOf(new TowerGroupKind.ContextReceiverGroup(depth2));
        }

        @NotNull
        public final TowerGroup TopPrioritized(int depth2) {
            return this.kindOf(new TowerGroupKind.TopPrioritized(depth2));
        }

        @NotNull
        public final TowerGroup getLast() {
            return Last;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

