/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extended.RedundantVisibilityModifierSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J,\u0010\u001d\u001a\u00020\u00062\"\u0010\u001e\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\u0004\u0012\u00020!0\u001f\u0012\u0004\u0012\u00020\u00100\u001fH\u0002J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010(\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010*\u001a\u00020\u000b*\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010,\u001a\u00020\u000b*\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0014H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantVisibilityModifierSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "()V", "explicitVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/KtSourceElement;", "getExplicitVisibility", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "hasSetterWithImplicitVisibility", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getHasSetterWithImplicitVisibility", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "checkElementAndReport", "", "element", "implicitVisibility", "containingMemberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPropertyAndReport", "property", "checkPsiOrLightTree", "source", "findBiggestVisibility", "processSymbols", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "findFunctionVisibility", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "findPropertyAccessorVisibility", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "findPropertyVisibility", "reportElement", "canMakeSetterMoreAccessible", "setterImplicitVisibility", "isEffectivelyHiddenBy", "declaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nRedundantVisibilityModifierSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantVisibilityModifierSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantVisibilityModifierSyntaxChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,294:1\n93#2,3:295\n98#2:299\n93#3:298\n40#4:300\n21#4:301\n28#4:302\n40#4:308\n40#4:309\n25#5:303\n18#5:304\n75#5:305\n58#5:307\n37#6:306\n*S KotlinDebug\n*F\n+ 1 RedundantVisibilityModifierSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantVisibilityModifierSyntaxChecker\n*L\n91#1:295,3\n91#1:299\n91#1:298\n147#1:300\n159#1:301\n181#1:302\n214#1:308\n218#1:309\n196#1:303\n198#1:304\n204#1:305\n204#1:307\n204#1:306\n*E\n"})
public final class RedundantVisibilityModifierSyntaxChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final RedundantVisibilityModifierSyntaxChecker INSTANCE = new RedundantVisibilityModifierSyntaxChecker();

    private RedundantVisibilityModifierSyntaxChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirDeclaration element3, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (element3 instanceof FirPropertyAccessor) {
            return;
        }
        if (element3 instanceof FirConstructor) {
            KtSourceElement ktSourceElement = element3.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
        }
        if (element3 instanceof FirProperty) {
            this.checkPropertyAndReport((FirProperty)element3, context2, reporter);
        } else {
            this.checkElementAndReport(element3, context2, reporter);
        }
    }

    private final void checkPropertyAndReport(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        Visibility setterImplicitVisibility = null;
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        if (firPropertyAccessor != null) {
            Visibility visibility2;
            FirPropertyAccessor setter2 = firPropertyAccessor;
            boolean bl = false;
            setterImplicitVisibility = visibility2 = INSTANCE.implicitVisibility(setter2, context2);
            INSTANCE.checkElementAndReport(setter2, visibility2, property2, context2, reporter);
        }
        FirPropertyAccessor firPropertyAccessor2 = property2.getGetter();
        if (firPropertyAccessor2 != null) {
            FirPropertyAccessor getter2 = firPropertyAccessor2;
            boolean bl = false;
            INSTANCE.checkElementAndReport(getter2, property2, context2, reporter);
        }
        FirBackingField firBackingField = property2.getBackingField();
        if (firBackingField != null) {
            FirBackingField field2 = firBackingField;
            boolean bl = false;
            INSTANCE.checkElementAndReport(field2, property2, context2, reporter);
        }
        if (this.canMakeSetterMoreAccessible(property2, setterImplicitVisibility)) {
            return;
        }
        this.checkElementAndReport(property2, context2, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkElementAndReport(FirDeclaration element3, CheckerContext context2, DiagnosticReporter reporter) {
        FirElement firElement;
        RedundantVisibilityModifierSyntaxChecker redundantVisibilityModifierSyntaxChecker;
        FirDeclaration firDeclaration;
        block3: {
            void $this$findClosest_u24default$iv;
            CheckerContext checkerContext = context2;
            firDeclaration = element3;
            redundantVisibilityModifierSyntaxChecker = this;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration2 = it$iv;
                if (!(firDeclaration2 instanceof FirMemberDeclaration)) {
                    firDeclaration2 = null;
                }
                if ((firElement = (FirElement)((FirMemberDeclaration)firDeclaration2)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block3;
            }
            firElement = null;
        }
        FirElement firElement4 = firElement;
        redundantVisibilityModifierSyntaxChecker.checkElementAndReport(firDeclaration, (FirMemberDeclaration)firElement4, context2, reporter);
    }

    private final void checkElementAndReport(FirDeclaration element3, FirMemberDeclaration containingMemberDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        this.checkElementAndReport(element3, this.implicitVisibility(element3, context2), containingMemberDeclaration, context2, reporter);
    }

    private final void checkElementAndReport(FirDeclaration element3, Visibility implicitVisibility, FirMemberDeclaration containingMemberDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement ktSourceElement = element3.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!(element3 instanceof FirMemberDeclaration)) {
            return;
        }
        KtSourceElement ktSourceElement2 = element3.getSource();
        Visibility explicitVisibility = ktSourceElement2 != null ? this.getExplicitVisibility(ktSourceElement2) : null;
        boolean isHidden = this.isEffectivelyHiddenBy(explicitVisibility, containingMemberDeclaration);
        if (isHidden) {
            this.reportElement(element3, context2, reporter);
            return;
        }
        ExplicitApiMode explicitApiMode = (ExplicitApiMode)context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExplicitApiMode());
        if (explicitApiMode != ExplicitApiMode.DISABLED && Intrinsics.areEqual((Object)explicitVisibility, (Object)Visibilities.Public.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)explicitVisibility, (Object)implicitVisibility)) {
            this.reportElement(element3, context2, reporter);
        }
    }

    private final void reportElement(FirDeclaration element3, CheckerContext context2, DiagnosticReporter reporter) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)element3.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER(), (DiagnosticContext)context2, null, (int)8, null);
    }

    private final boolean canMakeSetterMoreAccessible(FirProperty $this$canMakeSetterMoreAccessible, Visibility setterImplicitVisibility) {
        FirMemberDeclaration $this$isOverride$iv = $this$canMakeSetterMoreAccessible;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return false;
        }
        if (!this.getHasSetterWithImplicitVisibility($this$canMakeSetterMoreAccessible)) {
            return false;
        }
        if (setterImplicitVisibility == null) {
            return false;
        }
        FirMemberDeclaration $this$visibility$iv = $this$canMakeSetterMoreAccessible;
        boolean $i$f$getVisibility = false;
        return !Intrinsics.areEqual((Object)setterImplicitVisibility, (Object)$this$visibility$iv.getStatus().getVisibility());
    }

    private final boolean getHasSetterWithImplicitVisibility(FirProperty $this$hasSetterWithImplicitVisibility) {
        FirPropertyAccessor firPropertyAccessor = $this$hasSetterWithImplicitVisibility.getSetter();
        if (firPropertyAccessor == null) {
            return false;
        }
        FirPropertyAccessor theSetter = firPropertyAccessor;
        KtSourceElement ktSourceElement = $this$hasSetterWithImplicitVisibility.getSource();
        KtSourceElement ktSourceElement2 = theSetter.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getLighterASTNode() : null), (Object)(ktSourceElement2 != null ? ktSourceElement2.getLighterASTNode() : null))) {
            return true;
        }
        KtSourceElement ktSourceElement3 = theSetter.getSource();
        if (ktSourceElement3 == null) {
            return true;
        }
        KtSourceElement theSource = ktSourceElement3;
        return this.getExplicitVisibility(theSource) == null;
    }

    private final Visibility getExplicitVisibility(KtSourceElement $this$explicitVisibility) {
        LighterASTNode visibilityModifier;
        LighterASTNode lighterASTNode = visibilityModifier = LightTreePositioningStrategiesKt.visibilityModifier((FlyweightCapableTreeStructure)$this$explicitVisibility.getTreeStructure(), (LighterASTNode)$this$explicitVisibility.getLighterASTNode());
        IElementType iElementType = lighterASTNode != null ? lighterASTNode.getTokenType() : null;
        KtModifierKeywordToken ktModifierKeywordToken = iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
        return ktModifierKeywordToken != null ? SourceHelpersKt.toVisibilityOrNull(ktModifierKeywordToken) : null;
    }

    private final boolean isEffectivelyHiddenBy(Visibility $this$isEffectivelyHiddenBy, FirMemberDeclaration declaration2) {
        FirElement firElement;
        block7: {
            block6: {
                firElement = declaration2;
                if (firElement == null) break block6;
                FirMemberDeclaration $this$effectiveVisibility$iv = firElement;
                boolean $i$f$getEffectiveVisibility = false;
                FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
                FirElement firElement2 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
                if (firElement2 == null || (firElement2 = firElement2.getEffectiveVisibility()) == null) {
                    firElement2 = firElement = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
                }
                if (firElement2 != null && (firElement = firElement.toVisibility()) != null) break block7;
            }
            return false;
        }
        FirElement containerVisibility = firElement;
        if (Intrinsics.areEqual((Object)containerVisibility, (Object)Visibilities.Local.INSTANCE) && Intrinsics.areEqual((Object)$this$isEffectivelyHiddenBy, (Object)Visibilities.Internal.INSTANCE)) {
            return true;
        }
        Object object = $this$isEffectivelyHiddenBy;
        if (object == null || (object = object.compareTo((Visibility)containerVisibility)) == null) {
            return false;
        }
        int difference = (Integer)object;
        return difference > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Visibility implicitVisibility(FirDeclaration $this$implicitVisibility, CheckerContext context2) {
        Visibility visibility2;
        boolean $i$f$isOverride;
        Object $this$isOverride$iv;
        block10: {
            block11: {
                block12: {
                    if ($this$implicitVisibility instanceof FirPropertyAccessor && ((FirPropertyAccessor)$this$implicitVisibility).isSetter() && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClass) {
                        $this$isOverride$iv = ((FirPropertyAccessor)$this$implicitVisibility).getPropertySymbol();
                        $i$f$isOverride = false;
                        if (((FirCallableSymbol)$this$isOverride$iv).getRawStatus().isOverride()) {
                            visibility2 = this.findPropertyAccessorVisibility((FirPropertyAccessor)$this$implicitVisibility, context2);
                            return visibility2;
                        }
                    }
                    if ($this$implicitVisibility instanceof FirPropertyAccessor) {
                        FirCallableSymbol $this$visibility$iv = ((FirPropertyAccessor)$this$implicitVisibility).getPropertySymbol();
                        boolean $i$f$getVisibility = false;
                        visibility2 = $this$visibility$iv.getResolvedStatus().getVisibility();
                        return visibility2;
                    }
                    if (!($this$implicitVisibility instanceof FirConstructor)) break block10;
                    FirClassLikeSymbol<?> classSymbol2 = FirHelpersKt.getContainingClassSymbol($this$implicitVisibility, context2.getSession());
                    if (!(classSymbol2 instanceof FirRegularClassSymbol)) break block11;
                    FirClassSymbol $this$isEnumClass$iv = (FirClassSymbol)classSymbol2;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) break block12;
                    FirClassLikeSymbol<?> $this$isSealed$iv = classSymbol2;
                    boolean $i$f$isSealed = false;
                    if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) break block11;
                }
                visibility2 = (Visibility)Visibilities.Private.INSTANCE;
                return visibility2;
            }
            visibility2 = (Visibility)Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
            return visibility2;
        }
        if ($this$implicitVisibility instanceof FirSimpleFunction && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClass) {
            $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
            $i$f$isOverride = false;
            if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) {
                visibility2 = this.findFunctionVisibility((FirSimpleFunction)$this$implicitVisibility, context2);
                return visibility2;
            }
        }
        if ($this$implicitVisibility instanceof FirProperty && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClass) {
            $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
            $i$f$isOverride = false;
            if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) {
                visibility2 = this.findPropertyVisibility((FirProperty)$this$implicitVisibility, context2);
                return visibility2;
            }
        }
        visibility2 = (Visibility)Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
        return visibility2;
    }

    private final Visibility findBiggestVisibility(Function1<? super Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction>, Unit> processSymbols) {
        Ref.ObjectRef current = new Ref.ObjectRef();
        current.element = Visibilities.Private.INSTANCE;
        processSymbols.invoke((Object)new Function1<FirCallableSymbol<?>, ProcessorAction>((Ref.ObjectRef<Visibility>)current){
            final /* synthetic */ Ref.ObjectRef<Visibility> $current;
            {
                this.$current = $current;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirCallableSymbol<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                FirCallableSymbol<?> $this$visibility$iv = it;
                boolean $i$f$getVisibility = false;
                Integer difference = Visibilities.INSTANCE.compare((Visibility)this.$current.element, $this$visibility$iv.getResolvedStatus().getVisibility());
                if (difference != null && difference < 0) {
                    $this$visibility$iv = it;
                    $i$f$getVisibility = false;
                    this.$current.element = $this$visibility$iv.getResolvedStatus().getVisibility();
                }
                return ProcessorAction.NEXT;
            }
        });
        return (Visibility)current.element;
    }

    private final Visibility findPropertyAccessorVisibility(FirPropertyAccessor accessor, CheckerContext context2) {
        Object object = FirHelpersKt.findClosestClassOrObject(context2);
        if (object == null || (object = ((FirClass)object).getSymbol()) == null) {
            return (Visibility)Visibilities.Public.INSTANCE;
        }
        Object containingClass = object;
        FirPropertySymbol propertySymbol = accessor.getPropertySymbol();
        FirTypeScope scope2 = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false, FirResolvePhase.STATUS);
        return this.findBiggestVisibility((Function1)new Function1<Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction>, Unit>(scope2, propertySymbol){
            final /* synthetic */ FirTypeScope $scope;
            final /* synthetic */ FirPropertySymbol $propertySymbol;
            {
                this.$scope = $scope;
                this.$propertySymbol = $propertySymbol;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> checkVisibility2) {
                Intrinsics.checkNotNullParameter(checkVisibility2, (String)"checkVisibility");
                this.$scope.processPropertiesByName(this.$propertySymbol.getName(), findPropertyAccessorVisibility.1.INSTANCE);
                FirTypeScopeKt.processOverriddenProperties(this.$scope, this.$propertySymbol, (Function1<? super FirPropertySymbol, ? extends ProcessorAction>)((Function1)new Function1<FirPropertySymbol, ProcessorAction>(checkVisibility2){
                    final /* synthetic */ Function1<FirCallableSymbol<?>, ProcessorAction> $checkVisibility;
                    {
                        this.$checkVisibility = $checkVisibility;
                        super(1);
                    }

                    @NotNull
                    public final ProcessorAction invoke(@NotNull FirPropertySymbol property2) {
                        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                        FirPropertyAccessorSymbol firPropertyAccessorSymbol = property2.getSetterSymbol();
                        if (firPropertyAccessorSymbol == null) {
                            return ProcessorAction.NEXT;
                        }
                        FirPropertyAccessorSymbol setter2 = firPropertyAccessorSymbol;
                        return (ProcessorAction)((Object)this.$checkVisibility.invoke((Object)setter2));
                    }
                }));
            }
        });
    }

    private final Visibility findPropertyVisibility(FirProperty property2, CheckerContext context2) {
        Object object = FirHelpersKt.findClosestClassOrObject(context2);
        if (object == null || (object = ((FirClass)object).getSymbol()) == null) {
            return (Visibility)Visibilities.Public.INSTANCE;
        }
        Object containingClass = object;
        FirTypeScope scope2 = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false, FirResolvePhase.STATUS);
        return this.findBiggestVisibility((Function1)new Function1<Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction>, Unit>(scope2, property2){
            final /* synthetic */ FirTypeScope $scope;
            final /* synthetic */ FirProperty $property;
            {
                this.$scope = $scope;
                this.$property = $property;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$scope.processPropertiesByName(this.$property.getSymbol().getName(), findPropertyVisibility.1.INSTANCE);
                FirTypeScopeKt.processOverriddenProperties(this.$scope, this.$property.getSymbol(), it);
            }
        });
    }

    private final Visibility findFunctionVisibility(FirSimpleFunction function2, CheckerContext context2) {
        Object object = FirHelpersKt.findClosestClassOrObject(context2);
        if (object == null || (object = ((FirClass)object).getSymbol()) == null) {
            return (Visibility)Visibilities.Unknown.INSTANCE;
        }
        Object currentClassSymbol = object;
        FirTypeScope scope2 = FirKotlinScopeProviderKt.unsubstitutedScope(currentClassSymbol, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false, FirResolvePhase.STATUS);
        return this.findBiggestVisibility((Function1)new Function1<Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction>, Unit>(scope2, function2){
            final /* synthetic */ FirTypeScope $scope;
            final /* synthetic */ FirSimpleFunction $function;
            {
                this.$scope = $scope;
                this.$function = $function;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$scope.processFunctionsByName(this.$function.getSymbol().getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)findFunctionVisibility.1.INSTANCE));
                FirTypeScopeKt.processOverriddenFunctions(this.$scope, this.$function.getSymbol(), it);
            }
        });
    }
}

