/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuperclassNotAccessibleFromInterfaceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuperclassNotAccessibleFromInterfaceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,38:1\n93#2,3:39\n98#2:43\n93#3:42\n*S KotlinDebug\n*F\n+ 1 FirSuperclassNotAccessibleFromInterfaceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker\n*L\n26#1:39,3\n26#1:43\n26#1:42\n*E\n"})
public final class FirSuperclassNotAccessibleFromInterfaceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuperclassNotAccessibleFromInterfaceChecker INSTANCE = new FirSuperclassNotAccessibleFromInterfaceChecker();

    private FirSuperclassNotAccessibleFromInterfaceChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirElement firElement;
        block8: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (FirHelpersKt.explicitReceiverIsNotSuperReference(expression2)) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirClass)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirClass)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block8;
            }
            firElement = null;
        }
        FirClass firClass = (FirClass)firElement;
        if (firClass == null) {
            return;
        }
        FirClass closestClass = firClass;
        if (closestClass.getClassKind() == ClassKind.INTERFACE) {
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2);
            FirClassLikeSymbol<?> firClassLikeSymbol = firCallableSymbol != null ? FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)firCallableSymbol, context2.getSession()) : null;
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol2 = firRegularClassSymbol;
            if (containingClassSymbol2.getSource() != null && containingClassSymbol2.getClassKind() == ClassKind.CLASS && !Intrinsics.areEqual((Object)containingClassSymbol2.getClassId(), (Object)StandardClassIds.INSTANCE.getAny())) {
                FirExpression firExpression2 = expression2.getExplicitReceiver();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firExpression2 != null ? firExpression2.getSource() : null)), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE(), (DiagnosticContext)context2, null, (int)8, null);
            }
        }
    }
}

