/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J6\u0010\u0017\u001a\u00020\u00062\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J:\u0010\u001a\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001b\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J2\u0010\u001d\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u00020\u001f2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J8\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010!\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\"\u001a\u00020\u0006*\u00020\u000b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010%\u001a\u00020\u0006*\u00020\u000b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010&\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010'\u001a\u00020\u0006*\u00020\u000b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010(\u001a\u00020\u0006*\u00020\u000b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010)\u001a\u00020\u0006*\u00020\u000b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010*\u001a\u00020\u0006*\u00020\u000b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010+\u001a\u00020\u0006*\u00020\u000b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010,\u001a\u00020-*\u00020-2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkMember", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "containingClass", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkModality", "overriddenSymbols", "", "checkOverriddenExperimentalities", "memberSymbol", "overriddenMemberSymbols", "checkDataClassCopy", "checkDefaultValues", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkDeprecation", "checkMutability", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkReturnType", "checkVisibility", "reportCannotChangeAccessPrivilege", "overriding", "overridden", "reportCannotWeakenAccessPrivilege", "reportNothingToOverride", "reportOverridingFinalMember", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "reportVarOverriddenByVal", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 6 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,457:1\n13#2:458\n18#2:463\n18#2:483\n25#2:491\n16#2:492\n18#2:519\n18#2:520\n1#3:459\n1#3:480\n1549#4:460\n1620#4,2:461\n1622#4:464\n1045#4:465\n1549#4:466\n1620#4,3:467\n1603#4,9:470\n1855#4:479\n1856#4:481\n1612#4:482\n1747#4,3:484\n1549#4:487\n1620#4,3:488\n288#4:493\n289#4:503\n1360#4:513\n1446#4,5:514\n110#5:494\n103#5,3:495\n94#5:498\n82#5:499\n88#5:501\n107#5:502\n110#5:504\n103#5,3:505\n94#5:508\n82#5:509\n88#5:511\n107#5:512\n38#6:500\n38#6:510\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n*L\n91#1:458\n113#1:463\n134#1:483\n257#1:491\n267#1:492\n410#1:519\n426#1:520\n129#1:480\n112#1:460\n112#1:461,2\n112#1:464\n114#1:465\n123#1:466\n123#1:467,3\n129#1:470,9\n129#1:479\n129#1:481\n129#1:482\n149#1:484,3\n201#1:487\n201#1:488,3\n289#1:493\n289#1:503\n363#1:513\n363#1:514,5\n292#1:494\n292#1:495,3\n292#1:498\n292#1:499\n292#1:501\n292#1:502\n299#1:504\n299#1:505,3\n299#1:508\n299#1:509\n299#1:511\n299#1:512\n292#1:500\n299#1:510\n*E\n"})
public final class FirOverrideChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOverrideChecker INSTANCE = new FirOverrideChecker();

    private FirOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        TypeCheckerState typeCheckerState = TypeComponentsKt.getTypeContext(context2.getSession()).newTypeCheckerState(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        for (FirDeclaration it : declaration2.getDeclarations()) {
            if (!(it instanceof FirSimpleFunction) && !(it instanceof FirProperty)) continue;
            FirCallableDeclaration callable2 = (FirCallableDeclaration)it;
            this.checkMember(callable2.getSymbol(), declaration2, reporter, typeCheckerState, firTypeScope, context2);
        }
    }

    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableSymbol<?> overrideDeclaration, FirCallableSymbol<?> baseDeclaration, CheckerContext context2) {
        List<FirTypeParameterSymbol> overrideTypeParameters = overrideDeclaration.getTypeParameterSymbols();
        if (overrideTypeParameters.isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        List<FirTypeParameterSymbol> baseTypeParameters = baseDeclaration.getTypeParameterSymbols();
        Map map2 = new LinkedHashMap();
        int size = Math.min(overrideTypeParameters.size(), baseTypeParameters.size());
        for (int it = 0; it < size; ++it) {
            FirTypeParameterSymbol to2 = overrideTypeParameters.get(it);
            FirTypeParameterSymbol from = baseTypeParameters.get(it);
            map2.put(from, FirNestedClassifierScopeKt.toConeType(to2));
        }
        return SubstitutorsKt.substitutorByMap(map2, context2.getSession()).substituteOrSelf($this$substituteAllTypeParameters);
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols2.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.FINAL) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Object v2;
        block2: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable = overriddenSymbols2;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                boolean bl2 = firPropertySymbol != null ? firPropertySymbol.isVar() : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context2) {
        boolean hasVisibleBase;
        block13: {
            boolean bl;
            block15: {
                List visibilities;
                block14: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Collection<FirCallableSymbol> collection;
                    void $this$mapTo$iv$iv;
                    FirCallableSymbol firCallableSymbol;
                    FirClass firClass;
                    DiagnosticReporter diagnosticReporter;
                    Iterator $this$sortedBy$iv;
                    Object object;
                    void $this$mapTo$iv$iv2;
                    if (overriddenSymbols2.isEmpty()) {
                        return;
                    }
                    Iterable $this$map$iv = overriddenSymbols2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        void $this$visibility$iv = it;
                        boolean $i$f$getVisibility = false;
                        object.add(TuplesKt.to((Object)it, (Object)$this$visibility$iv.getResolvedStatus().getVisibility()));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy2 = false;
                    visibilities = CollectionsKt.sortedWith((Iterable)((Object)$this$sortedBy$iv), (Comparator)new Comparator($this$checkVisibility){
                        final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                        {
                            this.$this_checkVisibility$inlined = firCallableSymbol;
                        }

                        public final int compare(T a, T b2) {
                            Pair pair = (Pair)a;
                            boolean bl = false;
                            FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                            boolean $i$f$getVisibility = false;
                            Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            pair = (Pair)b2;
                            Comparable comparable = Integer.valueOf(n != null ? n : Integer.MIN_VALUE);
                            bl = false;
                            $this$visibility$iv = this.$this_checkVisibility$inlined;
                            $i$f$getVisibility = false;
                            Integer n2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : Integer.MIN_VALUE));
                        }
                    });
                    if (!($this$checkVisibility instanceof FirPropertySymbol)) break block14;
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                    if (firPropertyAccessorSymbol != null) {
                        void $this$map$iv2;
                        Iterable $i$f$sortedBy2 = overriddenSymbols2;
                        diagnosticReporter = reporter;
                        firClass = containingClass;
                        firCallableSymbol = firPropertyAccessorSymbol;
                        object = this;
                        boolean $i$f$map2 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)it).getGetterSymbol();
                            collection.add((FirCallableSymbol)(firPropertyAccessorSymbol2 != null ? (FirCallableSymbol)firPropertyAccessorSymbol2 : it));
                        }
                        collection = (List)destination$iv$iv2;
                        super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                    }
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol3 = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol();
                    if (firPropertyAccessorSymbol3 == null) break block15;
                    Iterable $this$map$iv2 = overriddenSymbols2;
                    diagnosticReporter = reporter;
                    firClass = containingClass;
                    firCallableSymbol = firPropertyAccessorSymbol3;
                    object = this;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        FirPropertyAccessorSymbol it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl4 = false;
                        FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                        if (((FirPropertySymbol)it2).getSetterSymbol() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    collection = (List)destination$iv$iv3;
                    super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                    break block15;
                }
                for (Pair $this$mapNotNull$iv : visibilities) {
                    FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                    Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                    FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                    boolean $i$f$getVisibility = false;
                    Integer compare2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                    if (compare2 == null) {
                        this.reportCannotChangeAccessPrivilege(reporter, $this$checkVisibility, overridden, context2);
                        break;
                    }
                    if (compare2 >= 0) continue;
                    this.reportCannotWeakenAccessPrivilege(reporter, $this$checkVisibility, overridden, context2);
                    break;
                }
            }
            if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                return;
            }
            FirFile firFile = context2.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile file2 = firFile;
            List containingDeclarations2 = CollectionsKt.plus((Collection)context2.getContainingDeclarations(), (Object)containingClass);
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession());
            Iterable $this$any$iv = overriddenSymbols2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl7 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                    FirCallableDeclaration fir = (FirCallableDeclaration)it.getFir();
                    if (!FirVisibilityChecker.isVisible$default(visibilityChecker, fir, context2.getSession(), file2, containingDeclarations2, null, false, null, true, null, 352, null)) continue;
                    bl = true;
                    break block13;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkVisibility.getSource()), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, (Object)CollectionsKt.first(overriddenSymbols2), (DiagnosticContext)context2, null, (int)32, null);
        }
    }

    private final void checkDeprecation(FirCallableSymbol<?> $this$checkDeprecation, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context2) {
        DeprecationsPerUseSite ownDeprecation = $this$checkDeprecation.getDeprecation(FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()));
        if (ownDeprecation == null || ownDeprecation.isNotEmpty()) {
            return;
        }
        for (FirCallableSymbol<?> overriddenSymbol : overriddenSymbols2) {
            Object object;
            DeprecationsPerUseSite deprecationInfoFromOverridden;
            DeprecationInfo deprecationInfo;
            if (overriddenSymbol.getDeprecation(FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession())) == null || (deprecationInfo = deprecationInfoFromOverridden.getAll()) == null && ((object = deprecationInfoFromOverridden.getBySpecificSite()) != null && (object = object.values()) != null ? (DeprecationInfo)CollectionsKt.firstOrNull((Iterable)((Iterable)object)) : (deprecationInfo = null)) == null) continue;
            DeprecationInfo deprecationFromOverriddenSymbol = deprecationInfo;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkDeprecation.getSource()), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), overriddenSymbol, (Object)deprecationFromOverriddenSymbol, (DiagnosticContext)context2, null, (int)32, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirCallableSymbol<?> checkReturnType(FirCallableSymbol<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, TypeCheckerState typeCheckerState, CheckerContext context2) {
        void $this$mapTo$iv$iv;
        ConeKotlinType overridingReturnType = FirTypeUtilsKt.getConeType($this$checkReturnType.getResolvedReturnTypeRef());
        if (overridingReturnType instanceof ConeErrorType) {
            return null;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType(context2.getReturnTypeCalculator().tryCalculateReturnType((FirCallableSymbol<?>)it)));
        }
        List bounds = (List)destination$iv$iv;
        int n = bounds.size();
        for (int it = 0; it < n; ++it) {
            boolean isReturnTypeOkForOverride;
            FirCallableSymbol<?> overriddenDeclaration = overriddenSymbols2.get(it);
            ConeKotlinType overriddenReturnType = this.substituteAllTypeParameters((ConeKotlinType)bounds.get(it), $this$checkReturnType, overriddenDeclaration, context2);
            boolean bl = isReturnTypeOkForOverride = overriddenDeclaration instanceof FirPropertySymbol && ((FirPropertySymbol)overriddenDeclaration).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType) : AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerState)typeCheckerState, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType, (boolean)false, (int)8, null);
            if (isReturnTypeOkForOverride) continue;
            return overriddenDeclaration;
        }
        return null;
    }

    private final void checkDefaultValues(FirFunctionSymbol<?> $this$checkDefaultValues, DiagnosticReporter reporter, CheckerContext context2) {
        for (FirValueParameterSymbol valueParameterSymbol : $this$checkDefaultValues.getValueParameterSymbols()) {
            FirExpression defaultValue = ((FirValueParameter)valueParameterSymbol.getFir()).getDefaultValue();
            if (defaultValue == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)defaultValue.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE(), (DiagnosticContext)context2, null, (int)8, null);
        }
    }

    private final void checkDataClassCopy(FirCallableSymbol<?> $this$checkDataClassCopy, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, FirClass containingClass, CheckerContext context2) {
        FirCallableSymbol firCallableSymbol = (FirCallableSymbol)CollectionsKt.firstOrNull(overriddenMemberSymbols);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol overridden = firCallableSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(overridden, context2.getSession());
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol overriddenClass = firClassSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)containingClass.getSource()), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_DEFAULT_VALUES(), $this$checkDataClassCopy, (Object)overriddenClass, (DiagnosticContext)context2, null, (int)32, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkMember(FirCallableSymbol<?> member, FirClass containingClass, DiagnosticReporter reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext context) {
        block37: {
            block39: {
                block38: {
                    block36: {
                        overriddenMemberSymbols = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, member);
                        v0 = member;
                        v1 = KtTokens.OVERRIDE_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"OVERRIDE_KEYWORD");
                        hasOverrideKeyword = FirKeywordUtilsKt.hasModifier(v0, v1);
                        $this$isOverride$iv = member;
                        $i$f$isOverride = false;
                        if ($this$isOverride$iv.getRawStatus().isOverride() && hasOverrideKeyword) break block37;
                        if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context)) {
                            return;
                        }
                        v2 = member.getSource();
                        v3 /* !! */  = kind = v2 != null ? v2.getKind() : null;
                        if (kind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers) {
                            block35: {
                                var12_13 = overriddenMemberSymbols;
                                for (T var14_19 : var12_13) {
                                    it = (FirCallableSymbol)var14_19;
                                    $i$a$-find-FirOverrideChecker$checkMember$1 = false;
                                    $this$isFinal$iv = it;
                                    $i$f$isFinal = false;
                                    v4 = $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
                                    if (!v4) continue;
                                    v5 = var14_19;
                                    break block35;
                                }
                                v5 = null;
                            }
                            v6 = v5;
                            if (v6 != null) {
                                base = v6;
                                $i$a$-let-FirOverrideChecker$checkMember$2 = false;
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)containingClass.getSource()), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), member, (Object)base, (DiagnosticContext)context, null, (int)32, null);
                            }
                            if (Intrinsics.areEqual((Object)member.getName(), (Object)StandardNames.DATA_CLASS_COPY)) {
                                this.checkDataClassCopy(member, reporter, overriddenMemberSymbols, containingClass, context);
                            }
                            return;
                        }
                        if (!(kind instanceof KtRealSourceElementKind) && !(kind instanceof KtFakeSourceElementKind.PropertyFromParameter)) {
                            return;
                        }
                        visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
                        v7 = context.getContainingFile();
                        if (v7 == null) {
                            return;
                        }
                        file = v7;
                        containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), (Object)containingClass);
                        $this$firstOrNull$iv = overriddenMemberSymbols;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (FirCallableSymbol)element$iv;
                            $i$a$-firstOrNull-FirOverrideChecker$checkMember$overridden$1 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                            var21_37 = it;
                            var22_38 = visibilityChecker;
                            $i$f$originalOrSelf = false;
                            $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                            $i$f$originalOrSelf = false;
                            result$iv$iv = $this$originalOrSelf$iv$iv;
                            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                                $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                                $i$f$originalIfFakeOverride = false;
                                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                $i$f$getOriginalForSubstitutionOverride = false;
                                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                                $i$f$isSynthetic = false;
                                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                                // 2 sources

                                {
                                    v8 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                                } else {
                                    v8 = v9 = null;
                                }
                                if (v8 == null) {
                                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                    $i$f$getBaseForIntersectionOverride = false;
                                    v9 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                                }
                                if (v9 == null) break;
                                result$iv$iv = v9;
                            }
                            v10 = result$iv$iv.getSymbol();
                            if (v10 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                            }
                            if (!FirVisibilityChecker.isVisible$default(var22_38, (FirMemberDeclaration)v10.getFir(), context.getSession(), file, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                            v11 = element$iv;
                            break block36;
                        }
                        v11 = null;
                    }
                    var14_20 = v11;
                    if (var14_20 == null) break block38;
                    $i$f$firstOrNull = var14_20;
                    $i$f$originalOrSelf = false;
                    $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                    $i$f$originalOrSelf = false;
                    result$iv$iv = $this$originalOrSelf$iv$iv;
                    while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                        $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                        $i$f$originalIfFakeOverride = false;
                        $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        $i$f$getOriginalForSubstitutionOverride = false;
                        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                        $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                        $i$f$isSynthetic = false;
                        if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                        // 2 sources

                        {
                            v12 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                        } else {
                            v12 = v13 = null;
                        }
                        if (v12 == null) {
                            $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                            $i$f$getBaseForIntersectionOverride = false;
                            v13 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                        }
                        if (v13 == null) break;
                        result$iv$iv = v13;
                    }
                    v14 = result$iv$iv.getSymbol();
                    if (v14 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                    }
                    var15_22 = v14;
                    if (var15_22 != null) break block39;
                }
                return;
            }
            overridden = var15_22;
            v15 = ClassMembersKt.containingClassLookupTag(overridden);
            var16_25 = v15 != null ? LookupTagUtilsKt.toSymbol(v15, context.getSession()) : null;
            v16 = var16_25 instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)var16_25 : null;
            if (v16 == null) {
                return;
            }
            originalContainingClassSymbol = v16;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)member.getSource()), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member, (Object)originalContainingClassSymbol, (DiagnosticContext)context, null, (int)32, null);
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter, member, context);
            return;
        }
        this.checkOverriddenExperimentalities(member, overriddenMemberSymbols, context, reporter);
        v17 = this.checkModality(overriddenMemberSymbols);
        if (v17 != null) {
            it = v17;
            $i$a$-let-FirOverrideChecker$checkMember$3 = false;
            FirOverrideChecker.INSTANCE.reportOverridingFinalMember(reporter, member, it, context);
        }
        if (member instanceof FirPropertySymbol) {
            v18 = this.checkMutability((FirPropertySymbol)member, overriddenMemberSymbols);
            if (v18 != null) {
                it = v18;
                $i$a$-let-FirOverrideChecker$checkMember$4 = false;
                FirOverrideChecker.INSTANCE.reportVarOverriddenByVal(reporter, member, it, context);
            }
        }
        this.checkVisibility(member, containingClass, reporter, overriddenMemberSymbols, context);
        this.checkDeprecation(member, reporter, overriddenMemberSymbols, context);
        if (member instanceof FirFunctionSymbol) {
            this.checkDefaultValues((FirFunctionSymbol)member, reporter, context);
        }
        v19 = this.checkReturnType(member, overriddenMemberSymbols, typeCheckerState, context);
        if (v19 == null) {
            return;
        }
        restriction = v19;
        var10_12 = member;
        if (var10_12 instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(reporter, member, restriction, context);
        } else if (var10_12 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member).isVar()) {
                this.reportTypeMismatchOnVariable(reporter, member, restriction, context);
            } else {
                this.reportTypeMismatchOnProperty(reporter, member, restriction, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOverriddenExperimentalities(FirCallableSymbol<?> memberSymbol, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$flatMapTo$iv$iv;
        FirOptInUsageBaseChecker $this$checkOverriddenExperimentalities_u24lambda_u2413 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set overriddenExperimentalities = new LinkedHashSet();
        FirSession session2 = context2.getSession();
        Iterable $this$flatMap$iv = overriddenMemberSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            FirCallableSymbol firCallableSymbol = it;
            Iterable list$iv$iv = firCallableSymbol instanceof FirIntersectionOverridePropertySymbol ? ((FirIntersectionOverridePropertySymbol)it).getIntersections() : (firCallableSymbol instanceof FirIntersectionOverrideFunctionSymbol ? ((FirIntersectionOverrideFunctionSymbol)it).getIntersections() : (Collection<FirCallableSymbol<Object>>)CollectionsKt.listOf((Object)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List overriddenSymbolsWithUnwrappedIntersectionOverrides = (List)destination$iv$iv;
        for (FirCallableSymbol overriddenMemberSymbol : overriddenSymbolsWithUnwrappedIntersectionOverrides) {
            $this$checkOverriddenExperimentalities_u24lambda_u2413.loadExperimentalitiesFromAnnotationTo(overriddenMemberSymbol, session2, overriddenExperimentalities);
        }
        $this$checkOverriddenExperimentalities_u24lambda_u2413.reportNotAcceptedOverrideExperimentalities(overriddenExperimentalities, memberSymbol, context2, reporter);
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration2, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportNothingToOverride, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration2, (DiagnosticContext)context2, null, (int)16, null);
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        block0: {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
            if (coneClassLikeLookupTag == null) break block0;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportOverridingFinalMember, (AbstractKtSourceElement)((AbstractKtSourceElement)overriding.getSource()), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, (int)32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportVarOverriddenByVal, (AbstractKtSourceElement)((AbstractKtSourceElement)overriding.getSource()), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overriding, overridden, (DiagnosticContext)context2, null, (int)32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportCannotWeakenAccessPrivilege, (AbstractKtSourceElement)((AbstractKtSourceElement)overriding.getSource()), FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, (int)64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportCannotChangeAccessPrivilege, (AbstractKtSourceElement)((AbstractKtSourceElement)overriding.getSource()), FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, (int)64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportReturnTypeMismatchOnFunction, (AbstractKtSourceElement)((AbstractKtSourceElement)overriding.getSource()), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, (int)32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportTypeMismatchOnProperty, (AbstractKtSourceElement)((AbstractKtSourceElement)overriding.getSource()), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, (int)32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$this$reportTypeMismatchOnVariable, (AbstractKtSourceElement)((AbstractKtSourceElement)overriding.getSource()), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, (int)32, null);
    }
}

