/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0007\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u000eH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getConstructorDelegationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "getConstructorProhibitedPropertyParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "isProhibitedDeclarationWithBody", "", "isProhibitedEnumConstructor", "lastClass", "isProhibitedPrivateDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n37#2:99\n37#2:100\n43#2:101\n21#2:105\n70#2:106\n766#3:102\n857#3,2:103\n*S KotlinDebug\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n*L\n32#1:99\n38#1:100\n66#1:101\n87#1:105\n95#1:106\n68#1:102\n68#1:103,2\n*E\n"})
public final class FirExpectConsistencyChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectConsistencyChecker INSTANCE = new FirExpectConsistencyChecker();

    private FirExpectConsistencyChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirClass lastClass;
        KtSourceElement source;
        block16: {
            block15: {
                FirMemberDeclaration $this$isExpect$iv;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                KtSourceElement ktSourceElement = declaration2.getSource();
                if (ktSourceElement == null) {
                    return;
                }
                source = ktSourceElement;
                if (source.getKind() instanceof KtFakeSourceElementKind) {
                    return;
                }
                Iterator<FirValueParameter> iterator2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                FirClass firClass = lastClass = iterator2 instanceof FirClass ? (FirClass)((Object)iterator2) : null;
                if (declaration2 instanceof FirAnonymousInitializer) {
                    boolean bl;
                    FirClass firClass2 = lastClass;
                    if (firClass2 != null) {
                        $this$isExpect$iv = firClass2;
                        boolean $i$f$isExpect = false;
                        bl = $this$isExpect$iv.getStatus().isExpect();
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, (int)8, null);
                    }
                    return;
                }
                if (!(declaration2 instanceof FirMemberDeclaration)) break block15;
                $this$isExpect$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect()) break block16;
            }
            return;
        }
        FirDelegatedConstructorCall firDelegatedConstructorCall = this.getConstructorDelegationCall((FirMemberDeclaration)declaration2);
        if (firDelegatedConstructorCall != null) {
            FirDelegatedConstructorCall delegatedConstructor = firDelegatedConstructorCall;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)delegatedConstructor.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL(), (DiagnosticContext)context2, null, (int)8, null);
        }
        for (FirValueParameter propertyParameter : this.getConstructorProhibitedPropertyParameters((FirMemberDeclaration)declaration2, lastClass)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)propertyParameter.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (this.isProhibitedEnumConstructor((FirMemberDeclaration)declaration2, lastClass)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getEXPECTED_ENUM_CONSTRUCTOR(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (this.isProhibitedPrivateDeclaration((FirMemberDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (this.isProhibitedDeclarationWithBody((FirMemberDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, (int)8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirValueParameter> getConstructorProhibitedPropertyParameters(FirMemberDeclaration declaration2, FirClass containingClass) {
        if (declaration2 instanceof FirPrimaryConstructor && containingClass != null && containingClass.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            FirMemberDeclaration $this$isInline$iv = containingClass;
            boolean $i$f$isInline = false;
            if (!$this$isInline$iv.getStatus().isInline()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((FirPrimaryConstructor)declaration2).getValueParameters();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(FirKeywordUtilsKt.getValOrVarKeyword(it.getSource()) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    private final FirDelegatedConstructorCall getConstructorDelegationCall(FirMemberDeclaration declaration2) {
        if (declaration2 instanceof FirConstructor && !((FirConstructor)declaration2).isPrimary()) {
            KtSourceElement delegatedConstructorSource;
            FirDelegatedConstructorCall delegatedConstructor;
            FirDelegatedConstructorCall firDelegatedConstructorCall = delegatedConstructor = ((FirConstructor)declaration2).getDelegatedConstructor();
            KtSourceElement ktSourceElement = delegatedConstructorSource = firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getSource() : null;
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                return delegatedConstructor;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedPrivateDeclaration(FirMemberDeclaration declaration2) {
        if (declaration2 instanceof FirConstructor) return false;
        if (declaration2 instanceof FirPropertyAccessor) return false;
        FirMemberDeclaration $this$visibility$iv = declaration2;
        boolean $i$f$getVisibility = false;
        if (!Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedEnumConstructor(FirMemberDeclaration declaration2, FirClass lastClass) {
        if (!(declaration2 instanceof FirConstructor)) return false;
        FirClass firClass = lastClass;
        if ((firClass != null ? firClass.getClassKind() : null) != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedDeclarationWithBody(FirMemberDeclaration declaration2) {
        if (!(declaration2 instanceof FirFunction)) return false;
        FirFunction $this$hasBody$iv = (FirFunction)declaration2;
        boolean $i$f$getHasBody = false;
        if ($this$hasBody$iv.getBody() == null) return false;
        return true;
    }
}

