/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ExpectActualUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualCallableDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkReturnTypes", "callableDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirActualCallableDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualCallableDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualCallableDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,69:1\n36#2:70\n*S KotlinDebug\n*F\n+ 1 FirActualCallableDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualCallableDeclarationChecker\n*L\n26#1:70\n*E\n"})
public final class FirActualCallableDeclarationChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirActualCallableDeclarationChecker INSTANCE = new FirActualCallableDeclarationChecker();

    private FirActualCallableDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isActual$iv = declaration2;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        this.checkReturnTypes(declaration2, context2, reporter);
    }

    private final void checkReturnTypes(FirCallableDeclaration callableDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        FirCallableSymbol<? extends FirCallableDeclaration> actualFunctionSymbol = callableDeclaration.getSymbol();
        FirBasedSymbol<?> firBasedSymbol = ExpectActualAttributesKt.getSingleExpectForActualOrNull((FirBasedSymbol)actualFunctionSymbol);
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol expectFunctionSymbol = firCallableSymbol;
        firBasedSymbol = FirHelpersKt.getContainingClassSymbol(expectFunctionSymbol, expectFunctionSymbol.getModuleData().getSession());
        List list2 = firBasedSymbol != null ? ((FirClassLikeSymbol)firBasedSymbol).getTypeParameterSymbols() : null;
        if (list2 == null) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        List expectTypeParameters = list2;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)actualFunctionSymbol, context2.getSession());
        List list3 = firClassLikeSymbol != null ? firClassLikeSymbol.getTypeParameterSymbols() : null;
        if (list3 == null) {
            list3 = kotlin.collections.CollectionsKt.emptyList();
        }
        List actualClassTypeParameters = list3;
        List list4 = CollectionsKt.zipIfSizesAreEqual((Collection)expectTypeParameters, (Collection)actualClassTypeParameters);
        if (list4 == null) {
            return;
        }
        ConeSubstitutor parentSubstitutor = ExpectActualUtilsKt.createExpectActualTypeParameterSubstitutor$default(list4, context2.getSession(), null, 4, null);
        List list5 = CollectionsKt.zipIfSizesAreEqual((Collection)expectFunctionSymbol.getTypeParameterSymbols(), (Collection)actualFunctionSymbol.getTypeParameterSymbols());
        if (list5 == null) {
            return;
        }
        ConeSubstitutor substitutor3 = ExpectActualUtilsKt.createExpectActualTypeParameterSubstitutor(list5, context2.getSession(), parentSubstitutor);
        if (!ExpectActualUtilsKt.areCompatibleExpectActualTypes(substitutor3.substituteOrSelf(expectFunctionSymbol.getResolvedReturnType().getType()), actualFunctionSymbol.getResolvedReturnType().getType(), context2.getSession(), false)) {
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)callableDeclaration.getSource();
            KtDiagnosticFactory2<FirBasedSymbol<?>, Map<ExpectActualCompatibility<FirBasedSymbol<?>>, Collection<FirBasedSymbol<?>>>> ktDiagnosticFactory2 = FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT();
            Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> map2 = ExpectActualAttributesKt.getExpectForActual((FirBasedSymbol)actualFunctionSymbol);
            Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.Map<org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility<org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>>, kotlin.collections.Collection<org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>>>");
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory2, actualFunctionSymbol, map2, (DiagnosticContext)context2, null, (int)32, null);
        }
    }
}

