/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.DynamicBundle;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationClassBrowser;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationIcons;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationIconsDialog;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactProperties;
import org.jetbrains.plugins.javaFX.packaging.JavaFxEditCertificatesDialog;
import org.jetbrains.plugins.javaFX.packaging.JavaFxManifestAttribute;
import org.jetbrains.plugins.javaFX.packaging.JavaFxPackagerConstants;

public final class JavaFxArtifactPropertiesEditor
extends ArtifactPropertiesEditor {
    private final JavaFxArtifactProperties myProperties;
    private JPanel myWholePanel;
    private JTextField myTitleTF;
    private JTextField myVendorTF;
    private JEditorPane myDescriptionEditorPane;
    private TextFieldWithBrowseButton myAppClass;
    private JTextField myVersionTF;
    private JTextField myWidthTF;
    private JTextField myHeightTF;
    private TextFieldWithBrowseButton myHtmlTemplate;
    private JTextField myHtmlPlaceholderIdTF;
    private TextFieldWithBrowseButton myHtmlParams;
    private TextFieldWithBrowseButton myParams;
    private JCheckBox myUpdateInBackgroundCB;
    private JCheckBox myEnableSigningCB;
    private JButton myEditSignCertificateButton;
    private JCheckBox myConvertCssToBinCheckBox;
    private JComboBox<String> myNativeBundleCB;
    private JButton myEditAttributesButton;
    private JButton myEditIconsButton;
    private JavaFxEditCertificatesDialog myDialog;
    private List<JavaFxManifestAttribute> myCustomManifestAttributes;
    private JavaFxApplicationIcons myIcons;
    private JComboBox<String> myMsgOutputLevel;

    public JavaFxArtifactPropertiesEditor(JavaFxArtifactProperties properties, final Project project, Artifact artifact) {
        this.myProperties = properties;
        this.$$$setupUI$$$();
        JavaFxApplicationClassBrowser.appClassBrowser(project, artifact).setField((ComponentWithBrowseButton)this.myAppClass);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"properties");
        this.myHtmlParams.addBrowseFolderListener(JavaFXBundle.message("javafx.artifact.properties.editor.choose.file.standalone.title", new Object[0]), JavaFXBundle.message("javafx.artifact.properties.editor.choose.file.standalone.description", new Object[0]), project, descriptor);
        this.myParams.addBrowseFolderListener(JavaFXBundle.message("javafx.artifact.properties.editor.choose.file.run.in.browser.title", new Object[0]), JavaFXBundle.message("javafx.artifact.properties.editor.choose.file.run.in.browser.description", new Object[0]), project, descriptor);
        this.myHtmlTemplate.addBrowseFolderListener(JavaFXBundle.message("javafx.artifact.properties.editor.choose.html.file.title", new Object[0]), JavaFXBundle.message("javafx.artifact.properties.editor.choose.html.file.description", new Object[0]), project, FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)HtmlFileType.INSTANCE));
        this.myEditSignCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFxArtifactPropertiesEditor.this.myDialog = new JavaFxEditCertificatesDialog(JavaFxArtifactPropertiesEditor.this.myWholePanel, JavaFxArtifactPropertiesEditor.this.myProperties, project);
                JavaFxArtifactPropertiesEditor.this.myDialog.show();
            }
        });
        this.myEnableSigningCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFxArtifactPropertiesEditor.this.myEditSignCertificateButton.setEnabled(JavaFxArtifactPropertiesEditor.this.myEnableSigningCB.isSelected());
            }
        });
        this.myEditAttributesButton.addActionListener(e -> {
            CustomManifestAttributesDialog customManifestAttributesDialog = new CustomManifestAttributesDialog(this.myWholePanel, this.myCustomManifestAttributes);
            if (customManifestAttributesDialog.showAndGet()) {
                this.myCustomManifestAttributes = customManifestAttributesDialog.getAttrs();
            }
        });
        this.myEditIconsButton.addActionListener(e -> {
            JavaFxApplicationIconsDialog iconsDialog = new JavaFxApplicationIconsDialog(this.myWholePanel, this.myIcons, project);
            if (iconsDialog.showAndGet()) {
                this.myIcons = iconsDialog.getIcons();
            }
        });
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (JavaFxPackagerConstants.NativeBundles bundle : JavaFxPackagerConstants.NativeBundles.values()) {
            bundleNames.add(bundle.name());
        }
        this.myNativeBundleCB.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(bundleNames)));
        List outputLevels = ContainerUtil.map((Object[])JavaFxPackagerConstants.MsgOutputLevel.values(), Enum::name);
        this.myMsgOutputLevel.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray((Collection)outputLevels)));
    }

    public String getTabName() {
        return JavaFXBundle.message("java.fx.artifacts.tab.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getTitle(), this.myTitleTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getVendor(), this.myVendorTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getDescription(), this.myDescriptionEditorPane)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getWidth(), this.myWidthTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getHeight(), this.myHeightTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getAppClass(), this.myAppClass)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getVersion(), this.myVersionTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getHtmlTemplateFile(), JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myHtmlTemplate))) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getHtmlPlaceholderId(), this.myHtmlPlaceholderIdTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getHtmlParamFile(), JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myHtmlParams))) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getParamFile(), JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myParams))) {
            return true;
        }
        if (!Comparing.equal((Object)this.myNativeBundleCB.getSelectedItem(), (Object)this.myProperties.getNativeBundle())) {
            return true;
        }
        boolean inBackground = Comparing.strEqual((String)this.myProperties.getUpdateMode(), (String)"background");
        if (inBackground != this.myUpdateInBackgroundCB.isSelected()) {
            return true;
        }
        if (this.myProperties.isEnabledSigning() != this.myEnableSigningCB.isSelected()) {
            return true;
        }
        if (this.myProperties.isConvertCss2Bin() != this.myConvertCssToBinCheckBox.isSelected()) {
            return true;
        }
        if (this.myDialog != null) {
            if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getAlias(), this.myDialog.myPanel.myAliasTF)) {
                return true;
            }
            if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getKeystore(), this.myDialog.myPanel.myKeystore)) {
                return true;
            }
            String keypass = this.myProperties.getKeypass();
            if (JavaFxArtifactPropertiesEditor.isModified(keypass != null ? new String(Base64.getDecoder().decode(keypass), StandardCharsets.UTF_8) : "", this.myDialog.myPanel.myKeypassTF)) {
                return true;
            }
            String storepass = this.myProperties.getStorepass();
            if (JavaFxArtifactPropertiesEditor.isModified(storepass != null ? new String(Base64.getDecoder().decode(storepass), StandardCharsets.UTF_8) : "", this.myDialog.myPanel.myStorePassTF)) {
                return true;
            }
            if (this.myProperties.isSelfSigning() != this.myDialog.myPanel.mySelfSignedRadioButton.isSelected()) {
                return true;
            }
        }
        if (!Comparing.equal(this.myCustomManifestAttributes, this.myProperties.getCustomManifestAttributes())) {
            return true;
        }
        if (!Comparing.equal((Object)this.myIcons, (Object)this.myProperties.getIcons())) {
            return true;
        }
        return !Comparing.equal((Object)this.myMsgOutputLevel.getSelectedItem(), (Object)this.myProperties.getMsgOutputLevel());
    }

    private static boolean isModified(String title, JTextComponent tf) {
        return !Comparing.strEqual((String)title, (String)tf.getText().trim());
    }

    private static boolean isModified(String title, TextFieldWithBrowseButton tf) {
        return !Comparing.strEqual((String)title, (String)tf.getText().trim());
    }

    private static boolean isModified(String title, String value) {
        return !Comparing.strEqual((String)title, (String)value);
    }

    public void apply() {
        this.myProperties.setTitle(this.myTitleTF.getText());
        this.myProperties.setVendor(this.myVendorTF.getText());
        this.myProperties.setDescription(this.myDescriptionEditorPane.getText());
        this.myProperties.setAppClass(this.myAppClass.getText());
        this.myProperties.setVersion(this.myVersionTF.getText());
        this.myProperties.setWidth(this.myWidthTF.getText());
        this.myProperties.setHeight(this.myHeightTF.getText());
        this.myProperties.setHtmlTemplateFile(JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myHtmlTemplate));
        this.myProperties.setHtmlPlaceholderId(this.myHtmlPlaceholderIdTF.getText());
        this.myProperties.setHtmlParamFile(JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myHtmlParams));
        this.myProperties.setParamFile(JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myParams));
        this.myProperties.setUpdateMode(this.myUpdateInBackgroundCB.isSelected() ? "background" : "always");
        this.myProperties.setEnabledSigning(this.myEnableSigningCB.isSelected());
        this.myProperties.setConvertCss2Bin(this.myConvertCssToBinCheckBox.isSelected());
        this.myProperties.setNativeBundle((String)this.myNativeBundleCB.getSelectedItem());
        if (this.myDialog != null) {
            this.myProperties.setSelfSigning(this.myDialog.myPanel.mySelfSignedRadioButton.isSelected());
            this.myProperties.setAlias(this.myDialog.myPanel.myAliasTF.getText());
            this.myProperties.setKeystore(this.myDialog.myPanel.myKeystore.getText());
            String keyPass = String.valueOf(this.myDialog.myPanel.myKeypassTF.getPassword());
            this.myProperties.setKeypass(!StringUtil.isEmptyOrSpaces((String)keyPass) ? Base64.getEncoder().encodeToString(keyPass.getBytes(StandardCharsets.UTF_8)) : null);
            String storePass = String.valueOf(this.myDialog.myPanel.myStorePassTF.getPassword());
            this.myProperties.setStorepass(!StringUtil.isEmptyOrSpaces((String)storePass) ? Base64.getEncoder().encodeToString(storePass.getBytes(StandardCharsets.UTF_8)) : null);
        }
        this.myProperties.setCustomManifestAttributes(this.myCustomManifestAttributes);
        this.myProperties.setIcons(this.myIcons);
        this.myProperties.setMsgOutputLevel((String)this.myMsgOutputLevel.getSelectedItem());
    }

    @Nullable
    public String getHelpId() {
        return "Project_Structure_Artifacts_Java_FX_tab";
    }

    public void reset() {
        JavaFxArtifactPropertiesEditor.setText(this.myTitleTF, this.myProperties.getTitle());
        JavaFxArtifactPropertiesEditor.setText(this.myVendorTF, this.myProperties.getVendor());
        JavaFxArtifactPropertiesEditor.setText(this.myDescriptionEditorPane, this.myProperties.getDescription());
        JavaFxArtifactPropertiesEditor.setText(this.myWidthTF, this.myProperties.getWidth());
        JavaFxArtifactPropertiesEditor.setText(this.myHeightTF, this.myProperties.getHeight());
        JavaFxArtifactPropertiesEditor.setText(this.myAppClass, this.myProperties.getAppClass());
        JavaFxArtifactPropertiesEditor.setText(this.myVersionTF, this.myProperties.getVersion());
        JavaFxArtifactPropertiesEditor.setSystemDependentPath(this.myHtmlTemplate, this.myProperties.getHtmlTemplateFile());
        JavaFxArtifactPropertiesEditor.setText(this.myHtmlPlaceholderIdTF, this.myProperties.getHtmlPlaceholderId());
        JavaFxArtifactPropertiesEditor.setSystemDependentPath(this.myHtmlParams, this.myProperties.getHtmlParamFile());
        JavaFxArtifactPropertiesEditor.setSystemDependentPath(this.myParams, this.myProperties.getParamFile());
        this.myNativeBundleCB.setSelectedItem(this.myProperties.getNativeBundle());
        this.myUpdateInBackgroundCB.setSelected(Comparing.strEqual((String)this.myProperties.getUpdateMode(), (String)"background"));
        this.myEnableSigningCB.setSelected(this.myProperties.isEnabledSigning());
        this.myConvertCssToBinCheckBox.setSelected(this.myProperties.isConvertCss2Bin());
        this.myEditSignCertificateButton.setEnabled(this.myProperties.isEnabledSigning());
        this.myCustomManifestAttributes = this.myProperties.getCustomManifestAttributes();
        this.myIcons = this.myProperties.getIcons();
        this.myMsgOutputLevel.setSelectedItem(this.myProperties.getMsgOutputLevel());
    }

    private static void setText(TextFieldWithBrowseButton tf, String title) {
        if (title != null) {
            tf.setText(title.trim());
        }
    }

    private static void setText(JTextComponent tf, String title) {
        if (title != null) {
            tf.setText(title.trim());
        }
    }

    public void disposeUIResources() {
        if (this.myDialog != null) {
            this.myDialog.myPanel = null;
        }
    }

    static String getSystemIndependentPath(TextFieldWithBrowseButton withBrowseButton) {
        String text = withBrowseButton.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)text.trim());
    }

    static void setSystemDependentPath(TextFieldWithBrowseButton withBrowseButton, String path) {
        withBrowseButton.setText(path != null ? FileUtil.toSystemDependentName((String)path.trim()) : "");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox;
        JButton jButton3;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JTextField jTextField3;
        JTextField jTextField4;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JEditorPane jEditorPane;
        JTextField jTextField5;
        JTextField jTextField6;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(18, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.title"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTitleTF = jTextField6 = new JTextField();
        jPanel2.add((Component)jTextField6, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.vendor"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVendorTF = jTextField5 = new JTextField();
        jPanel2.add((Component)jTextField5, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        this.myDescriptionEditorPane = jEditorPane = new JEditorPane();
        jBScrollPane.setViewportView(jEditorPane);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.description"));
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.application.class"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppClass = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.width"));
        jPanel2.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWidthTF = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.height"));
        jPanel2.add((Component)jLabel6, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeightTF = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.html.template"));
        jPanel2.add((Component)jLabel7, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlTemplate = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(7, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.html.placeholder.id"));
        jPanel2.add((Component)jLabel8, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlPlaceholderIdTF = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(8, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.html.parameters"));
        jPanel2.add((Component)jLabel9, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlParams = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(9, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.application.parameters"));
        jPanel2.add((Component)jLabel10, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParams = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(10, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUpdateInBackgroundCB = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.update.in.background.option"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(11, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEnableSigningCB = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.signing.option"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(14, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(14, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEditSignCertificateButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.edit.certificates.button"));
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConvertCssToBinCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.convert.css.to.bin.option"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.native.bundle"));
        jPanel2.add((Component)jLabel11, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myNativeBundleCB = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(12, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.custom.manifest.attributes"));
        jPanel2.add((Component)jLabel12, new GridConstraints(15, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(15, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEditAttributesButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.edit.attributes.button"));
        jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(16, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEditIconsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.edit.icons.button"));
        jPanel5.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.application.icon"));
        jPanel2.add((Component)jLabel13, new GridConstraints(16, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.version"));
        jPanel2.add((Component)jLabel14, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionTF = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, DynamicBundle.getBundle((String)"messages/JavaFXBundle", JavaFxArtifactPropertiesEditor.class).getString("javafx.artifact.properties.editor.build.output.level"));
        jPanel2.add((Component)jLabel15, new GridConstraints(17, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myMsgOutputLevel = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(17, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField6);
        jLabel2.setLabelFor(jTextField5);
        jLabel3.setLabelFor(jEditorPane);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton4);
        jLabel5.setLabelFor(jTextField4);
        jLabel6.setLabelFor(jTextField3);
        jLabel7.setLabelFor((Component)textFieldWithBrowseButton3);
        jLabel8.setLabelFor(jTextField2);
        jLabel9.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel10.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel11.setLabelFor(jComboBox2);
        jLabel14.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class CustomManifestAttributesDialog
    extends DialogWrapper {
        private final JPanel myWholePanel = new JPanel(new BorderLayout());
        private final AttributesTable myTable = new AttributesTable();

        private CustomManifestAttributesDialog(JPanel panel, List<JavaFxManifestAttribute> attrs) {
            super((Component)panel, true);
            this.myTable.setValues(attrs);
            this.myWholePanel.add((Component)this.myTable.getComponent(), "Center");
            this.setTitle(JavaFXBundle.message("javafx.artifact.properties.editor.edit.custom.manifest.attributes", new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        protected void doOKAction() {
            this.myTable.stopEditing();
            super.doOKAction();
        }

        List<JavaFxManifestAttribute> getAttrs() {
            return this.myTable.getAttrs();
        }

        private static final class AttributesTable
        extends ListTableWithButtons<JavaFxManifestAttribute> {
            private AttributesTable() {
            }

            protected ListTableModel createListModel() {
                ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute> name = new ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute>(JavaFXBundle.message("column.name.artifact.manifest.property.name", new Object[0])){

                    @Nullable
                    public String valueOf(JavaFxManifestAttribute attribute) {
                        return attribute.getName();
                    }

                    public boolean isCellEditable(JavaFxManifestAttribute attr) {
                        return true;
                    }

                    public void setValue(JavaFxManifestAttribute attr, String value) {
                        attr.setName(value);
                    }

                    @Nullable
                    protected String getDescription(JavaFxManifestAttribute element) {
                        return element.getName();
                    }
                };
                ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute> value = new ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute>(JavaFXBundle.message("column.name.artifact.manifest.property.value", new Object[0])){

                    public String valueOf(JavaFxManifestAttribute attr) {
                        return attr.getValue();
                    }

                    public boolean isCellEditable(JavaFxManifestAttribute attr) {
                        return true;
                    }

                    public void setValue(JavaFxManifestAttribute attr, String s) {
                        attr.setValue(s);
                    }

                    @Nullable
                    protected String getDescription(JavaFxManifestAttribute attr) {
                        return attr.getValue();
                    }
                };
                return new ListTableModel(new ColumnInfo[]{name, value});
            }

            protected JavaFxManifestAttribute createElement() {
                return new JavaFxManifestAttribute("", "");
            }

            protected boolean isEmpty(JavaFxManifestAttribute element) {
                return StringUtil.isEmpty((String)element.getName()) && StringUtil.isEmpty((String)element.getValue());
            }

            protected JavaFxManifestAttribute cloneElement(JavaFxManifestAttribute attribute) {
                return new JavaFxManifestAttribute(attribute.getName(), attribute.getValue());
            }

            protected boolean canDeleteElement(JavaFxManifestAttribute selection) {
                return true;
            }

            public List<JavaFxManifestAttribute> getAttrs() {
                return this.getElements();
            }
        }
    }
}

