/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.theoryinpractice.testng.TestngBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpectedExceptionNeverThrownTestNGInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExpectedExceptionNeverThrownTestNGInspection.$$$reportNull$$$0(0);
        }
        return new ExpectedExceptionNeverThrownVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/theoryinpractice/testng/inspection/ExpectedExceptionNeverThrownTestNGInspection", "buildVisitor"));
    }

    private static class ExpectedExceptionNeverThrownVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        ExpectedExceptionNeverThrownVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ExpectedExceptionNeverThrownVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.testng.annotations.Test"});
            if (annotation == null) {
                return;
            }
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("expectedExceptions");
            if (value == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            List exceptionsThrown = ExceptionUtil.getThrownExceptions((PsiElement)body);
            if (value instanceof PsiClassObjectAccessExpression) {
                this.checkAnnotationMemberValue(value, method, exceptionsThrown);
            } else if (value instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue arrayInitializerMemberValue = (PsiArrayInitializerMemberValue)value;
                for (PsiAnnotationMemberValue memberValue : arrayInitializerMemberValue.getInitializers()) {
                    this.checkAnnotationMemberValue(memberValue, method, exceptionsThrown);
                }
            }
        }

        private void checkAnnotationMemberValue(PsiAnnotationMemberValue annotationMemberValue, PsiMethod method, List<PsiClassType> exceptionsThrown) {
            if (!(annotationMemberValue instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)annotationMemberValue;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiType type = operand.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType expectedType = (PsiClassType)type;
            if (InheritanceUtil.isInheritor((PsiType)expectedType, (String)"java.lang.RuntimeException")) {
                return;
            }
            for (PsiClassType exceptionType : exceptionsThrown) {
                if (!exceptionType.isAssignableFrom((PsiType)expectedType)) continue;
                return;
            }
            this.myProblemsHolder.registerProblem((PsiElement)operand, TestngBundle.message("inspection.testng.expected.exception.never.thrown.problem", method.getName()), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/theoryinpractice/testng/inspection/ExpectedExceptionNeverThrownTestNGInspection$ExpectedExceptionNeverThrownVisitor", "visitMethod"));
        }
    }
}

