/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.tasks.mantis.MantisFilter;
import com.intellij.tasks.mantis.MantisProject;
import com.intellij.tasks.mantis.MantisRepository;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MantisRepositoryEditor
extends BaseRepositoryEditor<MantisRepository> {
    private ComboBox<MantisProject> myProjectCombobox;
    private ComboBox<MantisFilter> myFilterCombobox;
    private JBLabel myProjectLabel;
    private JBLabel myFilterLabel;
    private boolean myInitialized = false;

    public MantisRepositoryEditor(Project project, MantisRepository repository, Consumer<? super MantisRepository> changeListener) {
        super(project, repository, changeListener);
        this.myTestButton.setText(TaskBundle.message((String)"login", (Object[])new Object[0]));
        this.myTestButton.setEnabled(((MantisRepository)this.myRepository).isConfigured());
        this.myProjectCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MantisProject project;
                if (e.getStateChange() == 1 && (project = (MantisProject)MantisRepositoryEditor.this.myProjectCombobox.getSelectedItem()) != null) {
                    MantisRepositoryEditor.this.myFilterCombobox.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(project.getFilters())));
                    if (!project.equals(((MantisRepository)MantisRepositoryEditor.this.myRepository).getCurrentProject())) {
                        MantisRepositoryEditor.this.myFilterCombobox.setSelectedIndex(0);
                        MantisRepositoryEditor.this.doApply();
                    } else if (!MantisRepositoryEditor.this.myInitialized) {
                        MantisRepositoryEditor.this.myFilterCombobox.setSelectedItem((Object)((MantisRepository)MantisRepositoryEditor.this.myRepository).getCurrentFilter());
                        MantisRepositoryEditor.this.myInitialized = true;
                    }
                }
            }
        });
        this.installListener((JComboBox)this.myFilterCombobox);
        if (((MantisRepository)this.myRepository).getCurrentProject() != null) {
            UIUtil.invokeLaterIfNeeded(() -> new FetchMantisProjects().queue());
        }
    }

    @Override
    public void apply() {
        super.apply();
        ((MantisRepository)this.myRepository).setCurrentProject((MantisProject)this.myProjectCombobox.getSelectedItem());
        ((MantisRepository)this.myRepository).setCurrentFilter((MantisFilter)this.myFilterCombobox.getSelectedItem());
        this.myTestButton.setEnabled(((MantisRepository)this.myRepository).isConfigured());
    }

    @Override
    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            new FetchMantisProjects().queue();
        } else {
            this.myProjectCombobox.removeAllItems();
            this.myFilterCombobox.removeAllItems();
        }
    }

    @Override
    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
        this.myFilterLabel.setAnchor(anchor);
    }

    @Override
    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel(TaskBundle.message((String)"label.project", (Object[])new Object[0]), 4);
        this.myProjectCombobox = new ComboBox(200);
        this.myProjectCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)TaskBundle.message((String)"label.login.first", (Object[])new Object[0]), MantisProject::getName));
        this.myFilterLabel = new JBLabel(TaskBundle.message((String)"label.filter", (Object[])new Object[0]), 4);
        this.myFilterCombobox = new ComboBox(200);
        this.myFilterCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)TaskBundle.message((String)"label.login.first", (Object[])new Object[0]), MantisFilter::getName));
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myProjectLabel, this.myProjectCombobox).addLabeledComponent((JComponent)this.myFilterLabel, this.myFilterCombobox).getPanel();
    }

    private final class FetchMantisProjects
    extends TaskUiUtil.ComboBoxUpdater<MantisProject> {
        private FetchMantisProjects() {
            super(MantisRepositoryEditor.this.myProject, TaskBundle.message((String)"progress.title.downloading.mantis.projects", (Object[])new Object[0]), MantisRepositoryEditor.this.myProjectCombobox);
        }

        @Override
        @NotNull
        protected List<MantisProject> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                FetchMantisProjects.$$$reportNull$$$0(0);
            }
            ((MantisRepository)MantisRepositoryEditor.this.myRepository).refreshProjects();
            List<MantisProject> list = ((MantisRepository)MantisRepositoryEditor.this.myRepository).getProjects();
            if (list == null) {
                FetchMantisProjects.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Nullable
        public MantisProject getSelectedItem() {
            return ((MantisRepository)MantisRepositoryEditor.this.myRepository).getCurrentProject();
        }

        @Override
        protected void handleError() {
            super.handleError();
            MantisRepositoryEditor.this.myFilterCombobox.removeAllItems();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/mantis/MantisRepositoryEditor$FetchMantisProjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/mantis/MantisRepositoryEditor$FetchMantisProjects";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fetch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

