/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest.api20alpha1;

import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.rest.JiraRestTask;
import com.intellij.tasks.jira.rest.api20alpha1.model.JiraIssueApi20Alpha1;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.tasks.jira.rest.model.JiraResponseWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraRestApi20Alpha1
extends JiraRestApi {
    private static final Logger LOG = Logger.getInstance(JiraRestApi20Alpha1.class);
    private static final Type ISSUES_WRAPPER_TYPE = new TypeToken<JiraResponseWrapper.Issues<JiraIssueApi20Alpha1>>(){}.getType();

    public JiraRestApi20Alpha1(JiraRepository repository) {
        super(repository);
    }

    @Override
    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        if (task == null) {
            JiraRestApi20Alpha1.$$$reportNull$$$0(0);
        }
        HashSet<CustomTaskState> result = new HashSet<CustomTaskState>();
        result.add(new CustomTaskState("4", "In Progress"));
        result.add(new CustomTaskState("5", "Resolved (Fixed)"));
        result.add(new CustomTaskState("3", "Reopened"));
        HashSet<CustomTaskState> hashSet = result;
        if (hashSet == null) {
            JiraRestApi20Alpha1.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    protected JiraIssue parseIssue(String response) {
        return (JiraIssue)JiraRepository.GSON.fromJson(response, JiraIssueApi20Alpha1.class);
    }

    @Override
    @NotNull
    protected List<JiraIssue> parseIssues(String response) {
        JiraResponseWrapper.Issues wrapper = (JiraResponseWrapper.Issues)JiraRepository.GSON.fromJson(response, ISSUES_WRAPPER_TYPE);
        List incompleteIssues = wrapper.getIssues();
        ArrayList<JiraIssue> updatedIssues = new ArrayList<JiraIssue>();
        for (JiraIssueApi20Alpha1 issue : incompleteIssues) {
            try {
                JiraRestTask task = this.findTask(issue.getKey());
                if (task == null) continue;
                updatedIssues.add(task.getJiraIssue());
            }
            catch (Exception e) {
                LOG.warn("Can't fetch detailed info about issue: " + issue.getKey());
            }
        }
        ArrayList<JiraIssue> arrayList = updatedIssues;
        if (arrayList == null) {
            JiraRestApi20Alpha1.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected String getRequestForStateTransition(@NotNull CustomTaskState state) {
        if (state == null) {
            JiraRestApi20Alpha1.$$$reportNull$$$0(3);
        }
        try {
            switch (Integer.parseInt(state.getId())) {
                case 4: {
                    return "{\"transition\": \"4\"}";
                }
                case 5: {
                    return "{\"transition\": \"5\", \"resolution\": \"Fixed\"}";
                }
                case 3: {
                    return "{\"transition\": \"3\"}";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOG.error("Unknown ID of predefined issue state: " + state.getId());
        return null;
    }

    @Override
    public void updateTimeSpend(@NotNull LocalTask task, @NotNull String timeSpent, String comment) throws Exception {
        if (task == null) {
            JiraRestApi20Alpha1.$$$reportNull$$$0(4);
        }
        if (timeSpent == null) {
            JiraRestApi20Alpha1.$$$reportNull$$$0(5);
        }
        throw new Exception(TaskBundle.message((String)"jira.failure.no.time.spent", (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public JiraRemoteApi.ApiType getType() {
        JiraRemoteApi.ApiType apiType = JiraRemoteApi.ApiType.REST_2_0_ALPHA;
        if (apiType == null) {
            JiraRestApi20Alpha1.$$$reportNull$$$0(6);
        }
        return apiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/jira/rest/api20alpha1/JiraRestApi20Alpha1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/jira/rest/api20alpha1/JiraRestApi20Alpha1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIssues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRequestForStateTransition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpend";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }
}

