/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitlabRepositoryEditor
extends BaseRepositoryEditor<GitlabRepository> {
    private JBLabel myProjectLabel;
    private ComboBox<GitlabProject> myProjectComboBox;

    public GitlabRepositoryEditor(Project project, GitlabRepository repository, Consumer<? super GitlabRepository> changeListener) {
        super(project, repository, changeListener);
        this.myPasswordLabel.setText(TaskBundle.message((String)"label.token", (Object[])new Object[0]));
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
        this.installListener((JComboBox)this.myProjectComboBox);
        UIUtil.invokeLaterIfNeeded(() -> this.initialize());
    }

    private void initialize() {
        GitlabProject currentProject = ((GitlabRepository)this.myRepository).getCurrentProject();
        if (currentProject != null && ((GitlabRepository)this.myRepository).isConfigured()) {
            new FetchProjectsTask().queue();
        }
    }

    @Override
    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel(TaskBundle.message((String)"label.project", (Object[])new Object[0]), 4);
        this.myProjectComboBox = new ComboBox(300);
        this.myProjectComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)TaskBundle.message((String)"label.set.server.url.token.first", (Object[])new Object[0]), GitlabProject::getName));
        this.myProjectLabel.setLabelFor(this.myProjectComboBox);
        return new FormBuilder().addLabeledComponent((JComponent)this.myProjectLabel, this.myProjectComboBox).getPanel();
    }

    @Override
    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
    }

    @Override
    protected void afterTestConnection(boolean connectionSuccessful) {
        if (connectionSuccessful) {
            new FetchProjectsTask().queue();
        }
    }

    @Override
    public void apply() {
        super.apply();
        ((GitlabRepository)this.myRepository).setCurrentProject((GitlabProject)this.myProjectComboBox.getSelectedItem());
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
    }

    private final class FetchProjectsTask
    extends TaskUiUtil.ComboBoxUpdater<GitlabProject> {
        private FetchProjectsTask() {
            super(GitlabRepositoryEditor.this.myProject, TaskBundle.message((String)"progress.title.downloading.gitlab.projects", (Object[])new Object[0]), GitlabRepositoryEditor.this.myProjectComboBox);
        }

        @Override
        public GitlabProject getExtraItem() {
            return GitlabRepository.UNSPECIFIED_PROJECT;
        }

        @Override
        @Nullable
        public GitlabProject getSelectedItem() {
            return ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).getCurrentProject();
        }

        @Override
        @NotNull
        protected List<GitlabProject> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                FetchProjectsTask.$$$reportNull$$$0(0);
            }
            List<GitlabProject> list = ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).fetchProjects();
            if (list == null) {
                FetchProjectsTask.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/gitlab/GitlabRepositoryEditor$FetchProjectsTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/gitlab/GitlabRepositoryEditor$FetchProjectsTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fetch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

