/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class KotlinDefaultArgsBranchFilter
extends CoverageFilter {
    public static final String DEFAULT_ARGS_SUFFIX = "$default";
    private int myMaxMaskIndex = -1;
    private int myMinMaskIndex = -1;
    private boolean myIgnoreNextIf = false;
    private boolean myAndVisited = false;

    public boolean isApplicable(InstrumentationData context) {
        return KotlinDefaultArgsBranchFilter.isFilterApplicable(context);
    }

    public static boolean isFilterApplicable(InstrumentationData data) {
        InstrumentationData instrumentationData;
        return (data.getMethodAccess() & 0x1000) != 0 && KotlinUtils.isKotlinClass(data) && (data.getMethodName().endsWith(DEFAULT_ARGS_SUFFIX) || KotlinDefaultArgsBranchFilter.isConstructorWithDefaultArgs(data.getMethodName(), instrumentationData.getMethodDesc()));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isConstructorWithDefaultArgs(String name, String desc) {
        void var1_1;
        String string;
        return "<init>".equals(string) && desc != null && var1_1.endsWith("ILkotlin/jvm/internal/DefaultConstructorMarker;)V");
    }

    static int sourceParametersCount(int z) {
        int n;
        return z - 1 - (n - 1 + 32) / 33;
    }

    /*
     * WARNING - void declaration
     */
    public void visitCode() {
        void var1_1;
        super.visitCode();
        int[] range = KotlinDefaultArgsBranchFilter.getMaskIndexRange(this.myContext.getMethodName(), this.myContext.getMethodDesc());
        this.myMinMaskIndex = range[0];
        this.myMaxMaskIndex = var1_1[1];
    }

    /*
     * WARNING - void declaration
     */
    public static String getOriginalNameAndDesc(String name, String desc) {
        void var3_4;
        void var1_2;
        Type type = Type.getType(desc);
        Type[] parameters = type.getArgumentTypes();
        StringBuilder builder = new StringBuilder();
        if ("<init>".equals(name)) {
            builder.append(name);
        } else if (name.endsWith(DEFAULT_ARGS_SUFFIX)) {
            builder.append(name, 0, name.length() - 8);
        }
        int sourceCount = KotlinDefaultArgsBranchFilter.sourceParametersCount(parameters.length);
        builder.append('(');
        for (int i = 0; i < sourceCount; ++i) {
            builder.append(parameters[i].getDescriptor());
        }
        builder.append(')');
        builder.append(var1_2.getReturnType().getDescriptor());
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getMaskIndexRange(String name, String desc) {
        void var3_3;
        String string;
        Type[] parameters = Type.getType(desc).getArgumentTypes();
        int sourceCount = KotlinDefaultArgsBranchFilter.sourceParametersCount(parameters.length);
        int size = 0;
        int minIndex = -1;
        for (int i = 0; i < parameters.length - 2; ++i) {
            size += parameters[i].getSize();
            if (i != sourceCount - 1) continue;
            minIndex = size;
        }
        if ("<init>".equals(string)) {
            ++size;
        }
        return new int[]{++minIndex, var3_3};
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int var) {
        void var2_2;
        void var1_1;
        super.visitVarInsn((int)var1_1, var);
        this.myIgnoreNextIf = this.myMinMaskIndex <= var && var2_2 <= this.myMaxMaskIndex;
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        this.myAndVisited |= this.myIgnoreNextIf && var1_1 == 126;
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        void var2_2;
        super.visitJumpInsn(opcode, (Label)var2_2);
        if (var1_1 == 153 && this.myIgnoreNextIf) {
            if (this.myAndVisited) {
                this.myContext.removeLastJump();
            }
            this.myIgnoreNextIf = false;
            this.myAndVisited = false;
        }
    }
}

