/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ClassAwareSuiteMethod;
import com.intellij.junit4.IdeaSuite;
import com.intellij.junit4.IdeaSuite48;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.SuiteMethodBuilder;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public final class JUnit46ClassesRequestBuilder {
    private JUnit46ClassesRequestBuilder() {
    }

    public static Request getClassesRequest(String suiteName, Class<?>[] classes, Map<String, Set<String>> classMethods, Class<?> category) {
        boolean canUseSuiteMethod = JUnit46ClassesRequestBuilder.canUseSuiteMethod(classMethods);
        try {
            IdeaSuite suite;
            if (category != null) {
                try {
                    Class.forName("org.junit.experimental.categories.Categories");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Categories are not available");
                }
            }
            if (canUseSuiteMethod) {
                try {
                    Class.forName("org.junit.experimental.categories.Categories");
                    suite = new IdeaSuite48(JUnit46ClassesRequestBuilder.collectWrappedRunners(classes), suiteName, category);
                }
                catch (ClassNotFoundException e) {
                    suite = new IdeaSuite(JUnit46ClassesRequestBuilder.collectWrappedRunners(classes), suiteName);
                }
            } else {
                AllDefaultPossibilitiesBuilder builder = new AllDefaultPossibilitiesBuilder(canUseSuiteMethod);
                try {
                    Class.forName("org.junit.experimental.categories.Categories");
                    suite = new IdeaSuite48((RunnerBuilder)builder, classes, suiteName, category);
                }
                catch (ClassNotFoundException e) {
                    suite = new IdeaSuite((RunnerBuilder)builder, classes, suiteName);
                }
            }
            return Request.runner((Runner)suite);
        }
        catch (InitializationError e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Runner> collectWrappedRunners(Class<?>[] classes) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        ArrayList nonSuiteClasses = new ArrayList();
        SuiteMethodBuilder suiteMethodBuilder = new SuiteMethodBuilder();
        for (Class<?> aClass : classes) {
            if (suiteMethodBuilder.hasSuiteMethod(aClass)) {
                try {
                    runners.add((Runner)new ClassAwareSuiteMethod(aClass));
                }
                catch (Throwable throwable) {
                    runners.add((Runner)new ErrorReportingRunner(aClass, throwable));
                }
                continue;
            }
            nonSuiteClasses.add(aClass);
        }
        runners.addAll(new AllDefaultPossibilitiesBuilder(false).runners(null, nonSuiteClasses.toArray(new Class[0])));
        return runners;
    }

    private static boolean canUseSuiteMethod(Map<String, Set<String>> classMethods) {
        for (Set<String> methods : classMethods.values()) {
            if (methods == null) {
                return true;
            }
            for (String methodName : methods) {
                if (!"suite".equals(methodName)) continue;
                return true;
            }
        }
        return classMethods.isEmpty();
    }
}

