/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\"\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J,\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0007\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/MarkdownActionUtil;", "", "()V", "findMarkdownEditor", "Lcom/intellij/openapi/editor/Editor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findMarkdownPreviewEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor;", "findRequiredMarkdownEditor", "findSplitEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getCommonParentOfType", "Lcom/intellij/psi/PsiElement;", "left", "right", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getCommonParentOfTypes", "types", "Lcom/intellij/psi/tree/TokenSet;", "getCommonTopmostParentOfTypes", "getElementsUnderCaretOrSelection", "Lkotlin/Pair;", "file", "Lcom/intellij/psi/PsiFile;", "caret", "Lcom/intellij/openapi/editor/Caret;", "selectionStart", "", "selectionEnd", "intellij.markdown.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMarkdownActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownActionUtil.kt\norg/intellij/plugins/markdown/ui/actions/MarkdownActionUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class MarkdownActionUtil {
    @NotNull
    public static final MarkdownActionUtil INSTANCE = new MarkdownActionUtil();

    private MarkdownActionUtil() {
    }

    @JvmStatic
    @RequiresEdt
    @Nullable
    public static final MarkdownEditorWithPreview findSplitEditor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileEditor editor2 = (FileEditor)event.getData(PlatformCoreDataKeys.FILE_EDITOR);
        return MarkdownActionUtil.findSplitEditor(editor2);
    }

    @JvmStatic
    @RequiresEdt
    @Nullable
    public static final MarkdownEditorWithPreview findSplitEditor(@Nullable FileEditor editor2) {
        MarkdownEditorWithPreview markdownEditorWithPreview;
        if (editor2 instanceof MarkdownEditorWithPreview) {
            markdownEditorWithPreview = (MarkdownEditorWithPreview)editor2;
        } else {
            FileEditor fileEditor = editor2;
            markdownEditorWithPreview = fileEditor != null ? (MarkdownEditorWithPreview)((Object)fileEditor.getUserData(MarkdownEditorWithPreview.PARENT_SPLIT_EDITOR_KEY)) : null;
        }
        return markdownEditorWithPreview;
    }

    @JvmStatic
    @RequiresEdt
    @Nullable
    public static final MarkdownPreviewFileEditor findMarkdownPreviewEditor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownEditorWithPreview markdownEditorWithPreview = MarkdownActionUtil.findSplitEditor(event);
        if (markdownEditorWithPreview == null) {
            return null;
        }
        MarkdownEditorWithPreview splitEditor = markdownEditorWithPreview;
        FileEditor fileEditor = splitEditor.getPreviewEditor();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"getPreviewEditor(...)");
        FileEditor editor2 = fileEditor;
        return !(editor2 instanceof MarkdownPreviewFileEditor) || !editor2.getComponent().isVisible() ? null : (MarkdownPreviewFileEditor)editor2;
    }

    @JvmStatic
    @Nullable
    public static final Editor findMarkdownEditor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return MarkdownLanguageUtilsKt.isMarkdownLanguage(language) ? (Editor)event.getData(CommonDataKeys.EDITOR) : null;
    }

    @JvmStatic
    @NotNull
    public static final Editor findRequiredMarkdownEditor(@NotNull AnActionEvent event) {
        Editor editor2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor3 = editor2 = MarkdownActionUtil.findMarkdownEditor(event);
        if (editor3 == null) {
            boolean bl = false;
            String string = "Markdown editor was expected to be found in data context";
            throw new IllegalStateException(string.toString());
        }
        return editor3;
    }

    @JvmStatic
    @RequiresEdt
    @NotNull
    public static final Pair<PsiElement, PsiElement> getElementsUnderCaretOrSelection(@NotNull PsiFile file, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return MarkdownActionUtil.getElementsUnderCaretOrSelection(file, caret.getSelectionStart(), caret.getSelectionEnd());
    }

    @JvmStatic
    @NotNull
    public static final Pair<PsiElement, PsiElement> getElementsUnderCaretOrSelection(@NotNull PsiFile file, int selectionStart, int selectionEnd) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (selectionStart == selectionEnd) {
            PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)selectionStart);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
            PsiElement element2 = psiElement;
            return TuplesKt.to((Object)element2, (Object)element2);
        }
        PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)selectionStart);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement startElement = psiElement;
        PsiElement psiElement2 = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)selectionEnd);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElementAtOffset(...)");
        PsiElement endElement = psiElement2;
        return TuplesKt.to((Object)startElement, (Object)endElement);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonParentOfType(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        IElementType[] iElementTypeArray = new IElementType[]{elementType};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return MarkdownActionUtil.getCommonParentOfTypes(left, right, tokenSet);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonTopmostParentOfTypes(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull TokenSet types) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        PsiElement base = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        PsiElement psiElement2 = base;
        if (psiElement2 != null && (psiElement2 = PsiTreeUtilKt.parents((PsiElement)psiElement2, (boolean)true)) != null) {
            PsiElement psiElement3 = psiElement2;
            Object var5_5 = null;
            for (Object e : psiElement3) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!PsiUtilsKt.hasType(it, types)) continue;
                var5_5 = e;
            }
            psiElement = var5_5;
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonParentOfTypes(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull TokenSet types) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        PsiElement base = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        PsiElement psiElement2 = base;
        if (psiElement2 != null && (psiElement2 = PsiTreeUtilKt.parents((PsiElement)psiElement2, (boolean)true)) != null) {
            Object v1;
            block3: {
                PsiElement psiElement3 = psiElement2;
                for (Object e : psiElement3) {
                    PsiElement it = (PsiElement)e;
                    boolean bl = false;
                    if (!PsiUtilsKt.hasType(it, types)) continue;
                    v1 = e;
                    break block3;
                }
                v1 = null;
            }
            psiElement = v1;
        } else {
            psiElement = null;
        }
        return psiElement;
    }
}

