/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "", "range", "Lcom/intellij/openapi/util/TextRange;", "str", "", "(Lcom/intellij/openapi/util/TextRange;Ljava/lang/CharSequence;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getStr", "()Ljava/lang/CharSequence;", "apply", "", "document", "Lcom/intellij/openapi/editor/Document;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.markdown.core"})
public final class Replacement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextRange range;
    @NotNull
    private final CharSequence str;

    public Replacement(@NotNull TextRange range, @NotNull CharSequence str) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.range = range;
        this.str = str;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final CharSequence getStr() {
        return this.str;
    }

    public final void apply(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        document.replaceString(this.range.getStartOffset(), this.range.getEndOffset(), this.str);
    }

    @NotNull
    public final TextRange component1() {
        return this.range;
    }

    @NotNull
    public final CharSequence component2() {
        return this.str;
    }

    @NotNull
    public final Replacement copy(@NotNull TextRange range, @NotNull CharSequence str) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return new Replacement(range, str);
    }

    public static /* synthetic */ Replacement copy$default(Replacement replacement, TextRange textRange, CharSequence charSequence, int n, Object object) {
        if ((n & 1) != 0) {
            textRange = replacement.range;
        }
        if ((n & 2) != 0) {
            charSequence = replacement.str;
        }
        return replacement.copy(textRange, charSequence);
    }

    @NotNull
    public String toString() {
        return "Replacement(range=" + this.range + ", str=" + this.str + ")";
    }

    public int hashCode() {
        int result2 = this.range.hashCode();
        result2 = result2 * 31 + this.str.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Replacement)) {
            return false;
        }
        Replacement replacement = (Replacement)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)replacement.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.str, (Object)replacement.str);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001f\u0010\n\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/Replacement$Companion;", "", "()V", "replaceAllInBulk", "", "", "Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "document", "Lcom/intellij/openapi/editor/Document;", "replaceAllInBulk$intellij_markdown_core", "replaceSafelyIn", "replaceSafelyIn$intellij_markdown_core", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nReplacement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Replacement.kt\norg/intellij/plugins/markdown/editor/lists/Replacement$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,27:1\n1855#2,2:28\n*S KotlinDebug\n*F\n+ 1 Replacement.kt\norg/intellij/plugins/markdown/editor/lists/Replacement$Companion\n*L\n16#1:28,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void replaceSafelyIn$intellij_markdown_core(@NotNull List<Replacement> $this$replaceSafelyIn, @NotNull Document document) {
            Intrinsics.checkNotNullParameter($this$replaceSafelyIn, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Iterable $this$forEach$iv = CollectionsKt.asReversed($this$replaceSafelyIn);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Replacement it = (Replacement)element$iv;
                boolean bl = false;
                it.apply(document);
            }
        }

        public final void replaceAllInBulk$intellij_markdown_core(@NotNull List<Replacement> $this$replaceAllInBulk, @NotNull Document document) {
            Intrinsics.checkNotNullParameter($this$replaceAllInBulk, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            DocumentUtil.executeInBulk((Document)document, () -> Companion.replaceAllInBulk$lambda$1($this$replaceAllInBulk, document));
        }

        private static final void replaceAllInBulk$lambda$1(List $this_replaceAllInBulk, Document $document) {
            Intrinsics.checkNotNullParameter((Object)$this_replaceAllInBulk, (String)"$this_replaceAllInBulk");
            Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
            Companion.replaceSafelyIn$intellij_markdown_core($this_replaceAllInBulk, $document);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

