/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterOrder;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ui/TerminalBlockBackgroundRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "backgroundStart", "Ljava/awt/Color;", "backgroundEnd", "(Ljava/awt/Color;Ljava/awt/Color;)V", "getOrder", "Lcom/intellij/openapi/editor/markup/CustomHighlighterOrder;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.terminal"})
public final class TerminalBlockBackgroundRenderer
implements CustomHighlighterRenderer {
    @NotNull
    private final Color backgroundStart;
    @Nullable
    private final Color backgroundEnd;

    public TerminalBlockBackgroundRenderer(@NotNull Color backgroundStart, @Nullable Color backgroundEnd) {
        Intrinsics.checkNotNullParameter((Object)backgroundStart, (String)"backgroundStart");
        this.backgroundStart = backgroundStart;
        this.backgroundEnd = backgroundEnd;
    }

    public /* synthetic */ TerminalBlockBackgroundRenderer(Color color, Color color2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            color2 = null;
        }
        this(color, color2);
    }

    @NotNull
    public CustomHighlighterOrder getOrder() {
        return CustomHighlighterOrder.BEFORE_BACKGROUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        float width = (float)visibleArea.width - TerminalUiUtils.INSTANCE.toFloatAndScale(7);
        float topY = editor.offsetToXY((int)highlighter.getStartOffset()).y;
        float bottomY = (float)editor.offsetToXY((int)highlighter.getEndOffset()).y + (float)editor.getLineHeight();
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, topY, width, bottomY - topY);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            Paint paint = this.backgroundEnd != null ? (Paint)new GradientPaint(0.0f, topY, this.backgroundStart, width, topY, this.backgroundEnd) : (Paint)this.backgroundStart;
            g2d.setPaint(paint);
            g2d.fill(rect);
        }
        finally {
            g2d.dispose();
        }
    }
}

