/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.exp.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalInlineCompletion;
import org.jetbrains.plugins.terminal.exp.TerminalPromptController;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010#\u001a\u00020\u001dH\u0016J\u0015\u0010$\u001a\u00020\u001d2\u000b\u0010%\u001a\u00070&\u00a2\u0006\u0002\b'H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController$PromptStateListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;)V", "commandHistoryPresenter", "Lorg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;", "getController", "()Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "preferredFocusableComponent", "getPreferredFocusableComponent", "promptLabel", "Ljavax/swing/JLabel;", "commandHistoryStateChanged", "", "showing", "", "createPromptLabel", "createPromptTextField", "Lcom/intellij/ui/LanguageTextField;", "dispose", "promptLabelChanged", "newText", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.terminal"})
public final class TerminalPromptView
implements TerminalPromptController.PromptStateListener,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalPromptController controller;
    @NotNull
    private final JComponent component;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final JLabel promptLabel;
    @NotNull
    private final CommandHistoryPresenter commandHistoryPresenter;

    public TerminalPromptView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalSession session2, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.project = project;
        this.settings = settings;
        this.component = new JPanel();
        LanguageTextField editorTextField = this.createPromptTextField(session2);
        EditorEx editorEx = editorTextField.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        this.editor = (EditorImpl)editorEx;
        this.controller = new TerminalPromptController((EditorEx)this.editor, session2, commandExecutor);
        this.controller.addListener(this);
        this.promptLabel = this.createPromptLabel();
        String string = TerminalProjectOptionsProvider.Companion.getInstance(this.project).getStartingDirectory();
        if (string == null) {
            string = "";
        }
        this.promptLabel.setText(this.controller.computePromptText(string));
        this.commandHistoryPresenter = new CommandHistoryPresenter(this.project, (Editor)this.editor, commandExecutor);
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)11, (int)19, (int)12, (int)19);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder innerBorder = jBEmptyBorder;
        Border border = JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLineTop(...)");
        Border outerBorder = border;
        this.component.setBorder(JBUI.Borders.compound((Border)outerBorder, (Border)((Border)innerBorder)));
        this.component.setBackground(TerminalUi.INSTANCE.getTerminalBackground());
        this.component.setLayout((LayoutManager)ListLayout.Companion.vertical$default((ListLayout.Companion)ListLayout.Companion, (int)2, null, null, (int)6, null));
        this.component.add(this.promptLabel);
        this.component.add((Component)editorTextField);
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@Nullable MouseEvent e) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)editor.getContentComponent(), true);
            }
        });
    }

    @NotNull
    public final TerminalPromptController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    @Override
    public void promptLabelChanged(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, newText){
            final /* synthetic */ TerminalPromptView this$0;
            final /* synthetic */ String $newText;
            {
                this.this$0 = $receiver;
                this.$newText = $newText;
                super(0);
            }

            public final void invoke() {
                TerminalPromptView.access$getPromptLabel$p(this.this$0).setText(this.$newText);
            }
        }), (int)1, null);
    }

    @Override
    public void commandHistoryStateChanged(boolean showing) {
        if (showing) {
            List<String> history = this.controller.getCommandHistory();
            if (!((Collection)history).isEmpty()) {
                this.commandHistoryPresenter.showCommandHistory(history);
            }
        } else {
            this.commandHistoryPresenter.onCommandHistoryClosed();
        }
    }

    private final LanguageTextField createPromptTextField(TerminalSession session2) {
        EditorColorsScheme editorColorsScheme;
        Object object;
        ShellType shellType;
        ShellIntegration shellIntegration = session2.getShellIntegration();
        ShellType shellType2 = shellType = shellIntegration != null ? shellIntegration.getShellType() : null;
        if (shellType != null) {
            object = TerminalShellSupport.Companion.findByShellType(shellType);
            if (object == null || (object = object.getPromptLanguage()) == null) {
                object = (Language)PlainTextLanguage.INSTANCE;
            }
        } else {
            object = (Language)PlainTextLanguage.INSTANCE;
        }
        Language language = object;
        Project project = this.project;
        LanguageTextField textField2 = new LanguageTextField(language, project){

            public void setBackground(@Nullable Color bg) {
            }

            public void updateUI() {
                super.updateUI();
                this.setFont(EditorUtil.getEditorFont());
            }
        };
        textField2.setDisposedWith((Disposable)this);
        textField2.setAlignmentX(0.0f);
        EditorEx editorEx = textField2.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor = (EditorImpl)editorEx;
        editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor.getGutterComponentEx().setPaintBackground(false);
        editor.setBackgroundColor(TerminalUi.INSTANCE.getTerminalBackground());
        EditorColorsScheme $this$createPromptTextField_u24lambda_u240 = editorColorsScheme = editor.getColorsScheme();
        boolean bl = false;
        $this$createPromptTextField_u24lambda_u240.setEditorFontName(this.settings.getTerminalFont().getFontName());
        $this$createPromptTextField_u24lambda_u240.setEditorFontSize(this.settings.getTerminalFont().getSize());
        $this$createPromptTextField_u24lambda_u240.setLineSpacing(this.settings.getLineSpacing());
        editor.getCaretModel().getPrimaryCaret().setVisualAttributes(new CaretVisualAttributes(null, CaretVisualAttributes.Weight.HEAVY));
        editor.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)false);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)editor.getDocument());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            editor.setFile(it);
        }
        TerminalInlineCompletion.Companion.getInstance(this.project).install((EditorEx)editor);
        return textField2;
    }

    private final JLabel createPromptLabel() {
        JLabel label2 = new JLabel(){

            public void updateUI() {
                super.updateUI();
                this.setFont(EditorUtil.getEditorFont());
            }
        };
        label2.setForeground(TerminalUi.INSTANCE.getPromptForeground());
        label2.setAlignmentX(0.0f);
        return label2;
    }

    public void dispose() {
    }

    public static final /* synthetic */ JLabel access$getPromptLabel$p(TerminalPromptView $this) {
        return $this.promptLabel;
    }
}

