/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.core.Color;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.ErrorBlockDecorationState;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.TerminalBlocksDecorator;
import org.jetbrains.plugins.terminal.exp.TerminalCaretModel;
import org.jetbrains.plugins.terminal.exp.TerminalCaretPainter;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalEventDispatcherKt;
import org.jetbrains.plugins.terminal.exp.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.exp.TerminalUi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0002CDB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0010J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020#H\u0002J\u000e\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020#H\u0007J\b\u00106\u001a\u00020#H\u0002J\u0010\u00107\u001a\u00020#2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0010H\u0002J\u0012\u0010;\u001a\u00020#2\b\u0010<\u001a\u0004\u0018\u00010=H\u0007J\u0010\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020(H\u0002J\b\u0010@\u001a\u00020#H\u0002J\f\u0010A\u001a\u00020B*\u000204H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$TerminalListener;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "blocksDecorator", "Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator;", "caretModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;", "caretPainter", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter;", "keyEventsListenerDisposable", "Lcom/intellij/openapi/Disposable;", "mouseAndContentListenersDisposable", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "getOutputModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "palette", "Lcom/intellij/terminal/TerminalColorPalette;", "getPalette", "()Lcom/intellij/terminal/TerminalColorPalette;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "getSelectionModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "terminalModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "textHighlighter", "Lorg/jetbrains/plugins/terminal/exp/TerminalTextHighlighter;", "addDocumentListener", "", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "disposable", "computeCommandOutput", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$CommandOutput;", "createCommandHighlighting", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "block", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "disposeRunningCommandListeners", "finishCommandBlock", "exitCode", "", "getStyleForeground", "Ljava/awt/Color;", "style", "Lcom/jediterm/terminal/TextStyle;", "insertEmptyLine", "installRunningCommandListeners", "onAlternateBufferChanged", "enabled", "", "setupContentListener", "startCommandBlock", "command", "", "updateEditor", "output", "updateEditorContent", "toTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "CommandOutput", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n*L\n1#1,301:1\n1#2:302\n160#3,7:303\n*S KotlinDebug\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputController\n*L\n135#1:303,7\n*E\n"})
public final class TerminalOutputController
implements TerminalModel.TerminalListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final TerminalModel terminalModel;
    @NotNull
    private final TerminalBlocksDecorator blocksDecorator;
    @NotNull
    private final TerminalTextHighlighter textHighlighter;
    @NotNull
    private final TerminalCaretModel caretModel;
    @NotNull
    private final TerminalCaretPainter caretPainter;
    @Nullable
    private volatile Disposable keyEventsListenerDisposable;
    @Nullable
    private volatile Disposable mouseAndContentListenersDisposable;
    @NotNull
    private static final DataKey<TerminalOutputController> KEY;

    public TerminalOutputController(@NotNull EditorEx editor, @NotNull TerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.editor = editor;
        this.session = session2;
        this.settings = settings;
        this.outputModel = new TerminalOutputModel(this.editor);
        this.selectionModel = new TerminalSelectionModel(this.outputModel);
        this.terminalModel = this.session.getModel();
        this.blocksDecorator = new TerminalBlocksDecorator(this.outputModel, this.editor);
        this.textHighlighter = new TerminalTextHighlighter(this.outputModel);
        this.caretModel = new TerminalCaretModel(this.session, this.outputModel, this.editor);
        this.caretPainter = new TerminalCaretPainter(this.caretModel, this.outputModel, this.selectionModel, this.editor);
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_OUTPUT_EDITOR_KEY(), (Object)true);
        this.editor.setHighlighter((EditorHighlighter)this.textHighlighter);
        TerminalModel.addTerminalListener$default(this.session.getModel(), this, null, 2, null);
        Disposer.register((Disposable)this.session, (Disposable)this.caretModel);
    }

    @NotNull
    public final TerminalOutputModel getOutputModel() {
        return this.outputModel;
    }

    @NotNull
    public final TerminalSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private final TerminalColorPalette getPalette() {
        TerminalColorPalette terminalColorPalette = this.settings.getTerminalColorPalette();
        Intrinsics.checkNotNullExpressionValue((Object)terminalColorPalette, (String)"getTerminalColorPalette(...)");
        return terminalColorPalette;
    }

    @RequiresEdt
    public final void startCommandBlock(@Nullable String command) {
        CommandBlock block = this.outputModel.createBlock(command);
        CharSequence charSequence = command;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.editor.getDocument().insertString(block.getEndOffset(), (CharSequence)(command + "\n"));
            HighlightingInfo highlighting = this.createCommandHighlighting(block);
            this.outputModel.putHighlightings(block, CollectionsKt.listOf((Object)highlighting));
            this.blocksDecorator.installDecoration(block, this.outputModel.getBlocksSize() == 1);
        }
        this.installRunningCommandListeners();
    }

    private final void installRunningCommandListeners() {
        Disposable keyEventsDisposable;
        Disposable disposable;
        Disposable mouseAndContentDisposable;
        Disposable disposable2;
        Disposable it = disposable2 = Disposer.newDisposable();
        boolean bl = false;
        Disposer.register((Disposable)this.session, (Disposable)it);
        Disposable disposable3 = disposable2;
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"also(...)");
        this.mouseAndContentListenersDisposable = mouseAndContentDisposable = disposable3;
        Disposable it2 = disposable = Disposer.newDisposable();
        boolean bl2 = false;
        Disposer.register((Disposable)this.session, (Disposable)it2);
        Disposable disposable4 = disposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable4, (String)"also(...)");
        this.keyEventsListenerDisposable = keyEventsDisposable = disposable4;
        TerminalEventsHandler eventsHandler = new TerminalEventsHandler(this.session, this.settings);
        TerminalEventDispatcherKt.setupKeyEventDispatcher(this.editor, this.settings, eventsHandler, this.outputModel, this.selectionModel, keyEventsDisposable);
        TerminalEventDispatcherKt.setupMouseListener(this.editor, this.settings, this.session.getModel(), eventsHandler, mouseAndContentDisposable);
        this.setupContentListener(mouseAndContentDisposable);
    }

    private final void disposeRunningCommandListeners() {
        Disposable disposable = this.mouseAndContentListenersDisposable;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.mouseAndContentListenersDisposable = null;
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalOutputController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Disposable disposable = TerminalOutputController.access$getKeyEventsListenerDisposable$p(this.this$0);
                if (disposable != null) {
                    Disposable it = disposable;
                    boolean bl = false;
                    Disposer.dispose((Disposable)it);
                }
                TerminalOutputController.access$setKeyEventsListenerDisposable$p(this.this$0, null);
            }
        }), (int)1, null);
    }

    public final void finishCommandBlock(int exitCode) {
        this.disposeRunningCommandListeners();
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, exitCode){
            final /* synthetic */ TerminalOutputController this$0;
            final /* synthetic */ int $exitCode;
            {
                this.this$0 = $receiver;
                this.$exitCode = $exitCode;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                CommandBlock commandBlock = this.this$0.getOutputModel().getLastBlock();
                if (commandBlock == null) {
                    throw new IllegalStateException("No active block".toString());
                }
                CommandBlock block = commandBlock;
                DocumentEx documentEx = TerminalOutputController.access$getEditor$p(this.this$0).getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                DocumentEx document = documentEx;
                int lastLineInd = document.getLineNumber(block.getEndOffset());
                int lastLineStart = document.getLineStartOffset(lastLineInd);
                String string = document.getText(new TextRange(lastLineStart, block.getEndOffset()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String lastLineText = string;
                if (StringsKt.isBlank((CharSequence)lastLineText)) {
                    int removeOffset = lastLineStart - (lastLineStart > 0 ? 1 : 0);
                    document.deleteString(removeOffset, block.getEndOffset());
                    List<HighlightingInfo> list = this.this$0.getOutputModel().getHighlightings(block);
                    if (list != null) {
                        void $this$filterTo$iv$iv;
                        List<HighlightingInfo> list2 = list;
                        TerminalOutputController terminalOutputController = this.this$0;
                        List<HighlightingInfo> current = list2;
                        boolean bl = false;
                        Iterable $this$filter$iv = current;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            HighlightingInfo it = (HighlightingInfo)element$iv$iv;
                            boolean bl2 = false;
                            if (!(it.getEndOffset() <= block.getEndOffset())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List updated = (List)destination$iv$iv;
                        terminalOutputController.getOutputModel().putHighlightings(block, updated);
                    }
                }
                String string2 = document.getText(block.getTextRange());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string2)) {
                    this.this$0.getOutputModel().removeBlock(block);
                } else if (this.$exitCode != 0) {
                    this.this$0.getOutputModel().addBlockState(block, new ErrorBlockDecorationState());
                }
            }
        }), (int)1, null);
    }

    @RequiresEdt
    public final void insertEmptyLine() {
        this.outputModel.closeLastBlock();
        this.editor.getDocument().insertString(this.editor.getDocument().getTextLength(), (CharSequence)"\n");
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        this.editor.getScrollingModel().scrollVertically(this.editor.getContentComponent().getHeight() - visibleArea.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAlternateBufferChanged(boolean enabled) {
        if (enabled) {
            this.disposeRunningCommandListeners();
        } else {
            this.installRunningCommandListeners();
            TerminalModel this_$iv = this.terminalModel;
            boolean $i$f$withContentLock = false;
            this_$iv.lockContent();
            try {
                boolean bl = false;
                this.updateEditorContent();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.unlockContent();
            }
        }
    }

    private final void setupContentListener(Disposable disposable) {
        this.terminalModel.addContentListener(new TerminalModel.ContentListener(this){
            final /* synthetic */ TerminalOutputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onContentChanged() {
                TerminalOutputController.access$updateEditorContent(this.this$0);
            }
        }, disposable);
    }

    private final void updateEditorContent() {
        CommandOutput output = this.computeCommandOutput();
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, output){
            final /* synthetic */ TerminalOutputController this$0;
            final /* synthetic */ CommandOutput $output;
            {
                this.this$0 = $receiver;
                this.$output = $output;
                super(0);
            }

            public final void invoke() {
                if (!TerminalOutputController.access$getEditor$p(this.this$0).isDisposed()) {
                    TerminalOutputController.access$updateEditor(this.this$0, this.$output);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final CommandOutput computeCommandOutput() {
        int n;
        CommandBlock commandBlock = this.outputModel.getLastBlock();
        Intrinsics.checkNotNull((Object)commandBlock);
        CommandBlock block = commandBlock;
        int baseOffset = block.getOutputStartOffset();
        StringBuilder builder = new StringBuilder();
        List highlightings = new ArrayList();
        StyledTextConsumer consumer2 = new StyledTextConsumer(baseOffset, builder, this, highlightings){
            final /* synthetic */ int $baseOffset;
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ TerminalOutputController this$0;
            final /* synthetic */ List<HighlightingInfo> $highlightings;
            {
                this.$baseOffset = $baseOffset;
                this.$builder = $builder;
                this.this$0 = $receiver;
                this.$highlightings = $highlightings;
            }

            public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$baseOffset + this.$builder.length();
                this.$builder.append(characters.toString());
                TextAttributes attributes = TerminalOutputController.access$toTextAttributes(this.this$0, style);
                this.$highlightings.add(new HighlightingInfo(startOffset, this.$baseOffset + this.$builder.length(), attributes));
            }

            public void consumeNul(int x, int y, int nulIndex, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$baseOffset + this.$builder.length();
                int n = characters.getBuf().length;
                StringBuilder stringBuilder = this.$builder;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    stringBuilder.append(' ');
                }
                int n3 = this.$baseOffset + this.$builder.length();
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(startOffset, n3, TerminalOutputController.access$toTextAttributes(this.this$0, textStyle)));
            }

            public void consumeQueue(int x, int y, int nulIndex, int startRow) {
                int startOffset = this.$baseOffset + this.$builder.length();
                this.$builder.append("\n");
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(startOffset, startOffset + 1, TerminalOutputController.access$toTextAttributes(this.this$0, textStyle)));
            }
        };
        String string = block.getCommand();
        if (string != null) {
            String command = string;
            boolean bl = false;
            Object object = new String[]{"\n"};
            object = StringsKt.split$default((CharSequence)command, (String[])object, (boolean)false, (int)0, (int)6, null);
            int n2 = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t = iterator.next();
                String string2 = (String)t;
                int n3 = n2;
                boolean bl2 = false;
                int n4 = it.length() / this.terminalModel.getWidth() + (it.length() % this.terminalModel.getWidth() > 0 ? 1 : 0);
                n2 = n3 + n4;
            }
            n = n2;
        } else {
            n = 0;
        }
        int commandLines = n;
        int historyLines = this.terminalModel.getHistoryLinesCount();
        if (this.terminalModel.getHistoryLinesCount() > 0) {
            if (commandLines <= historyLines) {
                this.terminalModel.processHistoryAndScreenLines(commandLines - historyLines, historyLines - commandLines, consumer2);
                this.terminalModel.processScreenLines(0, this.terminalModel.getCursorY(), consumer2);
            } else {
                this.terminalModel.processHistoryAndScreenLines(-historyLines, historyLines, consumer2);
                this.terminalModel.processScreenLines(commandLines - historyLines, this.terminalModel.getCursorY(), consumer2);
            }
        } else {
            this.terminalModel.processScreenLines(commandLines, this.terminalModel.getCursorY() - commandLines, consumer2);
        }
        while (true) {
            Character c = StringsKt.lastOrNull((CharSequence)builder);
            char c2 = '\n';
            if (c == null || c.charValue() != c2) break;
            builder.deleteCharAt(StringsKt.getLastIndex((CharSequence)builder));
            CollectionsKt.removeLast((List)highlightings);
        }
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return new CommandOutput(string3, highlightings);
    }

    private final void updateEditor(CommandOutput output) {
        List list;
        CommandBlock commandBlock = this.outputModel.getLastBlock();
        if (commandBlock == null) {
            throw new IllegalStateException("No active block".toString());
        }
        CommandBlock block = commandBlock;
        this.editor.getDocument().replaceString(block.getOutputStartOffset(), block.getEndOffset(), (CharSequence)output.getText());
        String command = block.getCommand();
        if (command != null) {
            List list2;
            HighlightingInfo commandHighlighting = this.createCommandHighlighting(block);
            List it = list2 = CollectionsKt.toMutableList((Collection)output.getHighlightings());
            boolean bl = false;
            it.add(0, commandHighlighting);
            list = list2;
        } else {
            list = output.getHighlightings();
        }
        List highlightings = list;
        this.outputModel.putHighlightings(block, highlightings);
        if (this.outputModel.getDecoration(block) == null && !StringsKt.isBlank((CharSequence)output.getText()) && !Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output.getText())).toString(), (Object)"%")) {
            this.blocksDecorator.installDecoration(block, this.outputModel.getBlocksSize() == 1);
        }
        this.editor.getCaretModel().moveToOffset(block.getEndOffset());
        this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
        this.caretPainter.repaint();
    }

    private final TextAttributes toTextAttributes(TextStyle $this$toTextAttributes) {
        TextAttributes textAttributes;
        TextAttributes attr = textAttributes = new TextAttributes();
        boolean bl = false;
        Color color = this.getPalette().getBackground(this.terminalModel.getStyleState().getBackground($this$toTextAttributes.getBackgroundForRun()));
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        Color background = color;
        Color defaultBackground = this.getPalette().getDefaultBackground();
        if (!Intrinsics.areEqual((Object)background, (Object)defaultBackground)) {
            attr.setBackgroundColor(AwtTransformers.toAwtColor((Color)background));
        }
        attr.setForegroundColor(this.getStyleForeground($this$toTextAttributes));
        if ($this$toTextAttributes.hasOption(TextStyle.Option.BOLD)) {
            attr.setFontType(attr.getFontType() | 1);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.ITALIC)) {
            attr.setFontType(attr.getFontType() | 2);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.UNDERLINED)) {
            attr.withAdditionalEffect(EffectType.LINE_UNDERSCORE, attr.getForegroundColor());
        }
        return textAttributes;
    }

    private final java.awt.Color getStyleForeground(TextStyle style) {
        java.awt.Color color;
        Color color2 = this.getPalette().getForeground(this.terminalModel.getStyleState().getForeground(style.getForegroundForRun()));
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getForeground(...)");
        Color foreground = color2;
        if (style.hasOption(TextStyle.Option.DIM)) {
            Color color3 = this.getPalette().getBackground(this.terminalModel.getStyleState().getBackground(style.getBackgroundForRun()));
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getBackground(...)");
            Color background = color3;
            color = new java.awt.Color((foreground.getRed() + background.getRed()) / 2, (foreground.getGreen() + background.getGreen()) / 2, (foreground.getBlue() + background.getBlue()) / 2, foreground.getAlpha());
        } else {
            java.awt.Color color4 = AwtTransformers.toAwtColor((Color)foreground);
            color = color4;
            Intrinsics.checkNotNull((Object)color4);
        }
        return color;
    }

    private final HighlightingInfo createCommandHighlighting(CommandBlock block) {
        TextAttributes attributes = new TextAttributes(TerminalUi.INSTANCE.getCommandForeground(), null, null, null, 1);
        int n = block.getStartOffset();
        int n2 = block.getStartOffset();
        String string = block.getCommand();
        Intrinsics.checkNotNull((Object)string);
        return new HighlightingInfo(n, n2 + string.length(), attributes);
    }

    public final void addDocumentListener(@NotNull DocumentListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (disposable != null) {
            this.editor.getDocument().addDocumentListener(listener, disposable);
        } else {
            this.editor.getDocument().addDocumentListener(listener);
        }
    }

    public static /* synthetic */ void addDocumentListener$default(TerminalOutputController terminalOutputController, DocumentListener documentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputController.addDocumentListener(documentListener, disposable);
    }

    public static final /* synthetic */ Disposable access$getKeyEventsListenerDisposable$p(TerminalOutputController $this) {
        return $this.keyEventsListenerDisposable;
    }

    public static final /* synthetic */ void access$setKeyEventsListenerDisposable$p(TerminalOutputController $this, Disposable disposable) {
        $this.keyEventsListenerDisposable = disposable;
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(TerminalOutputController $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$updateEditorContent(TerminalOutputController $this) {
        $this.updateEditorContent();
    }

    public static final /* synthetic */ void access$updateEditor(TerminalOutputController $this, CommandOutput output) {
        $this.updateEditor(output);
    }

    public static final /* synthetic */ TextAttributes access$toTextAttributes(TerminalOutputController $this, TextStyle $receiver) {
        return $this.toTextAttributes($receiver);
    }

    static {
        DataKey dataKey = DataKey.create((String)"TerminalOutputController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$CommandOutput;", "", "text", "", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Ljava/lang/String;Ljava/util/List;)V", "getHighlightings", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class CommandOutput {
        @NotNull
        private final String text;
        @NotNull
        private final List<HighlightingInfo> highlightings;

        public CommandOutput(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            this.text = text;
            this.highlightings = highlightings;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> getHighlightings() {
            return this.highlightings;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> component2() {
            return this.highlightings;
        }

        @NotNull
        public final CommandOutput copy(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            return new CommandOutput(text, highlightings);
        }

        public static /* synthetic */ CommandOutput copy$default(CommandOutput commandOutput, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = commandOutput.text;
            }
            if ((n & 2) != 0) {
                list = commandOutput.highlightings;
            }
            return commandOutput.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "CommandOutput(text=" + this.text + ", highlightings=" + this.highlightings + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + ((Object)this.highlightings).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandOutput)) {
                return false;
            }
            CommandOutput commandOutput = (CommandOutput)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)commandOutput.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.highlightings, commandOutput.highlightings);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalOutputController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

