/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.find.editorHeaderActions.Embeddable;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.impl.livePreview.LivePreview;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.LivePreviewPresentation;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Point;
import java.util.Comparator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalIcons;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.exp.TerminalUi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0012\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00046789B=\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u001e\u001a\t\u0018\u00010\u001f\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020\u0014H\u0002J\b\u0010$\u001a\u00020\u0011H\u0016J\b\u0010%\u001a\u00020\u0011H\u0002J\b\u0010&\u001a\u00020\u0014H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u001fH\u0016J\r\u0010*\u001a\u00070\u001f\u00a2\u0006\u0002\b H\u0002J\b\u0010+\u001a\u00020\nH\u0016J\b\u0010,\u001a\u00020\u0019H\u0016J\b\u0010-\u001a\u00020\u0011H\u0016J\b\u0010.\u001a\u00020\u0011H\u0016J\b\u0010/\u001a\u00020\u0011H\u0016J\u0010\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u001dH\u0016J\b\u00102\u001a\u00020\u0011H\u0002J\b\u00103\u001a\u00020\u0011H\u0002J\b\u00104\u001a\u00020\u0011H\u0002J\b\u00105\u001a\u00020\u0011H\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchResultsListener;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "model", "Lcom/intellij/find/FindModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "closeCallback", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/find/FindModel;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;Lkotlin/jvm/functions/Function0;)V", "component", "Lcom/intellij/find/SearchReplaceComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "isSearchInBlock", "", "livePreviewController", "Lcom/intellij/find/impl/livePreview/LivePreviewController;", "searchResults", "Lcom/intellij/find/impl/livePreview/SearchResults;", "checkRegex", "", "Lorg/jetbrains/annotations/Nls;", "text", "close", "createSearchComponent", "cursorMoved", "findModelChanged", "getComponent", "getData", "", "dataId", "getEmptyText", "getFindModel", "hasMatches", "searchBackward", "searchFieldDocumentChanged", "searchForward", "searchResultsUpdated", "sr", "updateEmptyText", "updateMultiLineStateIfNeeded", "updateResults", "updateUiWithFindModel", "Companion", "SearchInBlockAction", "TerminalSearchPresentation", "TerminalSearchResults", "intellij.terminal"})
public final class BlockTerminalSearchSession
implements SearchSession,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener,
DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final FindModel model;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final Function0<Unit> closeCallback;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final SearchReplaceComponent component;
    @NotNull
    private final SearchResults searchResults;
    @NotNull
    private final LivePreviewController livePreviewController;
    private boolean isSearchInBlock;
    @NotNull
    private static final Key<Boolean> SEARCH_IN_BLOCK_KEY;

    public BlockTerminalSearchSession(@NotNull Project project, @NotNull EditorEx editor, @NotNull FindModel model, @NotNull TerminalOutputModel outputModel, @NotNull TerminalSelectionModel selectionModel, @NotNull Function0<Unit> closeCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter(closeCallback, (String)"closeCallback");
        this.project = project;
        this.editor = editor;
        this.model = model;
        this.outputModel = outputModel;
        this.selectionModel = selectionModel;
        this.closeCallback = closeCallback;
        Disposable disposable = Disposer.newDisposable((String)BlockTerminalSearchSession.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.component = this.createSearchComponent();
        this.searchResults = new TerminalSearchResults();
        this.livePreviewController = new LivePreviewController(this.searchResults, (SearchSession)this, this.disposable);
        this.isSearchInBlock = Companion.isSearchInBlock(this.model);
        this.searchResults.setMatchesLimit(10000);
        this.livePreviewController.on();
        this.livePreviewController.setLivePreview(new LivePreview(this.searchResults, (LivePreviewPresentation)new TerminalSearchPresentation()));
        this.component.addListener((SearchReplaceComponent.Listener)this);
        this.searchResults.addListener((SearchResults.SearchResultsListener)this);
        this.model.addObserver(new FindModel.FindModelObserver(){
            private boolean preventRecursion;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void findModelChanged(@Nullable FindModel findModel) {
                if (!this.preventRecursion) {
                    try {
                        this.preventRecursion = true;
                        this.findModelChanged();
                    }
                    finally {
                        this.preventRecursion = false;
                    }
                }
            }
        });
        this.selectionModel.addListener(new TerminalSelectionModel.TerminalSelectionListener(){

            @Override
            public void selectionChanged(@NotNull List<CommandBlock> oldSelection, @NotNull List<CommandBlock> newSelection) {
                Intrinsics.checkNotNullParameter(oldSelection, (String)"oldSelection");
                Intrinsics.checkNotNullParameter(newSelection, (String)"newSelection");
                if (newSelection.isEmpty()) {
                    Companion.setSearchInBlock(model, false);
                }
                if (Companion.isSearchInBlock(model)) {
                    searchResults.clear();
                    this.updateResults();
                }
            }
        }, this.disposable);
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getEditor() == editor) {
                    Disposer.dispose((Disposable)disposable);
                    livePreviewController.dispose();
                }
            }
        }, this.disposable);
        Object[] objectArray = new Object[]{0, 0};
        this.component.setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
        this.updateUiWithFindModel();
        this.updateMultiLineStateIfNeeded();
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                component.updateActions();
            }
        }), (int)1, null);
    }

    public /* synthetic */ BlockTerminalSearchSession(Project project, EditorEx editorEx, FindModel findModel, TerminalOutputModel terminalOutputModel, TerminalSelectionModel terminalSelectionModel, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function0 = 1.INSTANCE;
        }
        this(project, editorEx, findModel, terminalOutputModel, terminalSelectionModel, (Function0<Unit>)function0);
    }

    private final SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent;
        AnAction[] anActionArray = new AnAction[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction()};
        SearchReplaceComponent.Builder builder = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)this.editor.getContentComponent()).addPrimarySearchActions(anActionArray);
        anActionArray = new AnAction[]{new SearchInBlockAction(), new ToggleMatchCase(), new ToggleRegex()};
        SearchReplaceComponent searchReplaceComponent2 = builder.addExtraSearchActions(anActionArray).withNewLineButton(false).withDataProvider((DataProvider)this).withCloseAction(this::close).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent2, (String)"build(...)");
        SearchReplaceComponent it = searchReplaceComponent = searchReplaceComponent2;
        boolean bl = false;
        JTextComponent jTextComponent = it.getSearchTextComponent();
        JTextArea jTextArea = jTextComponent instanceof JTextArea ? (JTextArea)jTextComponent : null;
        if (jTextArea != null) {
            jTextArea.setColumns(14);
        }
        UiSizeUtilKt.setPreferredWidth((JComponent)((JComponent)it), (int)JBUI.scale((int)500));
        UiSizeUtilKt.setMaximumWidth((JComponent)((JComponent)it), (int)JBUI.scale((int)500));
        it.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)0, (int)1, (int)1, (int)0));
        return searchReplaceComponent;
    }

    private final void findModelChanged() {
        FindModel findModel;
        if (Companion.isSearchInBlock(this.model) != this.isSearchInBlock) {
            this.isSearchInBlock = Companion.isSearchInBlock(this.model);
            if (this.isSearchInBlock && this.selectionModel.getPrimarySelection() == null) {
                FindResult findResult = this.searchResults.getCursor();
                int offset = findResult != null ? findResult.getStartOffset() : this.editor.getCaretModel().getOffset();
                CommandBlock commandBlock = this.outputModel.getByOffset(offset);
                if (commandBlock != null) {
                    CommandBlock block = commandBlock;
                    boolean bl = false;
                    this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
                }
            }
        }
        this.updateUiWithFindModel();
        this.searchResults.clear();
        this.updateResults();
        FindModel $this$findModelChanged_u24lambda_u242 = findModel = FindManager.getInstance((Project)this.project).getFindInFileModel();
        boolean bl = false;
        $this$findModelChanged_u24lambda_u242.setStringToFind(this.model.getStringToFind());
        $this$findModelChanged_u24lambda_u242.setCaseSensitive(this.model.isCaseSensitive());
        $this$findModelChanged_u24lambda_u242.setRegularExpressions(this.model.isRegularExpressions());
    }

    public void searchFieldDocumentChanged() {
        if (this.editor.isDisposed()) {
            return;
        }
        this.model.setStringToFind(this.component.getSearchTextComponent().getText());
        this.updateResults();
        this.updateMultiLineStateIfNeeded();
    }

    public void searchResultsUpdated(@NotNull SearchResults sr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sr, (String)"sr");
        if (sr.getFindModel() == null) {
            return;
        }
        int matchesCount = sr.getMatchesCount();
        int cursorIndex = sr.getCursorVisualIndex();
        if (matchesCount > this.searchResults.getMatchesLimit()) {
            var6_4 = new Object[]{this.searchResults.getMatchesLimit()};
            string = ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])var6_4);
        } else if (cursorIndex != -1) {
            var6_4 = new Object[]{cursorIndex, matchesCount};
            string = ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])var6_4);
        } else {
            var6_4 = new Object[]{0, matchesCount};
            string = ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])var6_4);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String status = string2;
        this.component.setStatusText(status);
        this.component.updateActions();
    }

    public void cursorMoved() {
        this.component.updateActions();
    }

    private final void updateResults() {
        String string = this.model.getStringToFind();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringToFind(...)");
        String text = string;
        if (((CharSequence)text).length() > 0) {
            String string2;
            if (this.model.isRegularExpressions() && (string2 = this.checkRegex(text)) != null) {
                String warning = string2;
                boolean bl = false;
                this.searchResults.clear();
                this.component.setStatusText(warning);
                return;
            }
            this.livePreviewController.updateInBackground(this.model, true);
        } else {
            Object[] objectArray = new Object[]{0, 0};
            this.component.setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
            this.searchResults.clear();
        }
    }

    private final void updateMultiLineStateIfNeeded() {
        String string = this.component.getSearchTextComponent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.model.setMultiline(StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null));
    }

    private final void updateUiWithFindModel() {
        this.component.update(this.model.getStringToFind(), this.model.getStringToReplace(), this.model.isReplaceState(), this.model.isMultiline());
        this.updateEmptyText();
    }

    private final void updateEmptyText() {
        JTextComponent jTextComponent = this.component.getSearchTextComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
        JTextComponent searchComponent = jTextComponent;
        if (searchComponent instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)searchComponent).getEmptyText().setText(this.getEmptyText());
        }
    }

    private final String getEmptyText() {
        if (Companion.isSearchInBlock(this.model)) {
            String string = TerminalBundle.message("search.in.block", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return StringsKt.replace$default((String)string, (String)"\u001b", (String)"", (boolean)false, (int)4, null);
        }
        List options = (List)new SmartList();
        if (this.model.isCaseSensitive()) {
            String string = BlockTerminalSearchSession.getEmptyText$getOptionText("find.case.sensitive");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmptyText$getOptionText(...)");
            options.add(string);
        }
        if (this.model.isRegularExpressions()) {
            String string = BlockTerminalSearchSession.getEmptyText$getOptionText("find.regex");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmptyText$getOptionText(...)");
            options.add(string);
        }
        String string = switch (options.size()) {
            case 0 -> ApplicationBundle.message((String)"editorsearch.search.hint", (Object[])new Object[0]);
            case 1 -> {
                Object[] var4_2 = new Object[]{options.get(0)};
                yield FindBundle.message((String)"emptyText.used.option", (Object[])var4_2);
            }
            default -> {
                Object[] var4_2 = new Object[]{options.get(0), options.get(1)};
                yield FindBundle.message((String)"emptyText.used.options", (Object[])var4_2);
            }
        };
        Intrinsics.checkNotNull((Object)string);
        String text = string;
        String string2 = StringUtil.capitalize((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
        return string2;
    }

    private final String checkRegex(String text) {
        try {
            new Regex(text);
        }
        catch (PatternSyntaxException e) {
            return FindBundle.message((String)"find.incorrect.regexp", (Object[])new Object[0]);
        }
        CharSequence charSequence = text;
        return new Regex("\\|+").matches(charSequence) ? ApplicationBundle.message((String)"editorsearch.empty.string.matches", (Object[])new Object[0]) : null;
    }

    @NotNull
    public FindModel getFindModel() {
        return this.model;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.component;
    }

    public boolean hasMatches() {
        return this.searchResults.hasMatches();
    }

    public void searchForward() {
        this.livePreviewController.moveCursor(SearchResults.Direction.DOWN);
    }

    public void searchBackward() {
        this.livePreviewController.moveCursor(SearchResults.Direction.UP);
    }

    public void close() {
        Disposer.dispose((Disposable)this.disposable);
        this.livePreviewController.dispose();
        this.closeCallback.invoke();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return SearchSession.KEY.is(dataId) ? this : null;
    }

    private static final String getEmptyText$getOptionText(String key) {
        String string = FindBundle.message((String)key, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return StringUtil.toLowerCase((String)StringsKt.replace$default((String)string, (String)"\u001b", (String)"", (boolean)false, (int)4, null));
    }

    static {
        Key key = Key.create((String)"SearchInBlock");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SEARCH_IN_BLOCK_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession$Companion;", "", "()V", "SEARCH_IN_BLOCK_KEY", "Lcom/intellij/openapi/util/Key;", "", "value", "isSearchInBlock", "Lcom/intellij/find/FindModel;", "(Lcom/intellij/find/FindModel;)Z", "setSearchInBlock", "(Lcom/intellij/find/FindModel;Z)V", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSearchInBlock(@NotNull FindModel $this$isSearchInBlock) {
            Intrinsics.checkNotNullParameter((Object)$this$isSearchInBlock, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isSearchInBlock.getCopyableUserData(SEARCH_IN_BLOCK_KEY), (Object)true);
        }

        public final void setSearchInBlock(@NotNull FindModel $this$isSearchInBlock, boolean value) {
            Intrinsics.checkNotNullParameter((Object)$this$isSearchInBlock, (String)"<this>");
            $this$isSearchInBlock.putCopyableUserData(SEARCH_IN_BLOCK_KEY, (Object)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession$SearchInBlockAction;", "Lcom/intellij/find/editorHeaderActions/Embeddable;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "Lcom/intellij/find/editorHeaderActions/EditorHeaderToggleAction;", "()V", "isSelected", "", "session", "Lcom/intellij/find/SearchSession;", "setSelected", "", "selected", "intellij.terminal"})
    private static final class SearchInBlockAction
    extends EditorHeaderToggleAction
    implements Embeddable,
    TooltipDescriptionProvider {
        public SearchInBlockAction() {
            super(TerminalBundle.message("search.in.block", new Object[0]), TerminalIcons.SearchInBlock, TerminalIcons.SearchInBlock, TerminalIcons.SearchInBlock);
        }

        protected boolean isSelected(@NotNull SearchSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            FindModel findModel = session2.getFindModel();
            Intrinsics.checkNotNullExpressionValue((Object)findModel, (String)"getFindModel(...)");
            return Companion.isSearchInBlock(findModel);
        }

        protected void setSelected(@NotNull SearchSession session2, boolean selected) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            FindModel findModel = session2.getFindModel();
            Intrinsics.checkNotNullExpressionValue((Object)findModel, (String)"getFindModel(...)");
            Companion.setSearchInBlock(findModel, selected);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession$TerminalSearchPresentation;", "Lcom/intellij/find/impl/livePreview/LivePreviewPresentation;", "()V", "cursorAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getCursorAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "cursorLayer", "", "getCursorLayer", "()I", "defaultAttributes", "getDefaultAttributes", "defaultLayer", "getDefaultLayer", "intellij.terminal"})
    private static final class TerminalSearchPresentation
    implements LivePreviewPresentation {
        private final int defaultLayer;
        private final int cursorLayer;

        public TerminalSearchPresentation() {
            this.defaultLayer = 6001;
            this.cursorLayer = 6002;
        }

        @NotNull
        public TextAttributes getDefaultAttributes() {
            return new TextAttributes(TerminalUi.INSTANCE.getSearchEntryForeground(), TerminalUi.INSTANCE.getSearchEntryBackground(), null, null, 0);
        }

        @NotNull
        public TextAttributes getCursorAttributes() {
            return new TextAttributes(TerminalUi.INSTANCE.getCurrentSearchEntryForeground(), TerminalUi.INSTANCE.getCurrentSearchEntryBackground(), null, null, 0);
        }

        public int getDefaultLayer() {
            return this.defaultLayer;
        }

        public int getCursorLayer() {
            return this.cursorLayer;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0014J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession$TerminalSearchResults;", "Lcom/intellij/find/impl/livePreview/SearchResults;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession;)V", "firstOccurrenceAtOrAfterCaret", "Lcom/intellij/find/FindResult;", "getLocalSearchArea", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchArea;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findModel", "Lcom/intellij/find/FindModel;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nBlockTerminalSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalSearchSession.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession$TerminalSearchResults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n1045#2:326\n350#2,7:327\n*S KotlinDebug\n*F\n+ 1 BlockTerminalSearchSession.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalSearchSession$TerminalSearchResults\n*L\n273#1:326\n294#1:327,7\n*E\n"})
    private final class TerminalSearchResults
    extends SearchResults {
        public TerminalSearchResults() {
            super((Editor)BlockTerminalSearchSession.this.editor, BlockTerminalSearchSession.this.project);
        }

        @NotNull
        protected SearchResults.SearchArea getLocalSearchArea(@NotNull Editor editor, @NotNull FindModel findModel) {
            SearchResults.SearchArea searchArea;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
            if (Companion.isSearchInBlock(findModel)) {
                Iterable $this$sortedBy$iv = BlockTerminalSearchSession.this.selectionModel.getSelectedBlocks();
                boolean $i$f$sortedBy = false;
                List blocks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CommandBlock it = (CommandBlock)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStartOffset());
                        it = (CommandBlock)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
                    }
                });
                int[] starts = new int[blocks.size()];
                int[] ends = new int[blocks.size()];
                int n = blocks.size();
                for (int index = 0; index < n; ++index) {
                    starts[index] = ((CommandBlock)blocks.get(index)).getStartOffset();
                    ends[index] = ((CommandBlock)blocks.get(index)).getEndOffset();
                }
                SearchResults.SearchArea searchArea2 = SearchResults.SearchArea.create((int[])starts, (int[])ends);
                Intrinsics.checkNotNull((Object)searchArea2);
                searchArea = searchArea2;
            } else {
                int[] nArray = new int[]{0};
                int[] nArray2 = nArray;
                nArray = new int[]{Integer.MAX_VALUE};
                SearchResults.SearchArea searchArea3 = SearchResults.SearchArea.create((int[])nArray2, (int[])nArray);
                searchArea = searchArea3;
                Intrinsics.checkNotNullExpressionValue((Object)searchArea3, (String)"create(...)");
            }
            return searchArea;
        }

        @Nullable
        protected FindResult firstOccurrenceAtOrAfterCaret() {
            FindResult findResult;
            int index;
            block4: {
                int n;
                int topY = this.getEditor().getScrollingModel().getVisibleArea().y + 3 * this.getEditor().getLineHeight();
                LogicalPosition logicalPosition = this.getEditor().xyToLogicalPosition(new Point(0, topY));
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                LogicalPosition topLogicalPosition = logicalPosition;
                int topOffset = this.getEditor().logicalPositionToOffset(topLogicalPosition);
                List list = this.getOccurrences();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOccurrences(...)");
                List $this$indexOfFirst$iv = list;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FindResult it = (FindResult)item$iv;
                    boolean bl = false;
                    if (it.getStartOffset() >= topOffset) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index > 0) {
                findResult = (FindResult)this.getOccurrences().get(index);
            } else {
                List list = this.getOccurrences();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOccurrences(...)");
                findResult = (FindResult)CollectionsKt.lastOrNull((List)list);
            }
            return findResult;
        }
    }
}

