/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsConfigurable;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

public final class TerminalShellCommandHandlerHelper {
    private static final Logger LOG = Logger.getInstance(TerminalShellCommandHandlerHelper.class);
    @NonNls
    private static final String FEATURE_ID = "terminal.shell.command.handling";
    private static final int TYPING_THRESHOLD_MS = 200;
    private static Experiments ourExperiments;
    private final ShellTerminalWidget myWidget;
    private final Alarm myAlarm;
    private volatile String myWorkingDirectory;
    private volatile Boolean myHasRunningCommands;
    private PropertiesComponent myPropertiesComponent;
    private final AtomicLong myLastKeyPressedMillis;
    private TerminalLineIntervalHighlighting myCommandHighlighting;
    private Disposable myNotificationDisposable;

    TerminalShellCommandHandlerHelper(@NotNull ShellTerminalWidget widget) {
        if (widget == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(0);
        }
        this.myLastKeyPressedMillis = new AtomicLong();
        this.myWidget = widget;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)widget);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myWidget).subscribe(TerminalCommandHandlerCustomizer.Companion.getTERMINAL_COMMAND_HANDLER_TOPIC(), () -> this.scheduleCommandHighlighting());
        TerminalModelListener listener = () -> {
            if (System.currentTimeMillis() - this.myLastKeyPressedMillis.get() < 200L) {
                this.scheduleCommandHighlighting();
            }
        };
        widget.getTerminalTextBuffer().addModelListener(listener);
        Disposer.register((Disposable)this.myWidget, () -> widget.getTerminalTextBuffer().removeModelListener(listener));
    }

    public void processKeyPressed(KeyEvent e) {
        if (TerminalShellCommandHandlerHelper.isFeatureEnabled()) {
            this.myLastKeyPressedMillis.set(System.currentTimeMillis());
            if (e.getKeyCode() == 27 && e.getModifiersEx() == 0 && this.hideNotification()) {
                e.consume();
            }
        }
    }

    private void scheduleCommandHighlighting() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.highlightMatchedCommand(this.myWidget.getProject()), 0);
    }

    public static boolean isFeatureEnabled() {
        Experiments experiments = ourExperiments;
        if (experiments == null) {
            ourExperiments = experiments = (Experiments)ReadAction.compute(() -> ApplicationManager.getApplication().isDisposed() ? null : Experiments.getInstance());
        }
        return experiments != null && experiments.isFeatureEnabled(FEATURE_ID);
    }

    private void highlightMatchedCommand(@NotNull Project project) {
        if (project == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(1);
        }
        if (!this.isEnabledForProject()) {
            this.setCommandHighlighting(null);
            return;
        }
        String command = this.myWidget.getTypedShellCommand().trim();
        TerminalLineIntervalHighlighting commandHighlighting = this.highlightCommandIfMatched(project, command);
        this.setCommandHighlighting(commandHighlighting);
        ApplicationManager.getApplication().invokeLater(() -> this.showOrHideNotification(commandHighlighting), ModalityState.stateForComponent((Component)this.myWidget.getTerminalPanel()));
    }

    private synchronized void setCommandHighlighting(@Nullable TerminalLineIntervalHighlighting commandHighlighting) {
        TerminalLineIntervalHighlighting oldHighlighting = this.myCommandHighlighting;
        if (oldHighlighting != null) {
            oldHighlighting.dispose();
            this.myWidget.getTerminalPanel().repaint();
        }
        this.myCommandHighlighting = commandHighlighting;
    }

    private boolean hideNotification() {
        boolean shown;
        boolean bl = shown = this.myNotificationDisposable != null && !Disposer.isDisposed((Disposable)this.myNotificationDisposable);
        if (shown) {
            Disposer.dispose((Disposable)this.myNotificationDisposable);
        }
        this.myNotificationDisposable = null;
        return shown;
    }

    private void showOrHideNotification(@Nullable TerminalLineIntervalHighlighting commandHighlighting) {
        if (commandHighlighting == null || commandHighlighting.isDisposed()) {
            this.hideNotification();
            return;
        }
        if (this.myNotificationDisposable != null && !Disposer.isDisposed((Disposable)this.myNotificationDisposable)) {
            return;
        }
        Disposable notificationDisposable = Disposer.newDisposable((Disposable)this.myWidget.getTerminalPanel(), (String)"terminal.smart_command_execution");
        String content = TerminalBundle.message("smart_command_execution.notification.text", KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getRunAction()), KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getDebugAction()));
        GotItTooltip tooltip = new GotItTooltip("terminal.smart_command_execution", content, notificationDisposable).withHeader(TerminalBundle.message("smart_command_execution.notification.title", new Object[0])).withLink(TerminalBundle.message("smart_command_execution.notification.configure_link.text", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(this.myWidget.getProject(), TerminalOptionsConfigurable.class)).withPosition(Balloon.Position.below);
        if (!tooltip.canShow()) {
            Disposer.dispose((Disposable)notificationDisposable);
            return;
        }
        tooltip.show((JComponent)this.myWidget.getTerminalPanel(), (component2, balloon) -> {
            Rectangle bounds = this.myWidget.processTerminalBuffer(buffer -> this.myWidget.getTerminalPanel().getBounds(commandHighlighting));
            if (bounds != null) {
                int shiftY = 0;
                if (balloon instanceof BalloonImpl && BalloonImpl.getAbstractPositionFor((Balloon.Position)Balloon.Position.below) == ((BalloonImpl)balloon).getPosition()) {
                    shiftY = bounds.height;
                }
                return new Point(bounds.x + bounds.width / 2, bounds.y + shiftY);
            }
            Disposer.dispose((Disposable)notificationDisposable);
            return new Point(0, 0);
        });
        this.myNotificationDisposable = notificationDisposable;
    }

    private boolean isEnabledForProject() {
        return this.getPropertiesComponent().getBoolean("terminalCustomCommandExecutionTurnOff", true);
    }

    @NotNull
    private PropertiesComponent getPropertiesComponent() {
        PropertiesComponent propertiesComponent = this.myPropertiesComponent;
        if (propertiesComponent == null) {
            this.myPropertiesComponent = propertiesComponent = (PropertiesComponent)ReadAction.compute(() -> PropertiesComponent.getInstance());
        }
        PropertiesComponent propertiesComponent2 = propertiesComponent;
        if (propertiesComponent2 == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(2);
        }
        return propertiesComponent2;
    }

    @Nullable
    private String getWorkingDirectory() {
        String workingDirectory = this.myWorkingDirectory;
        if (workingDirectory == null) {
            this.myWorkingDirectory = workingDirectory = StringUtil.notNullize((String)TerminalWorkingDirectoryManager.getWorkingDirectory(this.myWidget.asNewWidget()));
        }
        return StringUtil.nullize((String)workingDirectory);
    }

    private boolean hasRunningCommands() {
        Boolean hasRunningCommands = this.myHasRunningCommands;
        if (hasRunningCommands == null) {
            this.myHasRunningCommands = hasRunningCommands = Boolean.valueOf(this.myWidget.hasRunningCommands());
        }
        return hasRunningCommands;
    }

    @Nullable
    private TerminalLineIntervalHighlighting highlightCommandIfMatched(@NotNull Project project, @NotNull String command) {
        if (project == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(3);
        }
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(4);
        }
        if (command.isEmpty()) {
            return null;
        }
        if (!TerminalShellCommandHandler.Companion.matches(project, this.getWorkingDirectory(), !this.hasRunningCommands(), command)) {
            return null;
        }
        return this.myWidget.processTerminalBuffer(textBuffer -> {
            int cursorLine = this.myWidget.getLineNumberAtCursor();
            if (cursorLine < 0 || cursorLine >= textBuffer.getHeight()) {
                return null;
            }
            String lineText = textBuffer.getLine(cursorLine).getText();
            int commandStartInd = lineText.lastIndexOf(command);
            if (commandStartInd < 0) {
                return null;
            }
            TextStyle textStyle = TerminalShellCommandHandlerHelper.getSmartCommandExecutionStyle();
            if (textStyle == null) {
                return null;
            }
            return this.myWidget.highlightLineInterval(cursorLine, commandStartInd, command.length(), textStyle);
        });
    }

    @Nullable
    private static TextStyle getSmartCommandExecutionStyle() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(JBTerminalSystemSettingsProviderBase.COMMAND_TO_RUN_USING_IDE_KEY);
        if (attributes == null) {
            return null;
        }
        return new TextStyle(AwtTransformers.fromAwtToTerminalColor((Color)attributes.getForegroundColor()), AwtTransformers.fromAwtToTerminalColor((Color)attributes.getBackgroundColor()));
    }

    public boolean processEnterKeyPressed(@NotNull KeyEvent keyPressed) {
        boolean localSession;
        boolean hasRunningCommands;
        if (keyPressed == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(5);
        }
        if (!TerminalShellCommandHandlerHelper.isFeatureEnabled() || !this.isEnabledForProject()) {
            this.onShellCommandExecuted();
            return false;
        }
        this.myLastKeyPressedMillis.set(System.currentTimeMillis());
        String command = this.myWidget.getTypedShellCommand().trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("typed shell command to execute: " + command);
        }
        this.myAlarm.cancelAllRequests();
        Project project = this.myWidget.getProject();
        String workingDirectory = this.getWorkingDirectory();
        Executor executor = TerminalShellCommandHandlerHelper.matchedExecutor(keyPressed);
        if (executor != null) {
            hasRunningCommands = this.hasRunningCommands();
        } else {
            Boolean hasRunningCommandsLocal = this.myHasRunningCommands;
            if (hasRunningCommandsLocal == null) {
                this.onShellCommandExecuted();
                return false;
            }
            hasRunningCommands = hasRunningCommandsLocal;
        }
        boolean bl = localSession = !hasRunningCommands;
        if (!TerminalShellCommandHandler.Companion.matches(project, workingDirectory, localSession, command)) {
            this.onShellCommandExecuted();
            return false;
        }
        TerminalShellCommandHandler handler = TerminalShellCommandHandler.Companion.getEP().getExtensionList().stream().filter(it -> it.matches(project, workingDirectory, localSession, command)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find matching command handler."));
        if (executor == null) {
            this.onShellCommandExecuted();
            TerminalUsageTriggerCollector.triggerSmartCommand(project, workingDirectory, localSession, command, handler, false);
            return false;
        }
        TerminalUsageTriggerCollector.triggerSmartCommand(project, workingDirectory, localSession, command, handler, true);
        TerminalShellCommandHandler.Companion.executeShellCommandHandler(this.myWidget.getProject(), this.getWorkingDirectory(), !this.hasRunningCommands(), command, executor);
        this.clearTypedCommand(command);
        return true;
    }

    private void onShellCommandExecuted() {
        this.myWorkingDirectory = null;
        this.myHasRunningCommands = null;
    }

    private void clearTypedCommand(@NotNull String command) {
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(6);
        }
        TtyConnector connector = this.myWidget.getTtyConnector();
        byte[] array = new byte[command.length()];
        Arrays.fill(array, (byte)8);
        try {
            connector.write(array);
        }
        catch (IOException e) {
            LOG.info("Cannot clear shell command " + command, (Throwable)e);
        }
    }

    @Nullable
    static Executor matchedExecutor(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(7);
        }
        if (TerminalShellCommandHandlerHelper.matchAction(e, TerminalShellCommandHandlerHelper.getRunAction())) {
            return DefaultRunExecutor.getRunExecutorInstance();
        }
        if (TerminalShellCommandHandlerHelper.matchAction(e, TerminalShellCommandHandlerHelper.getDebugAction())) {
            return ExecutorRegistry.getInstance().getExecutorById("Debug");
        }
        return null;
    }

    private static boolean matchAction(@NotNull KeyEvent e, @NotNull AnAction action) {
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(8);
        }
        if (action == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(9);
        }
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        return ContainerUtil.exists((Object[])action.getShortcutSet().getShortcuts(), sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut));
    }

    @NotNull
    private static AnAction getRunAction() {
        AnAction anAction = Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Run"));
        if (anAction == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(10);
        }
        return anAction;
    }

    @NotNull
    private static AnAction getDebugAction() {
        AnAction anAction = Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Debug"));
        if (anAction == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(11);
        }
        return anAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPressed";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "highlightMatchedCommand";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "highlightCommandIfMatched";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processEnterKeyPressed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearTypedCommand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchedExecutor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 11 -> new IllegalStateException(string);
        };
    }
}

