/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.jetbrains.plugins.textmate.regex.TextMateRange;
import org.joni.Region;

public final class MatchData {
    public static final MatchData NOT_MATCHED = new MatchData(false, new int[0]);
    private final boolean matched;
    private final int @NotNull [] offsets;

    private MatchData(boolean matched, int @NotNull [] offsets) {
        if (offsets == null) {
            MatchData.$$$reportNull$$$0(0);
        }
        this.matched = matched;
        this.offsets = offsets;
    }

    public static MatchData fromRegion(@Nullable Region matchedRegion) {
        if (matchedRegion != null) {
            int[] offsets = new int[matchedRegion.getNumRegs() * 2];
            for (int i = 0; i < matchedRegion.getNumRegs(); ++i) {
                int startIndex = i * 2;
                offsets[startIndex] = Math.max(matchedRegion.getBeg(i), 0);
                offsets[startIndex + 1] = Math.max(matchedRegion.getEnd(i), 0);
            }
            return new MatchData(true, offsets);
        }
        return NOT_MATCHED;
    }

    public int count() {
        return this.offsets.length / 2;
    }

    public TextMateRange byteOffset() {
        return this.byteOffset(0);
    }

    @NotNull
    public TextMateRange byteOffset(int group) {
        int endIndex = group * 2 + 1;
        return new TextMateRange(this.offsets[endIndex - 1], this.offsets[endIndex]);
    }

    public TextMateRange charRange(CharSequence s, byte[] stringBytes) {
        return this.charRange(s, stringBytes, 0);
    }

    public TextMateRange charRange(CharSequence s, byte[] stringBytes, int group) {
        TextMateRange range = this.codePointRange(stringBytes, group);
        return new TextMateRange(Character.offsetByCodePoints(s, 0, range.start), Character.offsetByCodePoints(s, 0, range.end));
    }

    public TextMateRange codePointRange(byte[] stringBytes) {
        return this.codePointRange(stringBytes, 0);
    }

    @NotNull
    public TextMateRange codePointRange(byte[] stringBytes, int group) {
        TextMateRange textMateRange = RegexUtil.codePointsRangeByByteRange(stringBytes, this.byteOffset(group));
        if (textMateRange == null) {
            MatchData.$$$reportNull$$$0(1);
        }
        return textMateRange;
    }

    public boolean matched() {
        return this.matched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchData matchData = (MatchData)o;
        if (this.matched != matchData.matched) {
            return false;
        }
        return Arrays.equals(this.offsets, matchData.offsets);
    }

    public int hashCode() {
        return 31 * (this.matched ? 1 : 0) + Arrays.hashCode(this.offsets);
    }

    public String toString() {
        return "{ matched=" + this.matched + ", offsets=" + Arrays.toString(this.offsets) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/regex/MatchData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/regex/MatchData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "codePointRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

