/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.xsd.ChildType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class SchemaInfo {
    private final SchemaCollection sc;
    private final GrammarPattern grammar;
    private final ErrorReporter er;
    private final Map childTypeMap = new HashMap();
    private final Map defineMap = new HashMap();
    private final Set ignoredDefines = new HashSet();
    private final PatternVisitor childTypeVisitor = new ChildTypeVisitor();
    private static final int DEFINE_KEEP = 0;
    private static final int DEFINE_IGNORE = 1;
    private static final int DEFINE_REQUIRE = 2;

    SchemaInfo(SchemaCollection schemaCollection, ErrorReporter errorReporter) {
        this.sc = schemaCollection;
        this.er = errorReporter;
        this.forceGrammar();
        this.grammar = this.getSchema(schemaCollection.getMainUri());
        this.grammar.componentsAccept(new GrammarVisitor());
    }

    private void forceGrammar() {
        SchemaDocument schemaDocument = (SchemaDocument)this.sc.getSchemaDocumentMap().get(this.sc.getMainUri());
        schemaDocument.setPattern(SchemaInfo.convertToGrammar(schemaDocument.getPattern()));
    }

    private static GrammarPattern convertToGrammar(Pattern pattern2) {
        if (pattern2 instanceof GrammarPattern) {
            return (GrammarPattern)pattern2;
        }
        GrammarPattern grammarPattern = new GrammarPattern();
        grammarPattern.setSourceLocation(pattern2.getSourceLocation());
        grammarPattern.setContext(pattern2.getContext());
        DefineComponent defineComponent = new DefineComponent(DefineComponent.START, pattern2);
        defineComponent.setSourceLocation(pattern2.getSourceLocation());
        grammarPattern.getComponents().add(defineComponent);
        return grammarPattern;
    }

    GrammarPattern getGrammar() {
        return this.grammar;
    }

    String getMainUri() {
        return this.sc.getMainUri();
    }

    GrammarPattern getSchema(String string2) {
        return (GrammarPattern)((SchemaDocument)this.sc.getSchemaDocumentMap().get(string2)).getPattern();
    }

    String getEncoding(String string2) {
        return ((SchemaDocument)this.sc.getSchemaDocumentMap().get(string2)).getEncoding();
    }

    ChildType getChildType(Pattern pattern2) {
        ChildType childType = (ChildType)this.childTypeMap.get(pattern2);
        if (childType == null) {
            childType = (ChildType)pattern2.accept(this.childTypeVisitor);
            this.childTypeMap.put(pattern2, childType);
        }
        return childType;
    }

    Pattern getStart() {
        return this.lookupDefine((String)DefineComponent.START).pattern;
    }

    Pattern getBody(RefPattern refPattern) {
        return this.lookupDefine((String)refPattern.getName()).pattern;
    }

    Pattern getBody(DefineComponent defineComponent) {
        Define define = this.lookupDefine(defineComponent.getName());
        if (define == null || define.head != defineComponent) {
            return null;
        }
        return define.pattern;
    }

    boolean isIgnored(DefineComponent defineComponent) {
        return this.ignoredDefines.contains(defineComponent);
    }

    private Define lookupDefine(String string2) {
        Define define = (Define)this.defineMap.get(string2);
        if (define == null) {
            define = new Define();
            this.defineMap.put(string2, define);
        }
        return define;
    }

    class GrammarVisitor
    implements ComponentVisitor {
        private final Set openIncludes = new HashSet();
        private final Set allIncludes = new HashSet();
        private List overrides = null;

        GrammarVisitor() {
        }

        public Object visitDefine(DefineComponent defineComponent) {
            Define define = SchemaInfo.this.lookupDefine(defineComponent.getName());
            if (this.overrides != null) {
                this.overrides.add(new Override(define, defineComponent.getName()));
            }
            if (define.status != 0) {
                SchemaInfo.this.ignoredDefines.add(defineComponent);
                define.status = 1;
                return null;
            }
            if (defineComponent.getCombine() == null) {
                if (define.hadImplicit) {
                    SchemaInfo.this.er.error("multiple_define", defineComponent.getName(), defineComponent.getSourceLocation());
                    return null;
                }
                define.hadImplicit = true;
            } else if (define.combine == null) {
                define.combine = defineComponent.getCombine();
                define.wrapper = define.combine == Combine.CHOICE ? new ChoicePattern() : new InterleavePattern();
                define.wrapper.setSourceLocation(defineComponent.getSourceLocation());
            } else if (define.combine != defineComponent.getCombine()) {
                SchemaInfo.this.er.error("inconsistent_combine", defineComponent.getName(), defineComponent.getSourceLocation());
                return null;
            }
            if (define.pattern == null) {
                define.pattern = defineComponent.getBody();
                define.head = defineComponent;
            } else {
                if (define.pattern != define.wrapper) {
                    define.wrapper.getChildren().add(define.pattern);
                }
                define.wrapper.getChildren().add(defineComponent.getBody());
                define.pattern = define.wrapper;
            }
            return null;
        }

        public Object visitDiv(DivComponent divComponent) {
            divComponent.componentsAccept(this);
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            Vector vector = new Vector();
            List list2 = this.overrides;
            this.overrides = vector;
            includeComponent.componentsAccept(this);
            this.overrides = list2;
            String string2 = includeComponent.getHref();
            if (this.openIncludes.contains(string2)) {
                SchemaInfo.this.er.error("include_loop", string2, includeComponent.getSourceLocation());
            } else if (this.allIncludes.contains(string2)) {
                SchemaInfo.this.er.error("multiple_include", string2, includeComponent.getSourceLocation());
            } else {
                Object object;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    object = (Override)iterator.next();
                    ((Override)object).status = ((Override)object).define.status;
                    ((Override)object).define.status = 2;
                }
                this.allIncludes.add(string2);
                this.openIncludes.add(string2);
                SchemaInfo.this.getSchema(string2).componentsAccept(this);
                this.openIncludes.remove(string2);
                object = vector.iterator();
                while (object.hasNext()) {
                    Override override = (Override)object.next();
                    if (override.define.status == 2) {
                        if (override.name == DefineComponent.START) {
                            SchemaInfo.this.er.error("missing_start_replacement", includeComponent.getSourceLocation());
                        } else {
                            SchemaInfo.this.er.error("missing_define_replacement", override.name, includeComponent.getSourceLocation());
                        }
                    }
                    override.define.status = override.status;
                }
            }
            return null;
        }
    }

    static class Override {
        int status;
        final Define define;
        final String name;

        Override(Define define, String string2) {
            this.define = define;
            this.name = string2;
        }
    }

    class ChildTypeVisitor
    extends PatternAnalysisVisitor {
        ChildTypeVisitor() {
        }

        Object get(Pattern pattern2) {
            return SchemaInfo.this.getChildType(pattern2);
        }

        Object empty() {
            return ChildType.EMPTY;
        }

        Object text() {
            return ChildType.choice(ChildType.TEXT, ChildType.EMPTY);
        }

        Object data() {
            return ChildType.DATA;
        }

        Object notAllowed() {
            return ChildType.NOT_ALLOWED;
        }

        Object list(Object object) {
            if (object.equals(ChildType.NOT_ALLOWED)) {
                return object;
            }
            return this.data();
        }

        Object choice(Object object, Object object2) {
            return ChildType.choice((ChildType)object, (ChildType)object2);
        }

        Object group(Object object, Object object2) {
            return ChildType.group((ChildType)object, (ChildType)object2);
        }

        public Object visitElement(ElementPattern elementPattern) {
            return ChildType.ELEMENT;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            if (SchemaInfo.this.getChildType(attributePattern.getChild()).equals(ChildType.NOT_ALLOWED)) {
                return ChildType.NOT_ALLOWED;
            }
            return ChildType.choice(ChildType.ATTRIBUTE, ChildType.EMPTY);
        }
    }

    abstract class PatternAnalysisVisitor
    extends AbstractVisitor {
        PatternAnalysisVisitor() {
        }

        abstract Object get(Pattern var1);

        abstract Object choice(Object var1, Object var2);

        abstract Object group(Object var1, Object var2);

        Object interleave(Object object, Object object2) {
            return this.group(object, object2);
        }

        Object ref(Object object) {
            return object;
        }

        Object oneOrMore(Object object) {
            return this.group(object, object);
        }

        abstract Object empty();

        abstract Object text();

        abstract Object data();

        abstract Object notAllowed();

        Object list(Object object) {
            return this.data();
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            List list2 = choicePattern.getChildren();
            Object object = this.get((Pattern)list2.get(0));
            int n = 1;
            int n2 = list2.size();
            while (n < n2) {
                object = this.choice(object, this.get((Pattern)list2.get(n)));
                ++n;
            }
            return object;
        }

        public Object visitGroup(GroupPattern groupPattern) {
            List list2 = groupPattern.getChildren();
            Object object = this.get((Pattern)list2.get(0));
            int n = 1;
            int n2 = list2.size();
            while (n < n2) {
                object = this.group(object, this.get((Pattern)list2.get(n)));
                ++n;
            }
            return object;
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            List list2 = interleavePattern.getChildren();
            Object object = this.get((Pattern)list2.get(0));
            int n = 1;
            int n2 = list2.size();
            while (n < n2) {
                object = this.interleave(object, this.get((Pattern)list2.get(n)));
                ++n;
            }
            return object;
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return this.choice(this.empty(), this.oneOrMore(this.get(zeroOrMorePattern.getChild())));
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return this.oneOrMore(this.get(oneOrMorePattern.getChild()));
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return this.choice(this.empty(), this.get(optionalPattern.getChild()));
        }

        public Object visitEmpty(EmptyPattern emptyPattern) {
            return this.empty();
        }

        public Object visitRef(RefPattern refPattern) {
            return this.ref(this.get(SchemaInfo.this.getBody(refPattern)));
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            return this.interleave(this.text(), this.get(mixedPattern.getChild()));
        }

        public Object visitText(TextPattern textPattern) {
            return this.text();
        }

        public Object visitData(DataPattern dataPattern) {
            return this.data();
        }

        public Object visitValue(ValuePattern valuePattern) {
            return this.data();
        }

        public Object visitList(ListPattern listPattern) {
            return this.list(this.get(listPattern.getChild()));
        }

        public Object visitNotAllowed(NotAllowedPattern notAllowedPattern) {
            return this.notAllowed();
        }
    }

    private static class Define {
        int status = 0;
        boolean hadImplicit;
        Combine combine;
        Pattern pattern;
        CompositePattern wrapper;
        DefineComponent head;

        private Define() {
        }
    }
}

