/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.ErrorPattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternBuilder;
import com.thaiopensource.relaxng.impl.PatternInterner;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.UnexpandedNotAllowedPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

public class SchemaPatternBuilder
extends PatternBuilder {
    private boolean idTypes;
    private final UnexpandedNotAllowedPattern unexpandedNotAllowed = new UnexpandedNotAllowedPattern();
    private final TextPattern text = new TextPattern();
    private final PatternInterner schemaInterner = new PatternInterner();

    public boolean hasIdTypes() {
        return this.idTypes;
    }

    Pattern makeElement(NameClass nameClass, Pattern pattern2, Locator locator) {
        ElementPattern elementPattern = new ElementPattern(nameClass, pattern2, locator);
        return this.schemaInterner.intern(elementPattern);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern pattern2, Locator locator) {
        if (pattern2 == this.notAllowed) {
            return pattern2;
        }
        AttributePattern attributePattern = new AttributePattern(nameClass, pattern2, locator);
        return this.schemaInterner.intern(attributePattern);
    }

    Pattern makeData(Datatype datatype) {
        this.noteDatatype(datatype);
        DataPattern dataPattern = new DataPattern(datatype);
        return this.schemaInterner.intern(dataPattern);
    }

    Pattern makeDataExcept(Datatype datatype, Pattern pattern2, Locator locator) {
        this.noteDatatype(datatype);
        DataExceptPattern dataExceptPattern = new DataExceptPattern(datatype, pattern2, locator);
        return this.schemaInterner.intern(dataExceptPattern);
    }

    Pattern makeValue(Datatype datatype, Object object) {
        this.noteDatatype(datatype);
        ValuePattern valuePattern = new ValuePattern(datatype, object);
        return this.schemaInterner.intern(valuePattern);
    }

    Pattern makeText() {
        return this.text;
    }

    Pattern makeOneOrMore(Pattern pattern2) {
        if (pattern2 == this.text) {
            return pattern2;
        }
        return super.makeOneOrMore(pattern2);
    }

    Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    Pattern makeError() {
        ErrorPattern errorPattern = new ErrorPattern();
        return this.schemaInterner.intern(errorPattern);
    }

    Pattern makeChoice(Pattern pattern2, Pattern pattern3) {
        if (pattern2 == this.notAllowed || pattern2 == pattern3) {
            return pattern3;
        }
        if (pattern3 == this.notAllowed) {
            return pattern2;
        }
        return super.makeChoice(pattern2, pattern3);
    }

    Pattern makeList(Pattern pattern2, Locator locator) {
        if (pattern2 == this.notAllowed) {
            return pattern2;
        }
        ListPattern listPattern = new ListPattern(pattern2, locator);
        return this.schemaInterner.intern(listPattern);
    }

    Pattern makeMixed(Pattern pattern2) {
        return this.makeInterleave(this.text, pattern2);
    }

    private void noteDatatype(Datatype datatype) {
        if (datatype.getIdType() != 0) {
            this.idTypes = true;
        }
    }
}

