/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;

class GroupPattern
extends BinaryPattern {
    GroupPattern(Pattern pattern2, Pattern pattern3) {
        super(pattern2.isNullable() && pattern3.isNullable(), Pattern.combineHashCode(13, pattern2.hashCode(), pattern3.hashCode()), pattern2, pattern3);
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern2 = this.p1.expand(schemaPatternBuilder);
        Pattern pattern3 = this.p2.expand(schemaPatternBuilder);
        if (pattern2 != this.p1 || pattern3 != this.p2) {
            return schemaPatternBuilder.makeGroup(pattern2, pattern3);
        }
        return this;
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_group");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_group");
            }
        }
        super.checkRestrictions(n == 2 ? 3 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !Pattern.contentTypeGroupable(this.p1.getContentType(), this.p2.getContentType())) {
            throw new RestrictionViolationException("group_string");
        }
    }

    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitGroup(this.p1, this.p2);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseGroup(this);
    }
}

