/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.jdk1_4;

import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.datatype.xsd.regex.jdk1_4.Categories;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.Utf16;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Translator {
    private final String regExp;
    private int pos = 0;
    private final int length;
    private char curChar;
    private boolean eos = false;
    private final StringBuffer result = new StringBuffer();
    private static final String categories = "LMNPZSC";
    private static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private static final int NONBMP_MIN = 65536;
    private static final int NONBMP_MAX = 0x10FFFF;
    private static final char SURROGATE2_MIN = '\udc00';
    private static final char SURROGATE2_MAX = '\udfff';
    static final Localizer localizer = new Localizer(class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator == null ? (class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator = Translator.class$("com.thaiopensource.datatype.xsd.regex.jdk1_4.Translator")) : class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator);
    private static final String[] blockNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-B", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-B", "Specials", "HalfwidthandFullwidthForms", "Specials"};
    private static final String[] specialBlockNames = new String[]{"OldItalic", "Gothic", "Deseret", "ByzantineMusicalSymbols", "MusicalSymbols", "MathematicalAlphanumericSymbols", "CJKUnifiedIdeographsExtensionB", "CJKCompatibilityIdeographsSupplement", "Tags", "PrivateUse", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates"};
    private static final CharClass[] specialBlockCharClasses = new CharClass[]{new CharRange(66304, 66351), new CharRange(66352, 66383), new CharRange(66560, 66639), new CharRange(118784, 119039), new CharRange(119040, 119295), new CharRange(119808, 120831), new CharRange(131072, 173782), new CharRange(194560, 195103), new CharRange(917504, 917631), new Union(new CharClass[]{new CharRange(57344, 63743), new CharRange(983040, 1048573), new CharRange(0x100000, 1114109)}), Empty.getInstance(), Empty.getInstance(), Empty.getInstance()};
    private static final CharClass DOT = new Complement(new Union(new CharClass[]{new SingleChar('\n'), new SingleChar('\r')}));
    private static final CharClass ESC_d = new Property("Nd");
    private static final CharClass ESC_D = new Complement(ESC_d);
    private static final CharClass ESC_W = new Union(new CharClass[]{new Property("P"), new Property("Z"), new Property("C")});
    private static final CharClass ESC_w = new Complement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(' '), new SingleChar('\n'), new SingleChar('\r'), new SingleChar('\t')});
    private static final CharClass ESC_S = new Complement(ESC_s);
    private static final CharClass ESC_i = Translator.makeCharClass("LlLuLoLtNl", ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e", "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_I = new Complement(ESC_i);
    private static final CharClass ESC_c = Translator.makeCharClass("LlLuLoLtNlMcMeMnLmNd", "-.:_\u00b7\u0387\u212e", "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_C = new Complement(ESC_c);
    private static final char EOS = '\u0000';
    static final int NONE = -1;
    static final int SOME = 0;
    static final int ALL = 1;
    static final String SURROGATES1_CLASS = "[\ud800-\udbff]";
    static final String SURROGATES2_CLASS = "[\udc00-\udfff]";
    static final String NOT_ALLOWED_CLASS = "[\u0000&&[^\u0000]]";
    private static final char UNICODE_3_1_ADD_Lu = '\u03f4';
    private static final char UNICODE_3_1_ADD_Ll = '\u03f5';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MIN = '\u16ee';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MAX = '\u16f0';
    private static final String CATEGORY_Pi = "\u00ab\u2018\u201b\u201c\u201f\u2039";
    private static final String CATEGORY_Pf = "\u00bb\u2019\u201d\u203a";
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator;

    private Translator(String string2) {
        this.regExp = string2;
        this.length = string2.length();
        this.advance();
    }

    public static String translate(String string2) throws RegexSyntaxException {
        Translator translator = new Translator(string2);
        translator.translateTop();
        return translator.result.toString();
    }

    private void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    private void translateTop() throws RegexSyntaxException {
        this.translateRegExp();
        if (!this.eos) {
            throw this.makeException("expected_eos");
        }
    }

    private void translateRegExp() throws RegexSyntaxException {
        this.translateBranch();
        while (this.curChar == '|') {
            this.copyCurChar();
            this.translateBranch();
        }
    }

    private void translateBranch() throws RegexSyntaxException {
        while (this.translateAtom()) {
            this.translateQuantifier();
        }
    }

    private void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.copyCurChar();
                return;
            }
            case '{': {
                this.copyCurChar();
                this.translateQuantity();
                this.expect('}');
                this.copyCurChar();
            }
        }
    }

    private void translateQuantity() throws RegexSyntaxException {
        block7: {
            String string2 = this.parseQuantExact();
            int n = -1;
            try {
                n = Integer.parseInt(string2);
                this.result.append(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.result.append(Integer.MAX_VALUE);
            }
            if (this.curChar == ',') {
                this.copyCurChar();
                if (this.curChar != '}') {
                    String string3 = this.parseQuantExact();
                    try {
                        int n2 = Integer.parseInt(string3);
                        this.result.append(string3);
                        if (n < 0 || n2 < n) {
                            throw this.makeException("invalid_quantity_range");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.result.append(Integer.MAX_VALUE);
                        if (n >= 0 || new BigDecimal(string2).compareTo(new BigDecimal(string3)) <= 0) break block7;
                        throw this.makeException("invalid_quantity_range");
                    }
                }
            }
        }
    }

    private String parseQuantExact() throws RegexSyntaxException {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected_digit");
            }
            stringBuffer.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return stringBuffer.toString();
    }

    private void copyCurChar() {
        this.result.append(this.curChar);
        this.advance();
    }

    private boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                this.translateRegExp();
                this.expect(')');
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                DOT.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                this.result.append('\\');
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeCharClass(String string2, String string3, String string4) {
        Vector<SimpleCharClass> vector = new Vector<SimpleCharClass>();
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            vector.add(new Property(string2.substring(n, n + 2)));
            n += 2;
        }
        int n3 = 0;
        int n4 = string3.length();
        while (n3 < n4) {
            int n5 = n3 + 1;
            while (n5 < n4 && string3.charAt(n5) - string3.charAt(n3) == n5 - n3) {
                ++n5;
            }
            if (n3 == --n5 - 1) {
                --n5;
            }
            if (n3 == n5) {
                vector.add(new SingleChar(string3.charAt(n3)));
            } else {
                vector.add(new CharRange(string3.charAt(n3), string3.charAt(n5)));
            }
            n3 = n5;
            ++n3;
        }
        Vector<SimpleCharClass> vector2 = new Vector<SimpleCharClass>();
        int n6 = 0;
        int n7 = string4.length();
        while (n6 < n7) {
            char c;
            char c2 = string4.charAt(n6);
            if (c2 == (c = string4.charAt(n6 + 1))) {
                vector2.add(new SingleChar(c2));
            } else if (c2 == c - '\u0001') {
                vector2.add(new SingleChar(c2));
                vector2.add(new SingleChar(c));
            } else {
                vector2.add(new CharRange(c2, c));
            }
            n6 += 2;
        }
        return new Subtraction(new Union(vector), new Union(vector2));
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar('\n');
            }
            case 'r': {
                this.advance();
                return new SingleChar('\r');
            }
            case 't': {
                this.advance();
                return new SingleChar('\t');
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i;
            }
            case 'I': {
                this.advance();
                return ESC_I;
            }
            case 'c': {
                this.advance();
                return ESC_c;
            }
            case 'C': {
                this.advance();
                return ESC_C;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new Complement(this.parseProp());
            }
            default: {
                throw this.makeException("bad_escape");
            }
        }
        SingleChar singleChar = new SingleChar(this.curChar);
        this.advance();
        return singleChar;
    }

    private CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int n = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (Translator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        String string2 = this.regExp.substring(n, this.pos - 1);
        this.advance();
        switch (string2.length()) {
            case 0: {
                throw this.makeException("empty_property_name");
            }
            case 2: {
                int n2 = subCategories.indexOf(string2);
                if (n2 < 0 || n2 % 2 == 1) {
                    throw this.makeException("bad_category");
                }
                return Translator.getSubCategoryCharClass(n2 / 2);
            }
            case 1: {
                int n3 = categories.indexOf(string2.charAt(0));
                if (n3 < 0) {
                    throw this.makeException("bad_category", string2);
                }
                return Translator.getCategoryCharClass(n3);
            }
        }
        if (string2.startsWith("Is")) {
            String string3 = string2.substring(2);
            int n4 = 0;
            while (n4 < specialBlockNames.length) {
                if (string3.equals(specialBlockNames[n4])) {
                    return specialBlockCharClasses[n4];
                }
                ++n4;
            }
            if (!Translator.isBlock(string3)) {
                throw this.makeException("bad_block_name", string3);
            }
            return new Property("In" + string3);
        }
        throw this.makeException("bad_property_name", string2);
    }

    private static boolean isBlock(String string2) {
        int n = 0;
        while (n < blockNames.length) {
            if (string2.equals(blockNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isAsciiAlnum(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    private void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        CharClass charClass;
        boolean bl;
        if (this.curChar == '^') {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        Vector<CharClass> vector = new Vector<CharClass>();
        do {
            charClass = this.parseCharClassEscOrXmlChar();
            vector.add(charClass);
            if (this.curChar != '-') continue;
            this.advance();
            if (this.curChar == '[') break;
            CharClass charClass2 = this.parseCharClassEscOrXmlChar();
            if (charClass.singleChar() < 0 || charClass2.singleChar() < 0) {
                throw this.makeException("multi_range");
            }
            if (charClass.singleChar() > charClass2.singleChar()) {
                throw this.makeException("invalid_range");
            }
            vector.set(vector.size() - 1, new CharRange(charClass.singleChar(), charClass2.singleChar()));
            if (this.curChar != '-') continue;
            this.advance();
            this.expect('[');
            break;
        } while (this.curChar != ']');
        charClass = vector.size() == 1 ? (CharClass)vector.get(0) : new Union(vector);
        if (bl) {
            charClass = new Complement(charClass);
        }
        if (this.curChar == '[') {
            this.advance();
            charClass = new Subtraction(charClass, this.parseCharClassExpr());
            this.expect(']');
        }
        this.advance();
        return charClass;
    }

    private CharClass parseCharClassEscOrXmlChar() throws RegexSyntaxException {
        SimpleCharClass simpleCharClass;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '-': 
            case '[': 
            case ']': {
                throw this.makeException("should_quote", new String(new char[]{this.curChar}));
            }
        }
        if (Utf16.isSurrogate(this.curChar)) {
            if (!Utf16.isSurrogate1(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            char c = this.curChar;
            this.advance();
            if (!Utf16.isSurrogate2(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            simpleCharClass = new WideSingleChar(Utf16.scalarValue(c, this.curChar));
        } else {
            simpleCharClass = new SingleChar(this.curChar);
        }
        this.advance();
        return simpleCharClass;
    }

    private RegexSyntaxException makeException(String string2) {
        return new RegexSyntaxException(localizer.message(string2), this.pos - 1);
    }

    private RegexSyntaxException makeException(String string2, String string3) {
        return new RegexSyntaxException(localizer.message(string2, string3), this.pos - 1);
    }

    private static boolean isJavaMetaChar(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static synchronized CharClass getCategoryCharClass(int n) {
        if (categoryCharClasses[n] == null) {
            Translator.categoryCharClasses[n] = Translator.computeCategoryCharClass(categories.charAt(n));
        }
        return categoryCharClasses[n];
    }

    private static synchronized CharClass getSubCategoryCharClass(int n) {
        if (subCategoryCharClasses[n] == null) {
            Translator.subCategoryCharClasses[n] = Translator.computeSubCategoryCharClass(subCategories.substring(n * 2, (n + 1) * 2));
        }
        return subCategoryCharClasses[n];
    }

    private static CharClass computeCategoryCharClass(char c) {
        int n;
        Object object;
        Vector<CharClass> vector = new Vector<CharClass>();
        vector.add(new Property(new String(new char[]{c})));
        int n2 = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(c);
        while (n2 >= 0) {
            object = Categories.CATEGORY_RANGES[n2 / 2];
            n = 0;
            while (n < ((int[])object).length) {
                vector.add(new CharRange(object[n], object[n + 1]));
                n += 2;
            }
            n2 = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(c, n2 + 1);
        }
        if (c == 'P') {
            vector.add(Translator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (c == 'L') {
            vector.add(new SingleChar('\u03f5'));
            vector.add(new SingleChar('\u03f4'));
        }
        if (c == 'C') {
            vector.add(new Subtraction(new Property("Cn"), new Union(new CharClass[]{new SingleChar('\u03f4'), new SingleChar('\u03f5')})));
            object = new Vector();
            n = 0;
            while (n < Categories.CATEGORY_RANGES.length) {
                int n3 = 0;
                while (n3 < Categories.CATEGORY_RANGES[n].length) {
                    object.add(new CharRange(Categories.CATEGORY_RANGES[n][n3], Categories.CATEGORY_RANGES[n][n3 + 1]));
                    n3 += 2;
                }
                ++n;
            }
            vector.add(new Subtraction(new CharRange(65536, 0x10FFFF), new Union((List)object)));
        }
        if (vector.size() == 1) {
            return (CharClass)vector.get(0);
        }
        return new Union(vector);
    }

    private static CharClass computeSubCategoryCharClass(String string2) {
        Property property2 = new Property(string2);
        int n = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(string2);
        if (n < 0) {
            if (string2.equals("Cn")) {
                Vector<SimpleCharClass> vector = new Vector<SimpleCharClass>();
                vector.add(new SingleChar('\u03f4'));
                vector.add(new SingleChar('\u03f5'));
                int n2 = 0;
                while (n2 < Categories.CATEGORY_RANGES.length) {
                    int n3 = 0;
                    while (n3 < Categories.CATEGORY_RANGES[n2].length) {
                        vector.add(new CharRange(Categories.CATEGORY_RANGES[n2][n3], Categories.CATEGORY_RANGES[n2][n3 + 1]));
                        n3 += 2;
                    }
                    ++n2;
                }
                return new Subtraction(new Union(new CharClass[]{property2, new CharRange(65536, 0x10FFFF)}), new Union(vector));
            }
            if (string2.equals("Pi")) {
                return Translator.makeCharClass(CATEGORY_Pi);
            }
            if (string2.equals("Pf")) {
                return Translator.makeCharClass(CATEGORY_Pf);
            }
            return property2;
        }
        Vector<SimpleCharClass> vector = new Vector<SimpleCharClass>();
        vector.add(property2);
        int[] nArray = Categories.CATEGORY_RANGES[n / 2];
        int n4 = 0;
        while (n4 < nArray.length) {
            vector.add(new CharRange(nArray[n4], nArray[n4 + 1]));
            n4 += 2;
        }
        if (string2.equals("Lu")) {
            vector.add(new SingleChar('\u03f4'));
        } else if (string2.equals("Ll")) {
            vector.add(new SingleChar('\u03f5'));
        } else if (string2.equals("Nl")) {
            vector.add(new CharRange(5870, 5872));
        } else if (string2.equals("No")) {
            return new Subtraction(new Union(vector), new CharRange(5870, 5872));
        }
        return new Union(vector);
    }

    private static CharClass makeCharClass(String string2) {
        Vector<SingleChar> vector = new Vector<SingleChar>();
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            vector.add(new SingleChar(string2.charAt(n)));
            ++n;
        }
        return new Union(vector);
    }

    public static void main(String[] stringArray) throws RegexSyntaxException {
        String string2 = Translator.translate(stringArray[0]);
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            char c = string2.charAt(n);
            if (c >= ' ' && c <= '~') {
                System.err.print(c);
            } else {
                System.err.print("\\u");
                int n3 = 12;
                while (n3 >= 0) {
                    System.err.print("0123456789ABCDEF".charAt(c >> n3 & 0xF));
                    n3 -= 4;
                }
            }
            ++n;
        }
        System.err.println();
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        Complement(CharClass charClass) {
            super(-charClass.getContainsBmp(), -charClass.getContainsNonBmp());
            this.cc = charClass;
        }

        void outputBmp(StringBuffer stringBuffer) {
            this.cc.outputComplementBmp(stringBuffer);
        }

        void outputComplementBmp(StringBuffer stringBuffer) {
            this.cc.outputBmp(stringBuffer);
        }

        void addNonBmpRanges(List list2) {
            Vector vector = new Vector();
            this.cc.addNonBmpRanges(vector);
            CharClass.sortRangeList(vector);
            int n = 65536;
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                Range range = (Range)vector.get(n2);
                if (range.getMin() > n) {
                    list2.add(new Range(n, range.getMin() - 1));
                }
                n = range.getMax() + 1;
                ++n2;
            }
            if (n != 0x110000) {
                list2.add(new Range(n, 0x10FFFF));
            }
        }
    }

    static class Union
    extends CharClass {
        private final List members;

        Union(CharClass[] charClassArray) {
            this(Union.toList(charClassArray));
        }

        private static List toList(CharClass[] charClassArray) {
            Vector<CharClass> vector = new Vector<CharClass>();
            int n = 0;
            while (n < charClassArray.length) {
                vector.add(charClassArray[n]);
                ++n;
            }
            return vector;
        }

        Union(List list2) {
            super(Union.computeContainsBmp(list2), Union.computeContainsNonBmp(list2));
            this.members = list2;
        }

        void outputBmp(StringBuffer stringBuffer) {
            stringBuffer.append('[');
            int n = 0;
            int n2 = this.members.size();
            while (n < n2) {
                CharClass charClass = (CharClass)this.members.get(n);
                if (charClass.getContainsBmp() != -1) {
                    if (charClass instanceof SimpleCharClass) {
                        ((SimpleCharClass)charClass).inClassOutputBmp(stringBuffer);
                    } else {
                        charClass.outputBmp(stringBuffer);
                    }
                }
                ++n;
            }
            stringBuffer.append(']');
        }

        void outputComplementBmp(StringBuffer stringBuffer) {
            boolean bl = true;
            int n = this.members.size();
            int n2 = 0;
            while (n2 < n) {
                CharClass charClass = (CharClass)this.members.get(n2);
                if (charClass.getContainsBmp() != -1 && charClass instanceof SimpleCharClass) {
                    if (bl) {
                        stringBuffer.append("[^");
                        bl = false;
                    }
                    ((SimpleCharClass)charClass).inClassOutputBmp(stringBuffer);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                CharClass charClass = (CharClass)this.members.get(n3);
                if (charClass.getContainsBmp() != -1 && !(charClass instanceof SimpleCharClass)) {
                    if (bl) {
                        stringBuffer.append('[');
                        bl = false;
                    } else {
                        stringBuffer.append("&&");
                    }
                    charClass.outputComplementBmp(stringBuffer);
                }
                ++n3;
            }
            if (bl) {
                stringBuffer.append("[\u0000-\uffff]");
            } else {
                stringBuffer.append(']');
            }
        }

        void addNonBmpRanges(List list2) {
            int n = 0;
            int n2 = this.members.size();
            while (n < n2) {
                ((CharClass)this.members.get(n)).addNonBmpRanges(list2);
                ++n;
            }
        }

        private static int computeContainsBmp(List list2) {
            int n = -1;
            int n2 = 0;
            int n3 = list2.size();
            while (n2 < n3) {
                n = Math.max(n, ((CharClass)list2.get(n2)).getContainsBmp());
                ++n2;
            }
            return n;
        }

        private static int computeContainsNonBmp(List list2) {
            int n = -1;
            int n2 = 0;
            int n3 = list2.size();
            while (n2 < n3) {
                n = Math.max(n, ((CharClass)list2.get(n2)).getContainsNonBmp());
                ++n2;
            }
            return n;
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass charClass, CharClass charClass2) {
            super(Math.min(charClass.getContainsBmp(), -charClass2.getContainsBmp()), Math.min(charClass.getContainsNonBmp(), -charClass2.getContainsNonBmp()));
            this.cc1 = charClass;
            this.cc2 = charClass2;
        }

        void outputBmp(StringBuffer stringBuffer) {
            stringBuffer.append('[');
            this.cc1.outputBmp(stringBuffer);
            stringBuffer.append("&&");
            this.cc2.outputComplementBmp(stringBuffer);
            stringBuffer.append(']');
        }

        void outputComplementBmp(StringBuffer stringBuffer) {
            stringBuffer.append('[');
            this.cc1.outputComplementBmp(stringBuffer);
            this.cc2.outputBmp(stringBuffer);
            stringBuffer.append(']');
        }

        void addNonBmpRanges(List list2) {
            Vector vector = new Vector();
            this.cc1.addNonBmpRanges(vector);
            Vector vector2 = new Vector();
            this.cc2.addNonBmpRanges(vector2);
            CharClass.sortRangeList(vector);
            CharClass.sortRangeList(vector2);
            Iterator iterator = vector2.iterator();
            Range range = iterator.hasNext() ? (Range)iterator.next() : null;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                Range range2 = (Range)vector.get(n);
                while (range != null && range.getMax() < range2.getMin()) {
                    range = iterator.hasNext() ? (Range)iterator.next() : null;
                }
                int n3 = range2.getMin();
                while (range != null && range.getMin() <= range2.getMax()) {
                    if (n3 < range.getMin()) {
                        list2.add(new Range(n3, range.getMin() - 1));
                    }
                    if ((n3 = range.getMax() + 1) > range2.getMax()) break;
                    range = iterator.hasNext() ? (Range)iterator.next() : null;
                }
                if (n3 <= range2.getMax()) {
                    list2.add(new Range(n3, range2.getMax()));
                }
                ++n;
            }
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String string2) {
            super(0, -1);
            this.name = string2;
        }

        void outputBmp(StringBuffer stringBuffer) {
            this.inClassOutputBmp(stringBuffer);
        }

        void inClassOutputBmp(StringBuffer stringBuffer) {
            stringBuffer.append("\\p{");
            stringBuffer.append(this.name);
            stringBuffer.append('}');
        }

        void outputComplementBmp(StringBuffer stringBuffer) {
            stringBuffer.append("\\P{");
            stringBuffer.append(this.name);
            stringBuffer.append('}');
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int n, int n2) {
            super(n < 65536 ? 0 : -1, n2 >= 65536 ? 0 : -1);
            this.lower = n;
            this.upper = n2;
        }

        void inClassOutputBmp(StringBuffer stringBuffer) {
            if (this.lower >= 65536) {
                throw new RuntimeException("BMP output botch");
            }
            if (Translator.isJavaMetaChar((char)this.lower)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append((char)this.lower);
            stringBuffer.append('-');
            if (this.upper < 65536) {
                if (Translator.isJavaMetaChar((char)this.upper)) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append((char)this.upper);
            } else {
                stringBuffer.append('\uffff');
            }
        }

        void addNonBmpRanges(List list2) {
            if (this.upper >= 65536) {
                list2.add(new Range(this.lower < 65536 ? 65536 : this.lower, this.upper));
            }
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
            super(-1, -1);
        }

        static Empty getInstance() {
            return instance;
        }

        void inClassOutputBmp(StringBuffer stringBuffer) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class WideSingleChar
    extends SimpleCharClass {
        private final int c;

        WideSingleChar(int n) {
            super(-1, 0);
            this.c = n;
        }

        void inClassOutputBmp(StringBuffer stringBuffer) {
            throw new RuntimeException("BMP output botch");
        }

        int singleChar() {
            return this.c;
        }

        void addNonBmpRanges(List list2) {
            list2.add(new Range(this.c, this.c));
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final char c;

        SingleChar(char c) {
            super(0, -1);
            this.c = c;
        }

        int singleChar() {
            return this.c;
        }

        void outputBmp(StringBuffer stringBuffer) {
            this.inClassOutputBmp(stringBuffer);
        }

        void inClassOutputBmp(StringBuffer stringBuffer) {
            if (Translator.isJavaMetaChar(this.c)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(this.c);
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass(int n, int n2) {
            super(n, n2);
        }

        void outputBmp(StringBuffer stringBuffer) {
            stringBuffer.append('[');
            this.inClassOutputBmp(stringBuffer);
            stringBuffer.append(']');
        }

        void outputComplementBmp(StringBuffer stringBuffer) {
            if (this.getContainsBmp() == -1) {
                stringBuffer.append("[\u0000-\uffff]");
            } else {
                stringBuffer.append("[^");
                this.inClassOutputBmp(stringBuffer);
                stringBuffer.append(']');
            }
        }

        abstract void inClassOutputBmp(StringBuffer var1);
    }

    static abstract class CharClass {
        private final int containsBmp;
        private final int containsNonBmp;

        protected CharClass(int n, int n2) {
            this.containsBmp = n;
            this.containsNonBmp = n2;
        }

        int getContainsBmp() {
            return this.containsBmp;
        }

        int getContainsNonBmp() {
            return this.containsNonBmp;
        }

        final void output(StringBuffer stringBuffer) {
            switch (this.containsNonBmp) {
                case -1: {
                    if (this.containsBmp == -1) {
                        stringBuffer.append(Translator.NOT_ALLOWED_CLASS);
                        break;
                    }
                    this.outputBmp(stringBuffer);
                    break;
                }
                case 1: {
                    stringBuffer.append('(');
                    if (this.containsBmp == -1) {
                        stringBuffer.append(Translator.SURROGATES1_CLASS);
                        stringBuffer.append(Translator.SURROGATES2_CLASS);
                    } else {
                        this.outputBmp(stringBuffer);
                        stringBuffer.append(Translator.SURROGATES2_CLASS);
                        stringBuffer.append('?');
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 0: {
                    char c;
                    int n;
                    int n2;
                    stringBuffer.append('(');
                    boolean bl = false;
                    if (this.containsBmp != -1) {
                        bl = true;
                        this.outputBmp(stringBuffer);
                    }
                    Vector vector = new Vector();
                    this.addNonBmpRanges(vector);
                    CharClass.sortRangeList(vector);
                    String string2 = CharClass.highSurrogateRanges(vector);
                    if (string2.length() > 0) {
                        if (bl) {
                            stringBuffer.append('|');
                        } else {
                            bl = true;
                        }
                        stringBuffer.append('[');
                        int n3 = 0;
                        n2 = string2.length();
                        while (n3 < n2) {
                            n = string2.charAt(n3);
                            if (n == (c = string2.charAt(n3 + 1))) {
                                stringBuffer.append((char)n);
                            } else {
                                stringBuffer.append((char)n);
                                stringBuffer.append('-');
                                stringBuffer.append(c);
                            }
                            n3 += 2;
                        }
                        stringBuffer.append(']');
                        stringBuffer.append(Translator.SURROGATES2_CLASS);
                    }
                    String string3 = CharClass.lowSurrogateRanges(vector);
                    n2 = 0;
                    n = string3.length();
                    while (n2 < n) {
                        if (bl) {
                            stringBuffer.append('|');
                        } else {
                            bl = true;
                        }
                        stringBuffer.append(string3.charAt(n2));
                        c = string3.charAt(n2 + 1);
                        char c2 = string3.charAt(n2 + 2);
                        if (c == c2 && (n2 + 3 >= n || string3.charAt(n2 + 3) != string3.charAt(n2))) {
                            stringBuffer.append(c);
                        } else {
                            stringBuffer.append('[');
                            while (true) {
                                if (c == c2) {
                                    stringBuffer.append(c);
                                } else {
                                    stringBuffer.append(c);
                                    stringBuffer.append('-');
                                    stringBuffer.append(c2);
                                }
                                if (n2 + 3 >= n || string3.charAt(n2 + 3) != string3.charAt(n2)) break;
                                c = string3.charAt((n2 += 3) + 1);
                                c2 = string3.charAt(n2 + 2);
                            }
                            stringBuffer.append(']');
                        }
                        n2 += 3;
                    }
                    if (!bl) {
                        stringBuffer.append(Translator.NOT_ALLOWED_CLASS);
                    }
                    stringBuffer.append(')');
                }
            }
        }

        static String highSurrogateRanges(List list2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                Range range = (Range)list2.get(n);
                char c = Utf16.surrogate1(range.getMin());
                char c2 = Utf16.surrogate2(range.getMin());
                char c3 = Utf16.surrogate1(range.getMax());
                char c4 = Utf16.surrogate2(range.getMax());
                if (c2 != '\udc00') {
                    c = (char)(c + '\u0001');
                }
                if (c4 != '\udfff') {
                    c3 = (char)(c3 - '\u0001');
                }
                if (c3 >= c) {
                    stringBuffer.append(c);
                    stringBuffer.append(c3);
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        static String lowSurrogateRanges(List list2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                Range range = (Range)list2.get(n);
                char c = Utf16.surrogate1(range.getMin());
                char c2 = Utf16.surrogate2(range.getMin());
                char c3 = Utf16.surrogate1(range.getMax());
                char c4 = Utf16.surrogate2(range.getMax());
                if (c == c3) {
                    if (c2 != '\udc00' || c4 != '\udfff') {
                        stringBuffer.append(c);
                        stringBuffer.append(c2);
                        stringBuffer.append(c4);
                    }
                } else {
                    if (c2 != '\udc00') {
                        stringBuffer.append(c);
                        stringBuffer.append(c2);
                        stringBuffer.append('\udfff');
                    }
                    if (c4 != '\udfff') {
                        stringBuffer.append(c3);
                        stringBuffer.append('\udc00');
                        stringBuffer.append(c4);
                    }
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        abstract void outputBmp(StringBuffer var1);

        abstract void outputComplementBmp(StringBuffer var1);

        int singleChar() {
            return -1;
        }

        void addNonBmpRanges(List list2) {
        }

        static void sortRangeList(List list2) {
            Collections.sort(list2);
            int n = 0;
            int n2 = 0;
            int n3 = list2.size();
            while (n2 < n3) {
                Range range = (Range)list2.get(n2);
                int n4 = range.getMin();
                int n5 = range.getMax();
                while (++n2 < n3) {
                    Range range2 = (Range)list2.get(n2);
                    if (range2.getMin() > n5 + 1) break;
                    if (range2.getMax() <= n5) continue;
                    n5 = range2.getMax();
                }
                if (n5 != range.getMax()) {
                    range = new Range(n4, n5);
                }
                list2.set(n++, range);
            }
            while (n3 > n) {
                list2.remove(--n3);
            }
        }
    }

    static final class Range
    implements Comparable {
        private final int min;
        private final int max;

        Range(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        int getMin() {
            return this.min;
        }

        int getMax() {
            return this.max;
        }

        public int compareTo(Object object) {
            Range range = (Range)object;
            if (this.min < range.min) {
                return -1;
            }
            if (this.min > range.min) {
                return 1;
            }
            if (this.max > range.max) {
                return -1;
            }
            if (this.max < range.max) {
                return 1;
            }
            return 0;
        }
    }
}

