/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.PlusMinus;
import com.intellij.openapi.vcs.changes.ui.VirtualFileListCellRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectionManager;
import com.intellij.util.treeWithCheckedNodes.TreeNodeState;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsStructureChooser
extends DialogWrapper {
    private static final int MAX_FOLDERS = 100;
    public static final Border BORDER = IdeBorderFactory.createBorder((int)3);
    @NonNls
    private static final String VCS_STRUCTURE_CHOOSER_KEY = "git4idea.history.wholeTree.VcsStructureChooser";
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<VirtualFile> myRoots;
    private final @NotNull Map<VirtualFile, @Nls String> myModulesSet;
    @NotNull
    private final Set<VirtualFile> mySelectedFiles;
    @NotNull
    private final SelectionManager mySelectionManager;
    private Tree myTree;

    public VcsStructureChooser(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull Collection<VirtualFile> initialSelection, @NotNull List<VirtualFile> roots) {
        if (project2 == null) {
            VcsStructureChooser.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            VcsStructureChooser.$$$reportNull$$$0(1);
        }
        if (initialSelection == null) {
            VcsStructureChooser.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            VcsStructureChooser.$$$reportNull$$$0(3);
        }
        super(project2, true);
        this.mySelectedFiles = new HashSet<VirtualFile>();
        this.setTitle(title2);
        this.myProject = project2;
        this.myRoots = roots;
        this.mySelectionManager = new SelectionManager(100, 500, MyNodeConverter.getInstance());
        this.myModulesSet = this.calculateModules(roots);
        this.init();
        this.mySelectionManager.setSelection(initialSelection);
        this.checkEmpty();
    }

    private @NotNull Map<VirtualFile, @Nls String> calculateModules(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            VcsStructureChooser.$$$reportNull$$$0(4);
        }
        HashMap<VirtualFile, @Nls String> result2 = new HashMap<VirtualFile, String>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = (Module[])ReadAction.compute(() -> moduleManager.getModules());
        TreeSet<VirtualFile> checkSet = new TreeSet<VirtualFile>(FilePathComparator.getInstance());
        checkSet.addAll(roots);
        for (Module module : modules) {
            VirtualFile[] files2;
            if (ModuleType.isInternal((Module)module)) continue;
            for (VirtualFile file : files2 = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                VirtualFile floor = checkSet.floor(file);
                if (floor == null) continue;
                result2.put(file, module.getName());
            }
        }
        HashMap<VirtualFile, String> hashMap = result2;
        if (hashMap == null) {
            VcsStructureChooser.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    public Collection<VirtualFile> getSelectedFiles() {
        Set<VirtualFile> set = this.mySelectedFiles;
        if (set == null) {
            VcsStructureChooser.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void checkEmpty() {
        this.setOKActionEnabled(!this.mySelectedFiles.isEmpty());
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return VCS_STRUCTURE_CHOOSER_KEY;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree2 = this.myTree;
        if (tree2 == null) {
            VcsStructureChooser.$$$reportNull$$$0(7);
        }
        return tree2;
    }

    protected JComponent createCenterPanel() {
        this.myTree = new Tree();
        this.myTree.setBorder(BORDER);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setExpandableItemsEnabled(false);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                if (VcsStructureChooser.this.myRoots.contains(file)) {
                    return false;
                }
                ChangeListManager changeListManager = ChangeListManager.getInstance(VcsStructureChooser.this.myProject);
                return !changeListManager.isIgnoredFile(file) && !changeListManager.isUnversioned(file);
            }
        };
        descriptor.withRoots(new ArrayList<VirtualFile>(this.myRoots)).withShowHiddenFiles(true).withHideIgnored(true);
        final MyCheckboxTreeCellRenderer cellRenderer = new MyCheckboxTreeCellRenderer(this.mySelectionManager, this.myModulesSet, this.myProject, (JTree)this.myTree, this.myRoots);
        FileSystemTreeImpl fileSystemTree = new FileSystemTreeImpl(this.myProject, descriptor, this.myTree, cellRenderer, null, o -> {
            DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)o.getLastPathComponent();
            Object uo = lastPathComponent.getUserObject();
            if (uo instanceof FileNodeDescriptor) {
                VirtualFile file = ((FileNodeDescriptor)uo).getElement().getFile();
                String module = this.myModulesSet.get(file);
                if (module != null) {
                    return module;
                }
                return file == null ? "" : file.getName();
            }
            return o.toString();
        }){

            protected Comparator<? super NodeDescriptor<?>> getFileComparator() {
                return (o1, o2) -> {
                    if (o1 instanceof FileNodeDescriptor && o2 instanceof FileNodeDescriptor) {
                        boolean isDir2;
                        VirtualFile f1 = ((FileNodeDescriptor)o1).getElement().getFile();
                        VirtualFile f2 = ((FileNodeDescriptor)o2).getElement().getFile();
                        boolean isDir1 = f1.isDirectory();
                        if (isDir1 != (isDir2 = f2.isDirectory())) {
                            return isDir1 ? -1 : 1;
                        }
                        return f1.getPath().compareToIgnoreCase(f2.getPath());
                    }
                    return o1.getIndex() - o2.getIndex();
                };
            }
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int row2;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((row2 = VcsStructureChooser.this.myTree.getRowForLocation(e.getX(), e.getY())) < 0) {
                    return false;
                }
                Object o = VcsStructureChooser.this.myTree.getPathForRow(row2).getLastPathComponent();
                if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                    return false;
                }
                Rectangle rowBounds = VcsStructureChooser.this.myTree.getRowBounds(row2);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint())) {
                    VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$3", "onClick"));
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath[] paths = VcsStructureChooser.this.myTree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    for (TreePath path2 : paths) {
                        if (path2 == null) continue;
                        Object o = path2.getLastPathComponent();
                        if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                            return;
                        }
                        VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    }
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                    e.consume();
                }
            }
        });
        JBPanel panel2 = new JBPanel((LayoutManager)new BorderLayout());
        panel2.add((Component)new JBScrollPane((Component)fileSystemTree.getTree()), (Object)"Center");
        final JLabel selectedLabel = new JLabel("");
        selectedLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        panel2.add((Component)selectedLabel, (Object)"South");
        this.mySelectionManager.setSelectionChangeListener((PlusMinus<? super VirtualFile>)new PlusMinus<VirtualFile>(){

            @Override
            public void plus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.add(virtualFile);
                this.recalculateErrorText();
            }

            private void recalculateErrorText() {
                VcsStructureChooser.this.checkEmpty();
                if (VcsStructureChooser.this.mySelectionManager.canAddSelection()) {
                    selectedLabel.setText("");
                } else {
                    HtmlChunk.Element errorText = HtmlChunk.text((String)("(" + VcsLogBundle.message("vcs.log.filters.structure.max.selected.error.message", 100) + ")")).wrapWith(HtmlChunk.tag((String)"font").attr("color", "red"));
                    selectedLabel.setText(new HtmlBuilder().appendRaw(VcsLogBundle.message("vcs.log.filters.structure.label", errorText)).wrapWith(HtmlChunk.html()).toString());
                }
                selectedLabel.revalidate();
            }

            @Override
            public void minus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.remove(virtualFile);
                this.recalculateErrorText();
            }
        });
        panel2.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        return panel2;
    }

    @NotNull
    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            VcsStructureChooser.$$$reportNull$$$0(8);
        }
        return defaultMutableTreeNode;
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Object node) {
        Object object;
        if (node == null) {
            VcsStructureChooser.$$$reportNull$$$0(9);
        }
        if (!((object = ((DefaultMutableTreeNode)node).getUserObject()) instanceof FileNodeDescriptor)) {
            return null;
        }
        FileNodeDescriptor descriptor = (FileNodeDescriptor)object;
        if (descriptor.getElement().getFile() == null) {
            return null;
        }
        return descriptor.getElement().getFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSelection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateModules";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 7, 8 -> new IllegalStateException(string2);
        };
    }

    private static class MyNodeConverter
    implements Convertor<DefaultMutableTreeNode, VirtualFile> {
        @NotNull
        private static final MyNodeConverter ourInstance = new MyNodeConverter();

        private MyNodeConverter() {
        }

        @NotNull
        public static MyNodeConverter getInstance() {
            MyNodeConverter myNodeConverter = ourInstance;
            if (myNodeConverter == null) {
                MyNodeConverter.$$$reportNull$$$0(0);
            }
            return myNodeConverter;
        }

        public VirtualFile convert(DefaultMutableTreeNode o) {
            return ((FileNodeDescriptor)o.getUserObject()).getElement().getFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyNodeConverter", "getInstance"));
        }
    }

    private static final class MyCheckboxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        @NotNull
        private final WithModulesListCellRenderer myTextRenderer;
        @NotNull
        public final JCheckBox myCheckbox;
        @NotNull
        private final SelectionManager mySelectionManager;
        private final @NotNull Map<VirtualFile, @Nls String> myModulesSet;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final ColoredTreeCellRenderer myColoredRenderer;
        @NotNull
        private final JLabel myEmpty;
        @NotNull
        private final JList myFictive;

        private MyCheckboxTreeCellRenderer(@NotNull SelectionManager selectionManager, @NotNull Map<VirtualFile, @Nls String> modulesSet, @NotNull Project project2, @NotNull JTree tree2, @NotNull Collection<VirtualFile> roots) {
            if (selectionManager == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (modulesSet == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(1);
            }
            if (project2 == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(2);
            }
            if (tree2 == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(3);
            }
            if (roots == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(4);
            }
            super(new BorderLayout());
            this.mySelectionManager = selectionManager;
            this.myModulesSet = modulesSet;
            this.myRoots = roots;
            this.setBackground(RenderingUtil.getBackground((JTree)tree2));
            this.myColoredRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                    if (tree2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.append(value2.toString());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer$1", "customizeCellRenderer"));
                }
            };
            this.myFictive = new JBList();
            this.myFictive.setBackground(RenderingUtil.getBackground((JTree)tree2));
            this.myFictive.setSelectionBackground(UIUtil.getListSelectionBackground((boolean)true));
            this.myFictive.setSelectionForeground(NamedColorUtil.getListSelectionForeground((boolean)true));
            this.myTextRenderer = new WithModulesListCellRenderer(project2, this.myModulesSet){

                @Override
                protected void putParentPath(Object value2, FilePath path2, FilePath self) {
                    if (myRoots.contains(self.getVirtualFile())) {
                        super.putParentPath(value2, path2, self);
                    }
                }
            };
            this.myTextRenderer.setBackground(RenderingUtil.getBackground((JTree)tree2));
            this.myCheckbox = new JCheckBox();
            this.myCheckbox.setBackground(RenderingUtil.getBackground((JTree)tree2));
            this.myEmpty = new JLabel("");
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.myCheckbox.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            this.invalidate();
            if (value2 == null) {
                return this.myEmpty;
            }
            VirtualFile file = VcsStructureChooser.getFile(value2);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            if (file == null) {
                Object uo = node.getUserObject();
                if (uo instanceof String) {
                    this.myColoredRenderer.getTreeCellRendererComponent(tree2, (Object)node, selected, expanded, leaf, row2, hasFocus);
                    return this.myColoredRenderer;
                }
                return this.myEmpty;
            }
            this.myCheckbox.setVisible(true);
            TreeNodeState state = this.mySelectionManager.getState(node);
            this.myCheckbox.setEnabled(TreeNodeState.CLEAR.equals((Object)state) || TreeNodeState.SELECTED.equals((Object)state));
            this.myCheckbox.setSelected(!TreeNodeState.CLEAR.equals((Object)state));
            this.myCheckbox.setOpaque(false);
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            this.myTextRenderer.getListCellRendererComponent(this.myFictive, file, 0, selected, hasFocus);
            this.revalidate();
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectionManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modulesSet";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WithModulesListCellRenderer
    extends VirtualFileListCellRenderer {
        private final @NotNull Map<VirtualFile, @Nls String> myModules;

        private WithModulesListCellRenderer(@NotNull Project project2, @NotNull Map<VirtualFile, @Nls String> modules) {
            if (project2 == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(0);
            }
            if (modules == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(1);
            }
            super(project2, true);
            this.myModules = modules;
        }

        @Override
        protected String getName(@NotNull FilePath path2) {
            String module;
            if (path2 == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(2);
            }
            if ((module = this.myModules.get(path2.getVirtualFile())) != null) {
                return module;
            }
            return super.getName(path2);
        }

        @Override
        protected void renderIcon(@NotNull FilePath path2) {
            String module;
            if (path2 == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(3);
            }
            if ((module = this.myModules.get(path2.getVirtualFile())) != null) {
                this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
            } else if (path2.isDirectory()) {
                this.setIcon(PlatformIcons.FOLDER_ICON);
            } else {
                this.setIcon(VcsUtil.getIcon(this.myProject, path2));
            }
        }

        @Override
        protected void putParentPathImpl(@NotNull Object value2, @NotNull String parentPath, @NotNull FilePath self) {
            if (value2 == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(4);
            }
            if (parentPath == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(5);
            }
            if (self == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(6);
            }
            this.append(self.getPath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "self";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderIcon";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putParentPathImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

