/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.VcsLogPopupComponent;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterPopupComponent<Filter, Model extends FilterModel<Filter>>
extends VcsLogPopupComponent {
    protected static final Supplier<@Nls String> EMPTY_FILTER_TEXT = () -> "";
    protected static final Supplier<@Nls String> ALL_ACTION_TEXT = VcsLogBundle.messagePointer("vcs.log.filter.all", new Object[0]);
    @NotNull
    protected final Model myFilterModel;

    FilterPopupComponent(@NotNull @NotNull Supplier<@NlsContexts.Label @NotNull String> displayName, @NotNull Model filterModel) {
        if (displayName == null) {
            FilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (filterModel == null) {
            FilterPopupComponent.$$$reportNull$$$0(1);
        }
        super(displayName);
        this.myFilterModel = filterModel;
    }

    @Override
    @NotNull
    public String getCurrentText() {
        Object filter2 = ((FilterModel)this.myFilterModel).getFilter();
        String string2 = filter2 == null ? this.getEmptyFilterValue() : this.getText(filter2);
        if (string2 == null) {
            FilterPopupComponent.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @Nls
    @NotNull
    public String getEmptyFilterValue() {
        String string2 = EMPTY_FILTER_TEXT.get();
        if (string2 == null) {
            FilterPopupComponent.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    protected boolean isValueSelected() {
        return ((FilterModel)this.myFilterModel).getFilter() != null;
    }

    @Override
    public void installChangeListener(@NotNull Runnable onChange) {
        if (onChange == null) {
            FilterPopupComponent.$$$reportNull$$$0(4);
        }
        ((FilterModel)this.myFilterModel).addSetFilterListener(onChange);
    }

    @NotNull
    @Nls
    protected abstract String getText(@NotNull Filter var1);

    @Nullable
    @NlsContexts.Tooltip
    protected abstract String getToolTip(@NotNull Filter var1);

    @NlsContexts.Tooltip
    public String getToolTipText() {
        Object filter2 = ((FilterModel)this.myFilterModel).getFilter();
        return filter2 == null ? null : this.getToolTip(filter2);
    }

    @Override
    protected Runnable createResetAction() {
        return () -> {
            ((FilterModel)this.myFilterModel).setFilter(null);
            VcsLogUsageTriggerCollector.triggerFilterReset(VcsLogUsageTriggerCollector.FilterResetType.CLOSE_BUTTON);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/FilterPopupComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/FilterPopupComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyFilterValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installChangeListener";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

