/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print.elements;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.printer.PrintElementPresentationManager;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import org.jetbrains.annotations.NotNull;

public class EdgePrintElementImpl
extends PrintElementWithGraphElement
implements EdgePrintElement {
    @NotNull
    private final EdgePrintElement.Type myType;
    @NotNull
    private final EdgePrintElement.LineStyle myLineStyle;
    private final int myPositionInOtherRow;
    private final boolean myHasArrow;

    @NotNull
    public static EdgePrintElement.LineStyle convertToLineStyle(@NotNull GraphEdgeType edgeType) {
        if (edgeType == null) {
            EdgePrintElementImpl.$$$reportNull$$$0(0);
        }
        EdgePrintElement.LineStyle lineStyle = switch (edgeType) {
            default -> throw new IncompatibleClassChangeError();
            case GraphEdgeType.USUAL, GraphEdgeType.NOT_LOAD_COMMIT -> EdgePrintElement.LineStyle.SOLID;
            case GraphEdgeType.DOTTED, GraphEdgeType.DOTTED_ARROW_UP, GraphEdgeType.DOTTED_ARROW_DOWN -> EdgePrintElement.LineStyle.DASHED;
        };
        if (lineStyle == null) {
            EdgePrintElementImpl.$$$reportNull$$$0(1);
        }
        return lineStyle;
    }

    public EdgePrintElementImpl(int rowIndex, int positionInCurrentRow, int positionInOtherRow, @NotNull EdgePrintElement.Type type2, @NotNull GraphEdge graphEdge, boolean hasArrow, @NotNull PrintElementPresentationManager presentationManager) {
        if (type2 == null) {
            EdgePrintElementImpl.$$$reportNull$$$0(2);
        }
        if (graphEdge == null) {
            EdgePrintElementImpl.$$$reportNull$$$0(3);
        }
        if (presentationManager == null) {
            EdgePrintElementImpl.$$$reportNull$$$0(4);
        }
        super(rowIndex, positionInCurrentRow, graphEdge, presentationManager);
        this.myType = type2;
        this.myLineStyle = EdgePrintElementImpl.convertToLineStyle(graphEdge.getType());
        this.myPositionInOtherRow = positionInOtherRow;
        this.myHasArrow = hasArrow;
    }

    @Override
    public int getPositionInOtherRow() {
        return this.myPositionInOtherRow;
    }

    @Override
    @NotNull
    public EdgePrintElement.Type getType() {
        EdgePrintElement.Type type2 = this.myType;
        if (type2 == null) {
            EdgePrintElementImpl.$$$reportNull$$$0(5);
        }
        return type2;
    }

    @Override
    @NotNull
    public EdgePrintElement.LineStyle getLineStyle() {
        EdgePrintElement.LineStyle lineStyle = this.myLineStyle;
        if (lineStyle == null) {
            EdgePrintElementImpl.$$$reportNull$$$0(6);
        }
        return lineStyle;
    }

    @Override
    public boolean hasArrow() {
        return this.myHasArrow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgePrintElement)) {
            return false;
        }
        EdgePrintElement that = (EdgePrintElement)o;
        if (this.myPositionInCurrentRow != that.getPositionInCurrentRow()) {
            return false;
        }
        if (this.myPositionInOtherRow != that.getPositionInOtherRow()) {
            return false;
        }
        if (this.myRowIndex != that.getRowIndex()) {
            return false;
        }
        if (this.myType != that.getType()) {
            return false;
        }
        return this.myHasArrow == that.hasArrow();
    }

    public int hashCode() {
        int result2 = this.myRowIndex;
        result2 = 31 * result2 + this.myPositionInCurrentRow;
        result2 = 31 * result2 + this.myPositionInOtherRow;
        result2 = 37 * result2 + this.myType.hashCode();
        result2 = 31 * result2 + (this.myHasArrow ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeType";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphEdge";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToLineStyle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToLineStyle";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

