/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeChildInvocationHandler
extends DomInvocationHandler {
    private static final Logger LOG = Logger.getInstance(AttributeChildInvocationHandler.class);

    protected AttributeChildInvocationHandler(EvaluatedXmlName attributeName, AttributeChildDescriptionImpl description2, DomManagerImpl manager, DomParentStrategy strategy, @Nullable AttributeStub stub) {
        super(description2.getType(), strategy, attributeName, description2, manager, false, stub);
    }

    @Override
    public void acceptChildren(DomElementVisitor visitor) {
    }

    @Override
    protected final XmlTag setEmptyXmlTag() {
        return this.ensureTagExists();
    }

    @Override
    protected boolean isAttribute() {
        return true;
    }

    @Override
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler parent) {
        if (parent == null) {
            AttributeChildInvocationHandler.$$$reportNull$$$0(0);
        }
        if (!parent.isValid()) {
            return null;
        }
        XmlTag tag = parent.getXmlTag();
        if (tag == null) {
            return null;
        }
        return tag.getAttribute(this.getXmlElementName(), this.getXmlApiCompatibleNamespace(parent));
    }

    @Nullable
    private String getXmlApiCompatibleNamespace(DomInvocationHandler parent) {
        XmlTag tag = parent.getXmlTag();
        if (tag == null) {
            return null;
        }
        String ns = this.getXmlName().getNamespace(tag, parent.getFile());
        return tag.getNamespace().equals(ns) ? null : ns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XmlAttribute ensureXmlElementExists() {
        XmlAttribute attribute = (XmlAttribute)this.getXmlElement();
        if (attribute != null) {
            return attribute;
        }
        DomManagerImpl manager = this.getManager();
        boolean b = manager.setChanging(true);
        try {
            attribute = this.ensureTagExists().setAttribute(this.getXmlElementName(), this.getXmlApiCompatibleNamespace(this.getParentHandler()), "");
            this.setXmlElement(attribute);
            DomElement element = this.getProxy();
            manager.fireEvent(new DomEvent(element, true));
            XmlAttribute xmlAttribute = attribute;
            return xmlAttribute;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            XmlAttribute xmlAttribute = null;
            return xmlAttribute;
        }
        finally {
            manager.setChanging(b);
        }
    }

    @Override
    public <T extends DomElement> T createStableCopy() {
        Object parentCopy = this.getParent().createStableCopy();
        return this.getManager().createStableValue(() -> parentCopy.isValid() ? this.getChildDescription().getValues((DomElement)parentCopy).get(0) : null);
    }

    @Override
    public final void undefineInternal() {
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            this.getManager().runChange(() -> {
                try {
                    this.setXmlElement(null);
                    tag.setAttribute(this.getXmlElementName(), this.getXmlApiCompatibleNamespace(this.getParentHandler()), null);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            this.fireUndefinedEvent();
        }
    }

    @Override
    @Nullable
    public final XmlTag getXmlTag() {
        DomInvocationHandler handler2 = this.getParentHandler();
        return handler2 == null ? null : handler2.getXmlTag();
    }

    @Override
    public final XmlTag ensureTagExists() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        return parent.ensureTagExists();
    }

    @Override
    @Nullable
    protected String getValue() {
        XmlAttributeValue value2;
        if (this.myStub != null) {
            return ((AttributeStub)this.myStub).getValue();
        }
        XmlAttribute attribute = (XmlAttribute)this.getXmlElement();
        if (attribute != null && (value2 = attribute.getValueElement()) != null && value2.getTextLength() >= 2) {
            return attribute.getDisplayValue();
        }
        return null;
    }

    @Override
    protected void setValue(@Nullable String value2) {
        String newValue;
        String namespace;
        String attributeName;
        XmlTag tag = this.ensureTagExists();
        String tagValue = tag.getAttributeValue(attributeName = this.getXmlElementName(), namespace = this.getXmlApiCompatibleNamespace(this.getParentHandler()));
        String oldValue = tagValue == null ? null : StringUtil.unescapeXmlEntities((String)tagValue);
        if (Comparing.equal((String)oldValue, (String)(newValue = XmlStringUtil.escapeString((String)value2)), (boolean)true)) {
            return;
        }
        this.getManager().runChange(() -> {
            try {
                this.setXmlElement(tag.setAttribute(attributeName, namespace, newValue));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
        DomElement proxy = this.getProxy();
        this.getManager().fireEvent(oldValue != null ? new DomEvent(proxy, false) : new DomEvent(proxy, true));
    }

    @Override
    public void copyFrom(DomElement other) {
        this.setValue(((GenericAttributeValue)other).getStringValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/AttributeChildInvocationHandler", "recomputeXmlElement"));
    }
}

