/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class OptimizingSearchHelperBase
implements OptimizingSearchHelper {
    private final Set<String> scanned = new HashSet<String>();
    private final Set<String> scannedText = new HashSet<String>();
    private final Set<String> scannedComments = new HashSet<String>();
    private final Set<String> scannedLiterals = new HashSet<String>();
    protected int scanRequest;

    OptimizingSearchHelperBase() {
    }

    @Override
    public void clear() {
        this.scanned.clear();
        this.scannedText.clear();
        this.scannedComments.clear();
        this.scannedLiterals.clear();
    }

    @Override
    public void addWordToSearchInCode(@NotNull String word) {
        if (word == null) {
            OptimizingSearchHelperBase.$$$reportNull$$$0(0);
        }
        if (this.doOptimizing() && this.scanned.add(word)) {
            this.doAddSearchWordInCode(word);
        }
    }

    @Override
    public void addWordToSearchInText(@NotNull String word) {
        if (word == null) {
            OptimizingSearchHelperBase.$$$reportNull$$$0(1);
        }
        if (this.doOptimizing() && this.scannedText.add(word)) {
            this.doAddSearchWordInText(word);
        }
    }

    @Override
    public void addWordToSearchInComments(@NotNull String word) {
        if (word == null) {
            OptimizingSearchHelperBase.$$$reportNull$$$0(2);
        }
        if (this.doOptimizing() && this.scannedComments.add(word)) {
            this.doAddSearchWordInComments(word);
        }
    }

    @Override
    public void addWordToSearchInLiterals(@NotNull String word) {
        if (word == null) {
            OptimizingSearchHelperBase.$$$reportNull$$$0(3);
        }
        if (this.doOptimizing() && this.scannedLiterals.add(word)) {
            this.doAddSearchWordInLiterals(word);
        }
    }

    protected abstract void doAddSearchWordInCode(@NotNull String var1);

    protected abstract void doAddSearchWordInText(@NotNull String var1);

    protected abstract void doAddSearchWordInComments(@NotNull String var1);

    protected abstract void doAddSearchWordInLiterals(@NotNull String var1);

    @Override
    public void endTransaction() {
        ++this.scanRequest;
    }

    @Override
    public boolean isScannedSomething() {
        return !this.scanned.isEmpty() || !this.scannedText.isEmpty() || !this.scannedComments.isEmpty() || !this.scannedLiterals.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "word";
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/OptimizingSearchHelperBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addWordToSearchInCode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addWordToSearchInText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addWordToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addWordToSearchInLiterals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

