/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsCacheManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsDirectoryMappingStorage;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOption;
import com.intellij.openapi.vcs.impl.projectlevelman.ProjectLevelVcsManagerSerialization;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcs.console.VcsConsoleTabService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="ProjectLevelVcsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectLevelVcsManagerImpl.class);
    @NonNls
    private static final String SETTINGS_EDITED_MANUALLY = "settingsEditedManually";
    private final OptionsAndConfirmations myOptionsAndConfirmations;
    private final NewMappings myMappings;
    private final Project myProject;
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_PROJECT = "defaultProject";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private boolean myMappingsLoaded;
    private boolean myHaveLegacyVcsConfiguration;
    @NotNull
    private final AtomicInteger myBackgroundOperationCounter;
    private final Set<ActionKey> myBackgroundRunningTasks;
    private final FileIndexFacade myExcludedIndex;

    public ProjectLevelVcsManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(0);
        }
        this.myBackgroundOperationCounter = new AtomicInteger();
        this.myBackgroundRunningTasks = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project2;
        this.myExcludedIndex = FileIndexFacade.getInstance((Project)project2);
        this.myOptionsAndConfirmations = new OptionsAndConfirmations();
        this.myMappings = new NewMappings(this.myProject, this);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myMappings);
    }

    public static ProjectLevelVcsManagerImpl getInstanceImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(1);
        }
        return (ProjectLevelVcsManagerImpl)ProjectLevelVcsManagerImpl.getInstance(project2);
    }

    @TestOnly
    public void registerVcs(AbstractVcs vcs) {
        AllVcses.getInstance(this.myProject).registerManually(vcs);
    }

    @Override
    @Nullable
    public AbstractVcs findVcsByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        AbstractVcs vcs = AllVcses.getInstance(this.myProject).getByName(name);
        if (vcs == null && this.myProject.isDisposed()) {
            ReadAction.run(ProgressManager::checkCanceled);
        }
        return vcs;
    }

    @Override
    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getDescriptor(name);
    }

    @Override
    public void iterateVfUnderVcsRoot(VirtualFile file, Processor<? super VirtualFile> processor2) {
        VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, file, processor2);
    }

    @Override
    public VcsDescriptor[] getAllVcss() {
        return AllVcses.getInstance(this.myProject).getAll();
    }

    @Override
    public AbstractVcs @NotNull [] getAllSupportedVcss() {
        AbstractVcs[] abstractVcsArray = AllVcses.getInstance(this.myProject).getSupportedVcses();
        if (abstractVcsArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(2);
        }
        return abstractVcsArray;
    }

    public boolean haveVcses() {
        return !AllVcses.getInstance(this.myProject).isEmpty();
    }

    @Override
    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        VcsAnnotationLocalChangesListener vcsAnnotationLocalChangesListener = (VcsAnnotationLocalChangesListener)this.myProject.getService(VcsAnnotationLocalChangesListener.class);
        if (vcsAnnotationLocalChangesListener == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(3);
        }
        return vcsAnnotationLocalChangesListener;
    }

    @Override
    public boolean checkAllFilesAreUnder(AbstractVcs abstractVcs, VirtualFile[] files2) {
        if (files2 == null) {
            return false;
        }
        for (VirtualFile file : files2) {
            if (this.getVcsFor(file) == abstractVcs) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getShortNameForVcsRoot(@NotNull VirtualFile root) {
        String relativePath;
        String shortName;
        if (root == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(4);
        }
        if ((shortName = this.myMappings.getShortNameFor(root)) != null) {
            String string2 = shortName;
            if (string2 == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(5);
            }
            return string2;
        }
        VirtualFile projectDir = this.myProject.getBaseDir();
        String string3 = relativePath = projectDir != null ? VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar) : null;
        if (relativePath != null) {
            String string4 = relativePath.isEmpty() ? root.getName() : relativePath;
            if (string4 == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(6);
            }
            return string4;
        }
        String string5 = root.getPresentableUrl();
        if (string5 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(7);
        }
        return string5;
    }

    @Override
    @Nullable
    public AbstractVcs getVcsFor(@Nullable VirtualFile file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Override
    @Nullable
    public AbstractVcs getVcsFor(@Nullable FilePath file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    @Override
    @Nullable
    public VcsRoot getVcsRootObjectFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    @Override
    public VcsRoot getVcsRootObjectFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    @TestOnly
    public void unregisterVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(8);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myMappings.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.myMappings.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.myProject).unregisterManually(vcs);
    }

    @Override
    @Nullable
    public ContentManager getContentManager() {
        ToolWindow changes = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        return changes == null ? null : changes.getContentManager();
    }

    @Override
    public boolean checkVcsIsActive(AbstractVcs vcs) {
        return this.checkVcsIsActive(vcs.getName());
    }

    @Override
    public boolean checkVcsIsActive(String vcsName) {
        return this.myMappings.haveActiveVcs(vcsName);
    }

    @Override
    public AbstractVcs @NotNull [] getAllActiveVcss() {
        AbstractVcs[] abstractVcsArray = this.myMappings.getActiveVcses();
        if (abstractVcsArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(9);
        }
        return abstractVcsArray;
    }

    @Override
    @Nullable
    public AbstractVcs getSingleVCS() {
        AbstractVcs[] vcses = this.getAllActiveVcss();
        return vcses.length == 1 ? vcses[0] : null;
    }

    @Override
    public boolean hasActiveVcss() {
        return this.myMappings.hasActiveVcss();
    }

    @Override
    public boolean areVcsesActivated() {
        return this.myMappings.isActivated();
    }

    @Override
    public boolean hasAnyMappings() {
        return !this.myMappings.isEmpty();
    }

    @Override
    @Deprecated
    public void addMessageToConsoleWindow(String message2, TextAttributes attributes) {
        this.addMessageToConsoleWindow(message2, new ConsoleViewContentType("", attributes));
    }

    @Override
    public void addMessageToConsoleWindow(@Nullable String message2, @NotNull ConsoleViewContentType contentType) {
        if (contentType == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(10);
        }
        VcsConsoleTabService.getInstance(this.myProject).addMessage(message2, contentType);
    }

    @Override
    public void addMessageToConsoleWindow(@Nullable VcsConsoleLine line) {
        VcsConsoleTabService.getInstance(this.myProject).addMessage(line);
    }

    @Override
    @NotNull
    public PersistentVcsShowSettingOption getOptions(VcsConfiguration.StandardOption option) {
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = this.myOptionsAndConfirmations.getOption(option);
        if (persistentVcsShowSettingOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(11);
        }
        return persistentVcsShowSettingOption;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowSettingOption> getAllOptions() {
        List<PersistentVcsShowSettingOption> list2 = this.myOptionsAndConfirmations.getAllOptions();
        if (list2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Override
    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option, @NotNull AbstractVcs vcs) {
        if (option == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(13);
        }
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(14);
        }
        PersistentVcsShowSettingOption options = this.getOptions(option);
        options.addApplicableVcs(vcs);
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = options;
        if (persistentVcsShowSettingOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(15);
        }
        return persistentVcsShowSettingOption;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void showProjectOperationInfo(UpdatedFiles updatedFiles, String string2) {
        void displayActionName;
        void updatedFiles2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        UpdateInfoTree tree2 = this.showUpdateProjectInfo((UpdatedFiles)updatedFiles2, (String)displayActionName, ActionInfo.STATUS, false);
        if (tree2 != null) {
            ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, tree2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    @Nullable
    public UpdateInfoTree showUpdateProjectInfo(UpdatedFiles updatedFiles, String string2, ActionInfo actionInfo, boolean bl) {
        void actionInfo2;
        void displayActionName;
        void updatedFiles2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager, this.myProject, (UpdatedFiles)updatedFiles2, (String)displayActionName, (ActionInfo)actionInfo2);
        String tabName = DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
        ContentUtilEx.addTabbedContent((ContentManager)contentManager, (JComponent)((Object)updateInfoTree), (String)"Update Info", VcsBundle.messagePointer("vcs.update.tab.name", new Object[0]), () -> tabName, (boolean)false, (Disposable)updateInfoTree);
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    @Override
    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings.getDirectoryMappings();
    }

    @Override
    public List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs vcs) {
        return this.myMappings.getDirectoryMappings(vcs.getName());
    }

    @Override
    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    @Nullable
    private VcsDirectoryMapping getDirectoryMappingFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    @Override
    public void setDirectoryMapping(@NotNull String path2, @Nullable String activeVcsName) {
        if (path2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(16);
        }
        if (this.myMappingsLoaded) {
            return;
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setMapping(FileUtil.toSystemIndependentName((String)path2), activeVcsName);
    }

    public void registerNewDirectMappings(Collection<Pair<VirtualFile, AbstractVcs>> detectedRoots) {
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(this.myMappings.getDirectoryMappings());
        Set knownMappedRoots = mappings.stream().map(VcsDirectoryMapping::getDirectory).collect(Collectors.toSet());
        List<VcsDirectoryMapping> newMappings = detectedRoots.stream().map(pair -> new VcsDirectoryMapping(((VirtualFile)pair.component1()).getPath(), ((AbstractVcs)pair.component2()).getName())).filter(it -> !knownMappedRoots.contains(it.getDirectory())).toList();
        mappings.addAll(newMappings);
        this.setAutoDirectoryMappings(mappings);
    }

    public void setAutoDirectoryMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(17);
        }
        this.myMappings.setDirectoryMappings(mappings);
        this.myMappings.cleanupMappings();
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(18);
        }
        this.myMappings.removeDirectoryMapping(mapping);
    }

    @Override
    public void setDirectoryMappings(@NotNull List<VcsDirectoryMapping> items2) {
        if (items2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(19);
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setDirectoryMappings(items2);
    }

    @Override
    public void scheduleMappedRootsUpdate() {
        this.myMappings.scheduleMappedRootsUpdate();
    }

    public void updateMappedVcsesImmediately() {
        this.myMappings.updateMappedVcsesImmediately();
    }

    @Override
    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator);
    }

    @Override
    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator, directoryFilter);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        ProjectLevelVcsManagerSerialization.writeExternalUtil(element, this.myOptionsAndConfirmations);
        if (this.myHaveLegacyVcsConfiguration && !this.myProject.isDefault()) {
            element.setAttribute(SETTINGS_EDITED_MANUALLY, "true");
        }
        Element element2 = element;
        if (element2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(20);
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(21);
        }
        ProjectLevelVcsManagerSerialization.readExternalUtil(state, this.myOptionsAndConfirmations);
        Attribute attribute = state.getAttribute(SETTINGS_EDITED_MANUALLY);
        if (attribute != null) {
            try {
                this.myHaveLegacyVcsConfiguration = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    @Override
    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option, AbstractVcs vcs) {
        if (option == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(22);
        }
        PersistentVcsShowConfirmationOption result2 = this.getConfirmation(option);
        if (vcs != null) {
            result2.addApplicableVcs(vcs);
        }
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = result2;
        if (persistentVcsShowConfirmationOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(23);
        }
        return persistentVcsShowConfirmationOption;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowConfirmationOption> getAllConfirmations() {
        List<PersistentVcsShowConfirmationOption> list2 = this.myOptionsAndConfirmations.getAllConfirmations();
        if (list2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @Override
    @NotNull
    public PersistentVcsShowConfirmationOption getConfirmation(VcsConfiguration.StandardConfirmation option) {
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = this.myOptionsAndConfirmations.getConfirmation(option);
        if (persistentVcsShowConfirmationOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(25);
        }
        return persistentVcsShowConfirmationOption;
    }

    @Override
    public void startBackgroundVcsOperation() {
        this.myBackgroundOperationCounter.incrementAndGet();
    }

    @Override
    public void stopBackgroundVcsOperation() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        int counter = this.myBackgroundOperationCounter.getAndDecrement();
        LOG.assertTrue(counter > 0, (Object)("myBackgroundOperationCounter was " + counter + " while should have been > 0"));
    }

    @Override
    public boolean isBackgroundVcsOperationRunning() {
        return this.myBackgroundOperationCounter.get() > 0;
    }

    @Override
    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(AbstractVcs vcs) {
        return this.myMappings.getMappingsAsFilesUnderVcs(vcs);
    }

    @Override
    public VirtualFile @NotNull [] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(26);
        }
        VirtualFile[] virtualFileArray = MappingsToRoots.getRootsUnderVcs(this.myProject, this.myMappings, vcs);
        if (virtualFileArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(27);
        }
        return virtualFileArray;
    }

    @Override
    @Deprecated
    public List<VirtualFile> getDetailedVcsMappings(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(28);
        }
        return MappingsToRoots.getDetailedVcsMappings(this.myProject, this.myMappings, vcs);
    }

    @Override
    public VirtualFile[] getAllVersionedRoots() {
        AbstractVcs[] vcses;
        ArrayList vFiles = new ArrayList();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            Collections.addAll(vFiles, this.getRootsUnderVcs(vcs));
        }
        return VfsUtilCore.toVirtualFileArray(vFiles);
    }

    @Override
    public VcsRoot @NotNull [] getAllVcsRoots() {
        AbstractVcs[] vcses;
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        VcsRoot[] vcsRootArray = vcsRoots.toArray(new VcsRoot[0]);
        if (vcsRootArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(29);
        }
        return vcsRootArray;
    }

    @Override
    public String getConsolidatedVcsName() {
        AbstractVcs singleVcs = this.getSingleVCS();
        return singleVcs != null ? singleVcs.getShortNameWithMnemonic() : VcsBundle.message("vcs.generic.name.with.mnemonic", new Object[0]);
    }

    @Override
    public void notifyDirectoryMappingChanged() {
        ((VcsMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
    }

    void readDirectoryMappings(@NotNull Element element) {
        if (element == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(30);
        }
        ArrayList<VcsDirectoryMapping> mappingsList = new ArrayList<VcsDirectoryMapping>();
        boolean haveNonEmptyMappings = false;
        for (Element child : element.getChildren(ELEMENT_MAPPING)) {
            String vcs = child.getAttributeValue(ATTRIBUTE_VCS);
            String directory = child.getAttributeValue(ATTRIBUTE_DIRECTORY);
            if (directory == null) continue;
            VcsRootSettings rootSettings = null;
            Element rootSettingsElement = child.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement != null) {
                AbstractVcs vcsInstance;
                String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
                AbstractVcs abstractVcs = vcsInstance = vcs == null ? null : this.findVcsByName(vcs);
                if (vcsInstance != null && className != null && (rootSettings = vcsInstance.createEmptyVcsRootSettings()) != null) {
                    try {
                        rootSettings.readExternal(rootSettingsElement);
                    }
                    catch (InvalidDataException e) {
                        LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
                    }
                }
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(directory, vcs, rootSettings);
            mappingsList.add(mapping);
            haveNonEmptyMappings |= !mapping.isDefaultMapping();
        }
        boolean defaultProject = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTRIBUTE_DEFAULT_PROJECT));
        if (haveNonEmptyMappings || !defaultProject) {
            this.myMappingsLoaded = true;
        }
        this.myMappings.setDirectoryMappings(mappingsList);
    }

    void writeDirectoryMappings(@NotNull Element element) {
        if (element == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(31);
        }
        if (this.myProject.isDefault()) {
            element.setAttribute(ATTRIBUTE_DEFAULT_PROJECT, Boolean.TRUE.toString());
        }
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings == null && mapping.isDefaultMapping() && mapping.isNoneMapping()) continue;
            Element child = new Element(ELEMENT_MAPPING);
            child.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child.addContent(rootSettingsElement);
                }
                catch (WriteExternalException writeExternalException) {
                    // empty catch block
                }
            }
            element.addContent(child);
        }
    }

    public boolean needAutodetectMappings() {
        return !this.myHaveLegacyVcsConfiguration && !this.myMappingsLoaded;
    }

    @Override
    @Nullable
    public AbstractVcs findVersioningVcs(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(32);
        }
        HashSet<String> checkedVcses = new HashSet<String>();
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            String vcsName = checker.getSupportedVcs().getName();
            checkedVcses.add(vcsName);
            if (!checker.isRoot(file)) continue;
            return this.findVcsByName(vcsName);
        }
        String foundVcs = null;
        for (VcsDescriptor vcsDescriptor : this.getAllVcss()) {
            String vcsName = vcsDescriptor.getName();
            if (checkedVcses.contains(vcsName) || !vcsDescriptor.probablyUnderVcs(file)) continue;
            if (foundVcs != null) {
                return null;
            }
            foundVcs = vcsName;
        }
        return this.findVcsByName(foundVcs);
    }

    @Override
    @NotNull
    public VcsRootChecker getRootChecker(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(33);
        }
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getIterable()) {
            if (!checker.getSupportedVcs().equals(vcs.getKeyInstanceMethod())) continue;
            VcsRootChecker vcsRootChecker = checker;
            if (vcsRootChecker == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(34);
            }
            return vcsRootChecker;
        }
        return new DefaultVcsRootChecker(vcs, this.getDescriptor(vcs.getName()));
    }

    @Override
    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.myProject);
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
            this.myMappings.notifyMappingsChanged();
        }
    }

    @Override
    @Nullable
    public String haveDefaultMapping() {
        return this.myMappings.haveDefaultMapping();
    }

    boolean isBackgroundTaskRunning(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(35);
        }
        return this.myBackgroundRunningTasks.contains(new ActionKey(keys));
    }

    @RequiresEdt
    void startBackgroundTask(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.add(new ActionKey(keys)));
    }

    @RequiresEdt
    void stopBackgroundTask(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.remove(new ActionKey(keys)));
    }

    public void addInitializationRequest(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        if (vcsInitObject == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(38);
        }
        if (runnable == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(39);
        }
        VcsInitialization.Companion.getInstance(this.myProject).add(vcsInitObject, runnable);
    }

    @Override
    public void runAfterInitialization(@NotNull Runnable runnable) {
        if (runnable == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(40);
        }
        this.addInitializationRequest(VcsInitObject.AFTER_COMMON, runnable);
    }

    @Override
    public boolean isFileInContent(@Nullable VirtualFile vf) {
        if (vf == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            boolean isUnderProject2 = this.isFileInBaseDir(vf) || this.isInDirectoryBasedRoot(vf) || this.hasExplicitMapping(vf) || this.myExcludedIndex.isInContent(vf) || !Registry.is((String)"ide.hide.excluded.files") && this.myExcludedIndex.isExcludedFile(vf);
            return isUnderProject2 && !this.isIgnored(vf);
        });
    }

    @Override
    public boolean isIgnored(@NotNull VirtualFile vf) {
        if (vf == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(41);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                return this.myExcludedIndex.isExcludedFile(vf);
            }
            return this.myExcludedIndex.isUnderIgnored(vf);
        });
    }

    @Override
    public boolean isIgnored(@NotNull FilePath filePath) {
        if (filePath == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(42);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                VirtualFile vf = ChangesUtil.findValidParentAccurately(filePath);
                return vf != null && this.myExcludedIndex.isExcludedFile(vf);
            }
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (String name : StringUtil.tokenize((String)filePath.getPath(), (String)"/")) {
                if (!fileTypeManager.isFileIgnored(name)) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isInDirectoryBasedRoot(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(43);
        }
        if (ProjectKt.isDirectoryBased((Project)this.myProject)) {
            return ProjectKt.getStateStore((Project)this.myProject).isProjectFile(file);
        }
        return false;
    }

    private boolean isFileInBaseDir(@NotNull VirtualFile file) {
        VirtualFile baseDir2;
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(44);
        }
        if ((baseDir2 = this.myProject.getBaseDir()) == null) {
            return false;
        }
        if (file.isDirectory()) {
            return baseDir2.equals(file);
        }
        return baseDir2.equals(file.getParent());
    }

    private boolean hasExplicitMapping(@NotNull VirtualFile vFile) {
        VcsDirectoryMapping mapping;
        if (vFile == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(45);
        }
        return (mapping = this.getDirectoryMappingFor(vFile)) != null && !mapping.isDefaultMapping();
    }

    @Override
    public VcsHistoryCache getVcsHistoryCache() {
        return VcsCacheManager.getInstance(this.myProject).getVcsHistoryCache();
    }

    @Override
    public ContentRevisionCache getContentRevisionCache() {
        return VcsCacheManager.getInstance(this.myProject).getContentRevisionCache();
    }

    @TestOnly
    public void waitForInitialized() {
        VcsInitialization.Companion.getInstance(this.myProject).waitFinished();
    }

    @Override
    public void showConsole() {
        this.showConsole(null);
    }

    @Override
    public void showConsole(@Nullable Runnable then2) {
        VcsConsoleTabService.getInstance(this.myProject).showConsoleTab(true, null);
    }

    @Override
    public void scrollConsoleToTheEnd() {
        VcsConsoleTabService.getInstance(this.myProject).showConsoleTabAndScrollToTheEnd();
    }

    @Override
    public boolean isConsoleVisible() {
        return VcsConsoleTabService.getInstance(this.myProject).isConsoleVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7, 9, 11, 12, 15, 20, 23, 24, 25, 27, 29, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 14: 
            case 26: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_VCS;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MAPPING;
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsInitObject";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSupportedVcss";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationLocalChangesListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameForVcsRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActiveVcss";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardOption";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardConfirmation";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfirmations";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmation";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsUnderVcs";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVcsRoots";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 34: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShortNameForVcsRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterVcs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMessageToConsoleWindow";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStandardOption";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMapping";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAutoDirectoryMappings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeDirectoryMapping";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStandardConfirmation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRootsUnderVcs";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedVcsMappings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "readDirectoryMappings";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writeDirectoryMappings";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findVersioningVcs";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRootChecker";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isBackgroundTaskRunning";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "startBackgroundTask";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "stopBackgroundTask";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addInitializationRequest";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runAfterInitialization";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isInDirectoryBasedRoot";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isFileInBaseDir";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitMapping";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 5, 6, 7, 9, 11, 12, 15, 20, 23, 24, 25, 27, 29, 34 -> new IllegalStateException(string2);
        };
    }

    private static class ActionKey {
        private final Object[] myObjects;

        ActionKey(Object ... objects) {
            if (objects == null) {
                ActionKey.$$$reportNull$$$0(0);
            }
            this.myObjects = objects;
        }

        public final boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.myObjects, ((ActionKey)o).myObjects);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.myObjects);
        }

        public String toString() {
            return this.getClass() + " - " + Arrays.toString(this.myObjects);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActionKey", "<init>"));
        }
    }

    static final class TrustListener
    implements TrustedProjectsListener {
        TrustListener() {
        }

        public void onProjectTrusted(@NotNull Project project2) {
            if (project2 == null) {
                TrustListener.$$$reportNull$$$0(0);
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl(project2).updateMappedVcsesImmediately();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$TrustListener", "onProjectTrusted"));
        }
    }

    static final class ActivateVcsesStartupActivity
    implements VcsStartupActivity {
        ActivateVcsesStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                ActivateVcsesStartupActivity.$$$reportNull$$$0(0);
            }
            project2.getService(VcsDirectoryMappingStorage.class);
            ProjectLevelVcsManagerImpl.getInstanceImpl((Project)project2).myMappings.activateActiveVcses();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActivateVcsesStartupActivity", "runActivity"));
        }
    }
}

