/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.icons.ExpUiIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeEditorDiffPreview;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/impl/ChangesBrowserToolWindow;", "", "()V", "TOOLWINDOW_ID", "", "createDiffPreview", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "changesBrowser", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserBase;", "disposable", "Lcom/intellij/openapi/Disposable;", "getIcon", "Ljavax/swing/Icon;", "registerRepositoriesToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "showTab", "", "content", "Lcom/intellij/ui/content/Content;", "intellij.platform.vcs.impl"})
public final class ChangesBrowserToolWindow {
    @NotNull
    public static final ChangesBrowserToolWindow INSTANCE = new ChangesBrowserToolWindow();
    @NotNull
    public static final String TOOLWINDOW_ID = "VcsChanges";

    private ChangesBrowserToolWindow() {
    }

    @JvmStatic
    public static final void showTab(@NotNull Project project2, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            toolWindow = INSTANCE.registerRepositoriesToolWindow(toolWindowManager);
        }
        ToolWindow repoToolWindow = toolWindow;
        content.putUserData(Content.SIMPLIFIED_TAB_RENDERING_KEY, (Object)true);
        repoToolWindow.getContentManager().removeAllContents(true);
        repoToolWindow.getContentManager().addContent(content);
        repoToolWindow.activate(null);
    }

    @JvmStatic
    @NotNull
    public static final DiffPreview createDiffPreview(@NotNull Project project2, @NotNull ChangesBrowserBase changesBrowser, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changesBrowser, (String)"changesBrowser");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ChangesTree changesTree = changesBrowser.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)changesTree), (String)"getViewer(...)");
        SimpleTreeDiffRequestProcessor processor2 = new SimpleTreeDiffRequestProcessor(project2, "ChangesToolWindowPreview", changesTree, disposable);
        ChangesTree changesTree2 = changesBrowser.getViewer();
        return new SimpleTreeEditorDiffPreview(processor2, project2, changesTree2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                ChangeViewDiffRequestProcessor changeViewDiffRequestProcessor = $processor;
                Intrinsics.checkNotNull((Object)((Object)$super_call_param$1));
                super(changeViewDiffRequestProcessor, $super_call_param$1);
            }

            @NotNull
            protected String getCurrentName() {
                String string2;
                String changeName = this.getChangeViewProcessor().getCurrentChangeName();
                if (changeName != null) {
                    Object[] objectArray = new Object[]{changeName};
                    String string3 = VcsBundle.message("changes.editor.diff.preview.title", objectArray);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                } else {
                    String string4 = VcsBundle.message("changes.editor.diff.preview.empty.title", new Object[0]);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                }
                return string2;
            }

            public void returnFocusToTree() {
                block0: {
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.$project).getToolWindow("VcsChanges");
                    if (toolWindow == null) break block0;
                    toolWindow.activate(null);
                }
            }
        };
    }

    private final ToolWindow registerRepositoriesToolWindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Supplier<String> supplier2 = ChangesBrowserToolWindow::registerRepositoriesToolWindow$lambda$0;
        Icon icon2 = this.getIcon();
        Intrinsics.checkNotNull((Object)toolWindowAnchor);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor, null, false, true, true, false, null, icon2, supplier2, 204, null));
        toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)toolWindow.getContentManager());
        return toolWindow;
    }

    private final Icon getIcon() {
        return ExperimentalUI.Companion.isNewUI() ? ExpUiIcons.Toolwindow.Changes : null;
    }

    private static final String registerRepositoriesToolWindow$lambda$0() {
        return VcsBundle.message("ChangesBrowserToolWindow.toolwindow.name", new Object[0]);
    }
}

