/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.vcs.checkout.CheckoutFolderToTheSameFolder;
import com.intellij.openapi.vcs.checkout.CheckoutToTheDirectoryWithModuleName;
import com.intellij.openapi.vcs.checkout.CreateDirectoryForFolderStrategy;
import com.intellij.openapi.vcs.checkout.SimpleCheckoutStrategy;
import java.io.File;

public abstract class CheckoutStrategy
implements Comparable {
    private final File mySelectedLocation;
    private final File myCvsPath;
    private final boolean myIsForFile;

    public CheckoutStrategy(File selectedLocation, File cvsPath, boolean isForFile) {
        this.mySelectedLocation = selectedLocation;
        this.myCvsPath = cvsPath;
        this.myIsForFile = isForFile;
    }

    public static CheckoutStrategy[] createAllStrategies(File selectedLocation, File cvsPath, boolean isForFile) {
        return new CheckoutStrategy[]{new SimpleCheckoutStrategy(selectedLocation, cvsPath, isForFile), new CheckoutFolderToTheSameFolder(selectedLocation, cvsPath, isForFile), new CreateDirectoryForFolderStrategy(selectedLocation, cvsPath, isForFile), new CheckoutToTheDirectoryWithModuleName(selectedLocation, cvsPath, isForFile)};
    }

    public int compareTo(Object o) {
        if (o instanceof CheckoutStrategy) {
            return this.getResult().compareTo(((CheckoutStrategy)o).getResult());
        }
        return 0;
    }

    public File getSelectedLocation() {
        return this.mySelectedLocation;
    }

    public File getCvsPath() {
        return this.myCvsPath;
    }

    public boolean isForFile() {
        return this.myIsForFile;
    }

    public abstract File getResult();

    public abstract boolean useAlternativeCheckoutLocation();

    public abstract File getCheckoutDirectory();
}

