/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer;
import com.intellij.ui.components.ProgressBarLoadingDecorator;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilterableChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    private final ChangesFilterer myChangesFilterer;
    private ProgressBarLoadingDecorator myLoadingDecorator;

    protected FilterableChangesBrowser(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems) {
        if (project2 == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(0);
        }
        super(project2, showCheckboxes, highlightProblems);
        this.myChangesFilterer = new ChangesFilterer(this.myProject, this::updateTreeOnFilterChange);
        Disposer.register((Disposable)this, (Disposable)this.myChangesFilterer);
    }

    private void updateTreeOnFilterChange() {
        this.myViewer.rebuildTree(ChangesTree.ALWAYS_KEEP);
        this.myViewer.expandDefaults();
        float progress = this.myChangesFilterer.getProgress();
        if (progress == 1.0f) {
            this.myLoadingDecorator.stopLoading();
        } else {
            this.myLoadingDecorator.startLoading();
            this.myLoadingDecorator.getProgressBar().setIndeterminate(progress == 0.0f);
            this.myLoadingDecorator.getProgressBar().setValue((int)(100.0f * progress));
        }
        this.onActiveChangesFilterChanges();
    }

    protected void onActiveChangesFilterChanges() {
    }

    public void dispose() {
    }

    public boolean hasActiveChangesFilter() {
        return this.myChangesFilterer.hasActiveFilter();
    }

    public void clearActiveChangesFilter() {
        this.myChangesFilterer.clearFilter();
    }

    @RequiresEdt
    public ChangesFilterer.FilteredState filterChanges(@NotNull List<? extends Change> changes, boolean shouldFilter) {
        if (changes == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!shouldFilter) {
            this.myChangesFilterer.setChanges(null);
            return ChangesFilterer.FilteredState.create(changes);
        }
        this.myChangesFilterer.setChanges(changes);
        return this.myChangesFilterer.getFilteredChanges();
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(2);
        }
        if (ChangesFilterer.DATA_KEY.is(dataId)) {
            return this.myChangesFilterer;
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        this.myLoadingDecorator = new ProgressBarLoadingDecorator((JPanel)JBUI.Panels.simplePanel((Component)centerPanel), (Disposable)this, 300);
        JComponent jComponent = this.myLoadingDecorator.getComponent();
        if (jComponent == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    protected static void setFilteredChanges(@NotNull TreeModelBuilder builder2, @NotNull ChangesFilterer.FilteredState filteredState, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (builder2 == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(4);
        }
        if (filteredState == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(5);
        }
        builder2.setChanges(filteredState.getChanges(), changeNodeDecorator);
        FilterableChangesBrowser.setPendingChanges(builder2, filteredState.getPending(), changeNodeDecorator);
        FilterableChangesBrowser.setFilteredOutChanges(builder2, filteredState.getFilteredOut(), changeNodeDecorator);
    }

    protected static void setPendingChanges(@NotNull TreeModelBuilder builder2, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (builder2 == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(6);
        }
        if (changes == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(7);
        }
        if (changes.isEmpty()) {
            return;
        }
        ChangesBrowserNode<?> tagNode = builder2.createTagNode(VcsBundle.message("changes.nodetitle.filter.pending", new Object[0]), false);
        builder2.insertChanges(changes, tagNode, changeNodeDecorator);
    }

    protected static void setFilteredOutChanges(@NotNull TreeModelBuilder builder2, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (builder2 == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(8);
        }
        if (changes == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(9);
        }
        if (changes.isEmpty()) {
            return;
        }
        ChangesBrowserNode<?> tagNode = builder2.createTagNode(VcsBundle.message("changes.nodetitle.filtered.out", new Object[0]), false);
        builder2.insertChanges(changes, tagNode, changeNodeDecorator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/browser/FilterableChangesBrowser";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/browser/FilterableChangesBrowser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filterChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFilteredChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPendingChanges";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFilteredOutChanges";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

