/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserConflictsNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/BaseChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getModel", "()Ljavax/swing/tree/DefaultTreeModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getParentNodeFor", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "subtreeRoot", "isMergeConflict", "", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "Companion", "Factory", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultChangesGroupingPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultChangesGroupingPolicy.kt\ncom/intellij/openapi/vcs/changes/ui/DefaultChangesGroupingPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class DefaultChangesGroupingPolicy
extends BaseChangesGroupingPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultTreeModel model;
    @NotNull
    private static final Key<ChangesBrowserNode<?>> CONFLICTS_NODE_CACHE;

    public DefaultChangesGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.project = project2;
        this.model = model2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DefaultTreeModel getModel() {
        return this.model;
    }

    @Override
    @Nullable
    public ChangesBrowserNode<?> getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(subtreeRoot, (String)"subtreeRoot");
        if (this.isMergeConflict(nodePath, node)) {
            ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.Companion.getCachingRoot(subtreeRoot, subtreeRoot);
            ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)CONFLICTS_NODE_CACHE.get((UserDataHolder)cachingRoot);
            if (changesBrowserNode != null) {
                ChangesBrowserNode it = changesBrowserNode;
                boolean bl = false;
                return it;
            }
            ChangesBrowserNode it = changesBrowserNode = new ChangesBrowserConflictsNode(this.project);
            boolean bl = false;
            it.markAsHelperNode();
            this.model.insertNodeInto(it, subtreeRoot, subtreeRoot.getChildCount());
            CONFLICTS_NODE_CACHE.set((UserDataHolder)cachingRoot, (Object)it);
            TreeModelBuilder.IS_CACHING_ROOT.set((UserDataHolder)it, (Object)true);
            return changesBrowserNode;
        }
        return null;
    }

    private final boolean isMergeConflict(StaticFilePath nodePath, ChangesBrowserNode<?> node) {
        if (node instanceof ChangesGroupingPolicy.CompatibilityPlaceholderChangesBrowserNode) {
            VirtualFile virtualFile = nodePath.resolve();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile vFile = virtualFile;
            FileStatus fileStatus = ChangeListManager.getInstance(this.project).getStatus(vFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus status = fileStatus;
            return this.isMergeConflict(status);
        }
        if (node instanceof ChangesBrowserChangeNode) {
            FileStatus fileStatus = ((Change)((ChangesBrowserChangeNode)node).getUserObject()).getFileStatus();
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
            return this.isMergeConflict(fileStatus);
        }
        return false;
    }

    private final boolean isMergeConflict(FileStatus status) {
        return status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.MERGED_WITH_BOTH_CONFLICTS || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
    }

    static {
        Key key2 = Key.create((String)"ChangesTree.ConflictsNodeCache");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CONFLICTS_NODE_CACHE = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0003\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultChangesGroupingPolicy$Companion;", "", "()V", "CONFLICTS_NODE_CACHE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCONFLICTS_NODE_CACHE", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ChangesBrowserNode<?>> getCONFLICTS_NODE_CACHE() {
            return CONFLICTS_NODE_CACHE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "forLocalChanges", "", "(Z)V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        private final boolean forLocalChanges;

        @JvmOverloads
        public Factory(boolean forLocalChanges) {
            this.forLocalChanges = forLocalChanges;
        }

        public /* synthetic */ Factory(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        @Override
        @NotNull
        public ChangesGroupingPolicy createGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            return this.forLocalChanges ? (ChangesGroupingPolicy)new DefaultChangesGroupingPolicy(project2, model2) : (ChangesGroupingPolicy)NoneChangesGroupingPolicy.INSTANCE;
        }

        @JvmOverloads
        public Factory() {
            this(false, 1, null);
        }
    }
}

