/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNodeKt;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.OriginInfo;
import com.intellij.openapi.vcs.impl.PlatformVcsPathPresenter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000 4*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00014B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0002J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J\u001f\u0010%\u001a\u00070&\u00a2\u0006\u0002\b'2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010(\u001a\u00020\bH\u0014J\b\u0010)\u001a\u00020\u001dH\u0016J\b\u0010*\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020,H\u0014J\u0017\u0010.\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010 J(\u0010/\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020,H\u0016J\b\u00103\u001a\u00020&H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00065"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "U", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "userObject", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "(Ljava/lang/Object;Lcom/intellij/openapi/vcs/FileStatus;)V", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "originInfo", "Lcom/intellij/openapi/vcs/changes/ui/OriginInfo;", "getOriginInfo", "()Lcom/intellij/openapi/vcs/changes/ui/OriginInfo;", "originInfo$delegate", "Lkotlin/Lazy;", "getStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "textAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getTextAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "appendOriginText", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "buildOriginInfo", "compareUserObjects", "", "o2", "(Ljava/lang/Object;)I", "(Ljava/lang/Object;)Lcom/intellij/openapi/vcs/FilePath;", "getBackgroundColor", "Ljava/awt/Color;", "project", "Lcom/intellij/openapi/project/Project;", "getRelativePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "path", "getSortWeight", "getTextPresentation", "isDirectory", "", "isFile", "originPath", "render", "selected", "expanded", "hasFocus", "toString", "Companion", "intellij.platform.vcs.impl"})
public abstract class AbstractChangesBrowserFilePathNode<U>
extends ChangesBrowserNode<U> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FileStatus status;
    @NotNull
    private final Lazy originInfo$delegate;

    public AbstractChangesBrowserFilePathNode(U userObject, @Nullable FileStatus status) {
        super(userObject);
        this.status = status;
        this.originInfo$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<OriginInfo>(this){
            final /* synthetic */ AbstractChangesBrowserFilePathNode<U> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final OriginInfo invoke() {
                return AbstractChangesBrowserFilePathNode.access$buildOriginInfo(this.this$0);
            }
        }));
    }

    @Nullable
    public final FileStatus getStatus() {
        return this.status;
    }

    private final FilePath getFilePath() {
        return this.filePath(this.getUserObject());
    }

    private final OriginInfo getOriginInfo() {
        Lazy lazy = this.originInfo$delegate;
        return (OriginInfo)lazy.getValue();
    }

    @NotNull
    protected abstract FilePath filePath(U var1);

    @Nullable
    protected FilePath originPath(U userObject) {
        return null;
    }

    @Override
    protected boolean isFile() {
        return !this.getFilePath().isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return this.getFilePath().isDirectory() && this.isLeaf();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer2), (String)"renderer");
        FilePath path2 = this.getFilePath();
        if (renderer2.isShowFlatten() && this.isLeaf()) {
            renderer2.append(path2.getName(), this.getTextAttributes());
            this.appendOriginText(renderer2);
            this.appendParentPath(renderer2, path2.getParentPath());
        } else {
            renderer2.append(this.getRelativePath(renderer2, path2), this.getTextAttributes());
            this.appendOriginText(renderer2);
        }
        if (!this.isLeaf()) {
            this.appendCount(renderer2);
        }
        renderer2.setIcon(path2, path2.isDirectory() || !this.isLeaf());
    }

    @Override
    @Nullable
    public Color getBackgroundColor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return ChangesBrowserNode.getBackgroundColorFor(project2, this.getFilePath());
    }

    private final void appendOriginText(ChangesBrowserNodeRenderer renderer2) {
        block0: {
            OriginInfo originInfo2 = this.getOriginInfo();
            if (originInfo2 == null) break block0;
            OriginInfo it = originInfo2;
            boolean bl = false;
            renderer2.append(FontUtil.spaceAndThinSpace() + ChangesBrowserFilePathNodeKt.access$getText(it), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private final OriginInfo buildOriginInfo() {
        OriginInfo originInfo2;
        FilePath filePath = this.originPath(this.getUserObject());
        if (filePath == null) {
            return null;
        }
        FilePath originPath = filePath;
        FilePath path2 = this.getFilePath();
        boolean areParentsEqual = ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)path2.getParentPath(), (Object)originPath.getParentPath());
        if (!areParentsEqual) {
            String string2 = PlatformVcsPathPresenter.getPresentableRelativePath(path2, originPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableRelativePath(...)");
            originInfo2 = new OriginInfo.Moved(string2);
        } else if (!Intrinsics.areEqual((Object)path2.getName(), (Object)originPath.getName())) {
            String string3 = originPath.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            originInfo2 = new OriginInfo.Renamed(string3);
        } else {
            originInfo2 = null;
        }
        return originInfo2;
    }

    private final SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes;
        if (this.status != null) {
            simpleTextAttributes = new SimpleTextAttributes(0, this.status.getColor());
        } else {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }

    @NotNull
    protected String getRelativePath(@Nullable ChangesBrowserNodeRenderer renderer2, @NotNull FilePath path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        boolean isLocal = !path2.isNonLocal();
        FilePath parentPath = Companion.safeCastToFilePath((ChangesBrowserNode<?>)this.getParent());
        if (parentPath != null) {
            String string2;
            boolean caseSensitive = isLocal && SystemInfo.isFileSystemCaseSensitive;
            String relativePath = FileUtil.getRelativePath((String)parentPath.getPath(), (String)path2.getPath(), (char)'/', (boolean)caseSensitive);
            String string3 = relativePath;
            if (string3 == null) {
                String string4 = path2.getPath();
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            }
            String prettyPath = string3;
            if (isLocal) {
                String string5 = FileUtil.toSystemDependentName((String)prettyPath);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toSystemDependentName(...)");
            } else {
                string2 = prettyPath;
            }
            return string2;
        }
        if (isLocal) {
            ChangesBrowserNodeRenderer changesBrowserNodeRenderer = renderer2;
            String string6 = VcsUtil.getPresentablePath((Project)(changesBrowserNodeRenderer != null ? changesBrowserNodeRenderer.getProject() : null), path2, true, false);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPresentablePath(...)");
            return string6;
        }
        String string7 = path2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getPath(...)");
        return string7;
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        return this.getRelativePath(null, this.getFilePath());
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        return string2;
    }

    @Override
    public int getSortWeight() {
        return this.getFilePath().isDirectory() ? 5 : 6;
    }

    @Override
    public int compareUserObjects(U o2) {
        return ChangesBrowserNode.compareFilePaths(this.getFilePath(), this.filePath(o2));
    }

    @JvmStatic
    @Nullable
    public static final FilePath safeCastToFilePath(@Nullable ChangesBrowserNode<?> node) {
        return Companion.safeCastToFilePath(node);
    }

    public static final /* synthetic */ OriginInfo access$buildOriginInfo(AbstractChangesBrowserFilePathNode $this) {
        return $this.buildOriginInfo();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode$Companion;", "", "()V", "safeCastToFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final FilePath safeCastToFilePath(@Nullable ChangesBrowserNode<?> node) {
            if (node == null) {
                return null;
            }
            if (node instanceof ChangesBrowserNode.NodeWithFilePath) {
                return ((ChangesBrowserNode.NodeWithFilePath)((Object)node)).getNodeFilePath();
            }
            Object o = node.getUserObject();
            if (o instanceof FilePath) {
                return (FilePath)o;
            }
            if (o instanceof Change) {
                return ChangesUtil.getAfterPath((Change)o);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

